/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class ConnectionLimit
extends AbstractLifeCycle
implements Connection.Listener {
    private static final Logger LOG = Log.getLogger(ConnectionLimit.class);
    private final Server _server;
    private final List<AbstractConnector> _connectors = new ArrayList<AbstractConnector>();
    private int _connections;
    private int _maxConnections;
    private boolean _accepting = true;

    public ConnectionLimit(int maxConnections, Server server) {
        this._maxConnections = maxConnections;
        this._server = server;
    }

    public ConnectionLimit(int maxConnections, Connector ... connectors) {
        this._maxConnections = maxConnections;
        this._server = null;
        for (Connector c : connectors) {
            if (c instanceof AbstractConnector) {
                this._connectors.add((AbstractConnector)c);
                continue;
            }
            LOG.warn("Connector {} is not an AbstractConnection. Connections not limited", new Object[]{c});
        }
    }

    @ManagedAttribute(value="The maximum number of connections allowed")
    public synchronized int getMaxConnections() {
        return this._maxConnections;
    }

    public synchronized void setMaxConnections(int max) {
        this._maxConnections = max;
    }

    @ManagedAttribute(value="The current number of connections ")
    public synchronized int getConnections() {
        return this._connections;
    }

    protected synchronized void doStart() throws Exception {
        if (this._server != null) {
            for (Connector c : this._server.getConnectors()) {
                if (c instanceof AbstractConnector) {
                    this._connectors.add((AbstractConnector)c);
                    continue;
                }
                LOG.warn("Connector {} is not an AbstractConnection. Connections not limited", new Object[]{c});
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ConnectionLimit {} for {}", new Object[]{this._maxConnections, this._connectors});
        }
        this._connections = 0;
        this._accepting = true;
        for (AbstractConnector c : this._connectors) {
            c.addBean((Object)this);
        }
    }

    protected synchronized void doStop() throws Exception {
        for (AbstractConnector c : this._connectors) {
            c.removeBean((Object)this);
        }
        this._connections = 0;
        if (this._server != null) {
            this._connectors.clear();
        }
    }

    public synchronized void onOpened(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {} < {} {}", new Object[]{this._connections, this._maxConnections, connection});
        }
        if (++this._connections >= this._maxConnections && this._accepting) {
            this._accepting = false;
            LOG.info("Connection Limit({}) reached for {}", new Object[]{this._maxConnections, this._connectors});
            for (AbstractConnector c : this._connectors) {
                c.setAccepting(false);
            }
        }
    }

    public synchronized void onClosed(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClosed {} < {} {}", new Object[]{this._connections, this._maxConnections, connection});
        }
        if (--this._connections < this._maxConnections && !this._accepting) {
            this._accepting = true;
            LOG.info("Connection Limit({}) cleared for {}", new Object[]{this._maxConnections, this._connectors});
            for (AbstractConnector c : this._connectors) {
                c.setAccepting(true);
            }
        }
    }
}

