/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.m2e.core.internal.embedder.FilterRepositorySystemSession;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ProjectCachePlunger<Key> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final Multimap<File, Key> projectKeys = HashMultimap.create();
    final Multimap<Key, File> keyProjects = HashMultimap.create();

    ProjectCachePlunger() {
    }

    public void register(MavenProject project, Key cacheKey) {
        File file = project.getFile();
        if (file != null) {
            this.projectKeys.put((Object)file, cacheKey);
            this.keyProjects.put(cacheKey, (Object)file);
        }
    }

    public Set<File> removeProject(File pom, boolean forceDependencyUpdate) {
        FilterRepositorySystemSession session;
        MavenExecutionContext context = MavenExecutionContext.getThreadContext();
        FilterRepositorySystemSession filterRepositorySystemSession = session = context != null ? context.getRepositorySession() : null;
        if (forceDependencyUpdate && session == null) {
            throw new IllegalArgumentException();
        }
        HashSet<File> affectedProjects = new HashSet<File>();
        for (Object cacheKey : this.projectKeys.removeAll((Object)pom)) {
            this.keyProjects.remove(cacheKey, (Object)pom);
            if (forceDependencyUpdate && "always".equals(session.getUpdatePolicy()) && session.getCache().get((RepositorySystemSession)session, cacheKey) == null) {
                session.getCache().put((RepositorySystemSession)session, cacheKey, (Object)Boolean.TRUE);
                for (File affectedPom : this.keyProjects.removeAll(cacheKey)) {
                    affectedProjects.add(affectedPom);
                    this.projectKeys.remove((Object)affectedPom, cacheKey);
                }
            }
            if (this.keyProjects.containsKey(cacheKey)) continue;
            this.flush(cacheKey);
            this.log.debug("Flushed cache entry for {}", cacheKey);
        }
        return affectedProjects;
    }

    protected void disposeClassRealm(ClassRealm realm) {
        try {
            realm.getWorld().disposeRealm(realm.getId());
        }
        catch (NoSuchRealmException noSuchRealmException) {
            // empty catch block
        }
    }

    protected abstract void flush(Key var1);

    public void flush() {
        this.projectKeys.clear();
        this.keyProjects.clear();
    }
}

