/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tabpane.skin;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.animation.ScaleTransition;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.dnd.EFXDragEvent;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.controls.tabpane.GenericTab;
import org.eclipse.fx.ui.controls.tabpane.skin.DndTabPaneSkinHooker;
import org.eclipse.fx.ui.controls.tabpane.skin.FXTabWrapper;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DnDTabPaneSkinHookerFullDrag
implements DndTabPaneFactory.DragSetup {
    private static Tab DRAGGED_TAB;
    private final TabPane pane;
    private @Nullable Function<@NonNull GenericTab, @NonNull Boolean> startFunction;
    private @Nullable Consumer<@NonNull GenericTab> dragFinishedConsumer;
    private @Nullable Consumer< @NonNull DndTabPaneFactory.FeedbackData> feedbackConsumer;
    private @Nullable Consumer< @NonNull DndTabPaneFactory.DroppedData> dropConsumer;
    private @Nullable Function<@NonNull GenericTab, @NonNull String> clipboardDataFunction;

    public DnDTabPaneSkinHookerFullDrag(Skin<TabPane> skin) {
        this.pane = (TabPane)skin.getSkinnable();
        Optional<Node> o_TabHeaderArea = ((SkinBase)skin).getChildren().stream().filter(e -> e.getClass().getSimpleName().equals("TabHeaderArea")).findFirst();
        if (!o_TabHeaderArea.isPresent() || !(o_TabHeaderArea.get() instanceof Pane)) {
            LoggerCreator.createLogger(DndTabPaneSkinHooker.class).warning("Could not find a supported TabHeaderArea pane. DnD is disabled.");
            return;
        }
        Pane tabHeaderArea = (Pane)o_TabHeaderArea.get();
        Optional<Node> o_HeadersRegion = tabHeaderArea.getChildren().stream().filter(e -> e.getStyleClass().contains((Object)"headers-region")).findFirst();
        if (!o_HeadersRegion.isPresent() || !(o_HeadersRegion.get() instanceof Pane)) {
            LoggerCreator.createLogger(DndTabPaneSkinHooker.class).warning("Could not find a supported HeadersRegion pane. DnD is disabled.");
            return;
        }
        Pane headersRegion = (Pane)o_HeadersRegion.get();
        EventHandler handler = this::tabPane_handleDragStart;
        EventHandler handlerFinished = this::tabPane_handleDragDone;
        EventHandler handle_mouseDragged = this::handle_mouseDragged;
        EventHandler handleMouseReleased = this::handleMouseReleased;
        for (Node tabHeaderSkin : headersRegion.getChildren()) {
            tabHeaderSkin.addEventHandler(MouseEvent.DRAG_DETECTED, handler);
            tabHeaderSkin.addEventHandler(MouseEvent.MOUSE_DRAGGED, handle_mouseDragged);
            tabHeaderSkin.addEventHandler(MouseEvent.MOUSE_RELEASED, handleMouseReleased);
            tabHeaderSkin.addEventHandler(EFXDragEvent.DRAG_DONE, handlerFinished);
        }
        headersRegion.getChildren().addListener(change -> {
            while (change.next()) {
                if (change.wasRemoved()) {
                    change.getRemoved().forEach(e -> e.removeEventHandler(MouseEvent.DRAG_DETECTED, handler));
                    change.getRemoved().forEach(e -> e.removeEventHandler(MouseEvent.MOUSE_DRAGGED, handle_mouseDragged));
                    change.getRemoved().forEach(e -> e.removeEventHandler(MouseEvent.MOUSE_RELEASED, handleMouseReleased));
                }
                if (!change.wasAdded()) continue;
                change.getAddedSubList().forEach(e -> e.addEventHandler(MouseEvent.DRAG_DETECTED, handler));
                change.getAddedSubList().forEach(e -> e.addEventHandler(MouseEvent.MOUSE_DRAGGED, handle_mouseDragged));
                change.getAddedSubList().forEach(e -> e.addEventHandler(MouseEvent.MOUSE_RELEASED, handleMouseReleased));
            }
        });
        tabHeaderArea.addEventHandler(EFXDragEvent.DRAG_OVER, e -> this.tabPane_handleDragOver(tabHeaderArea, headersRegion, (EFXDragEvent)e));
        tabHeaderArea.addEventHandler(EFXDragEvent.DRAG_DROPPED, e -> this.tabPane_handleDragDropped(tabHeaderArea, headersRegion, (EFXDragEvent)e));
        this.pane.addEventHandler(EFXDragEvent.DRAG_DONE, this::tabPane_handleDragDone);
    }

    @Override
    public void setClipboardDataFunction(@Nullable Function<@NonNull GenericTab, @NonNull String> clipboardDataFunction) {
        this.clipboardDataFunction = clipboardDataFunction;
    }

    @Override
    public void setDragFinishedConsumer(Consumer<@NonNull GenericTab> dragFinishedConsumer) {
        this.dragFinishedConsumer = dragFinishedConsumer;
    }

    @Override
    public void setDropConsumer(Consumer< @NonNull DndTabPaneFactory.DroppedData> dropConsumer) {
        this.dropConsumer = dropConsumer;
    }

    @Override
    public void setFeedbackConsumer(Consumer< @NonNull DndTabPaneFactory.FeedbackData> feedbackConsumer) {
        this.feedbackConsumer = feedbackConsumer;
    }

    @Override
    public void setStartFunction(@Nullable Function<@NonNull GenericTab, @NonNull Boolean> startFunction) {
        this.startFunction = startFunction;
    }

    private Tab getTab(Node n) {
        int tabIdx = n.getParent().getChildrenUnmodifiable().indexOf((Object)n);
        return (Tab)this.pane.getTabs().get(tabIdx);
    }

    void tabPane_handleDragStart(MouseEvent event) {
        try {
            Tab t = this.getTab((Node)event.getSource());
            if (t != null && this.efx_canStartDrag(FXTabWrapper.wrap(t))) {
                DRAGGED_TAB = t;
                Node n = (Node)event.getSource();
                n.startFullDrag();
                String data = this.efx_getClipboardContent(FXTabWrapper.wrap(t));
                EFXDragEvent evt = new EFXDragEvent(event.getSource(), event.getTarget(), EFXDragEvent.DRAG_START, event.getScreenX(), event.getScreenY(), false);
                evt.setDraggedContent(data);
                evt.updateFeedback(p -> {
                    SnapshotParameters snapshotParameters = new SnapshotParameters();
                    snapshotParameters.setFill((Paint)Color.TRANSPARENT);
                    WritableImage snapShot = n.snapshot(snapshotParameters, null);
                    ImageView v = new ImageView((Image)snapShot);
                    ScaleTransition st = new ScaleTransition(Duration.millis((double)200.0), (Node)v);
                    st.setFromX(0.0);
                    st.setToX(1.0);
                    st.play();
                    p.getChildren().add((Object)v);
                });
                Event.fireEvent((EventTarget)event.getTarget(), (Event)evt);
                event.consume();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void tabPane_handleDragDone(EFXDragEvent event) {
        Tab tab = DRAGGED_TAB;
        if (tab == null) {
            return;
        }
        this.efx_dragFinished(FXTabWrapper.wrap(tab));
    }

    void handle_mouseDragged(MouseEvent e) {
        if (DRAGGED_TAB == null) {
            return;
        }
        Node node = Util.findNode(null, e.getScreenX(), e.getScreenY());
        if (node != null) {
            ((Stage)node.getScene().getWindow()).toFront();
            Event.fireEvent((EventTarget)node, (Event)new EFXDragEvent(this, (EventTarget)node, EFXDragEvent.DRAG_OVER, e.getScreenX(), e.getScreenY(), false));
        } else {
            EFXDragEvent.updateFeedbackLocation(e.getScreenX(), e.getScreenY());
        }
    }

    void tabPane_handleDragOver(Pane tabHeaderArea, Pane headersRegion, EFXDragEvent event) {
        Tab draggedTab = DRAGGED_TAB;
        if (draggedTab == null) {
            return;
        }
        event.consume();
        double x = event.getX() - headersRegion.getBoundsInParent().getMinX();
        Node referenceNode = null;
        DndTabPaneFactory.DropType type = DndTabPaneFactory.DropType.AFTER;
        for (Node n : headersRegion.getChildren()) {
            Bounds b = n.getBoundsInParent();
            if (!(b.getMaxX() > x)) continue;
            if (b.getMinX() + b.getWidth() / 2.0 > x) {
                referenceNode = n;
                type = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            referenceNode = n;
            type = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (referenceNode == null && headersRegion.getChildren().size() > 0) {
            referenceNode = (Node)headersRegion.getChildren().get(headersRegion.getChildren().size() - 1);
            type = DndTabPaneFactory.DropType.AFTER;
        }
        if (referenceNode != null) {
            try {
                Tab tab = this.getTab(referenceNode);
                boolean noMove = false;
                if (tab == draggedTab) {
                    noMove = true;
                } else if (type == DndTabPaneFactory.DropType.BEFORE) {
                    int idx = this.pane.getTabs().indexOf((Object)tab);
                    if (idx > 0 && this.pane.getTabs().get(idx - 1) == draggedTab) {
                        noMove = true;
                    }
                } else {
                    int idx = this.pane.getTabs().indexOf((Object)tab);
                    if (idx + 1 < this.pane.getTabs().size() && this.pane.getTabs().get(idx + 1) == draggedTab) {
                        noMove = true;
                    }
                }
                if (noMove) {
                    this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), null, null, DndTabPaneFactory.DropType.NONE);
                    return;
                }
                Bounds b = referenceNode.getBoundsInLocal();
                b = referenceNode.localToScene(b);
                b = this.pane.sceneToLocal(b);
                this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), FXTabWrapper.wrap(tab), b, type);
            }
            catch (Throwable e) {
                LoggerCreator.createLogger(this.getClass()).error("Failure while handling drag over", e);
            }
        } else {
            this.efx_dragFeedback(FXTabWrapper.wrap(draggedTab), null, null, DndTabPaneFactory.DropType.NONE);
        }
    }

    void tabPane_handleDragDropped(Pane tabHeaderArea, Pane headersRegion, EFXDragEvent event) {
        Tab draggedTab = DRAGGED_TAB;
        if (draggedTab == null) {
            return;
        }
        double x = event.getX() - headersRegion.getBoundsInParent().getMinX();
        Node referenceNode = null;
        DndTabPaneFactory.DropType type = DndTabPaneFactory.DropType.AFTER;
        for (Node n : headersRegion.getChildren()) {
            Bounds b = n.getBoundsInParent();
            if (!(b.getMaxX() > x)) continue;
            if (b.getMinX() + b.getWidth() / 2.0 > x) {
                referenceNode = n;
                type = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            referenceNode = n;
            type = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (referenceNode == null && headersRegion.getChildren().size() > 0) {
            referenceNode = (Node)headersRegion.getChildren().get(headersRegion.getChildren().size() - 1);
            type = DndTabPaneFactory.DropType.AFTER;
        }
        if (referenceNode != null) {
            try {
                Tab tab = this.getTab(referenceNode);
                boolean noMove = false;
                if (tab == null) {
                    event.setComplete(false);
                    return;
                }
                if (tab == draggedTab) {
                    noMove = true;
                } else if (type == DndTabPaneFactory.DropType.BEFORE) {
                    int idx = this.pane.getTabs().indexOf((Object)tab);
                    if (idx > 0 && this.pane.getTabs().get(idx - 1) == draggedTab) {
                        noMove = true;
                    }
                } else {
                    int idx = this.pane.getTabs().indexOf((Object)tab);
                    if (idx + 1 < this.pane.getTabs().size() && this.pane.getTabs().get(idx + 1) == draggedTab) {
                        noMove = true;
                    }
                }
                if (!noMove) {
                    this.efx_dropped(event.getScreenX(), event.getScreenY(), FXTabWrapper.wrap(draggedTab), FXTabWrapper.wrap(tab), type);
                    event.setComplete(true);
                } else {
                    event.setComplete(false);
                }
            }
            catch (Throwable e) {
                LoggerCreator.createLogger(this.getClass()).error("Error while handling drop", e);
            }
            event.consume();
        }
    }

    private void handleMouseReleased(MouseEvent e) {
        if (DRAGGED_TAB == null) {
            return;
        }
        boolean isComplete = false;
        try {
            Node node = Util.findNode(null, e.getScreenX(), e.getScreenY());
            if (node != null) {
                EFXDragEvent event = new EFXDragEvent(node, (EventTarget)node, EFXDragEvent.DRAG_DROPPED, e.getScreenX(), e.getScreenY(), false);
                Event.fireEvent((EventTarget)node, (Event)event);
                isComplete = event.isComplete();
            } else {
                this.efx_dropped(e.getScreenX(), e.getScreenY(), FXTabWrapper.wrap(DRAGGED_TAB), null, DndTabPaneFactory.DropType.DETACH);
            }
        }
        finally {
            Event.fireEvent((EventTarget)this.pane, (Event)new EFXDragEvent(this.pane, (EventTarget)this.pane, EFXDragEvent.DRAG_DONE, e.getScreenX(), e.getScreenY(), isComplete));
            DRAGGED_TAB = null;
        }
    }

    private boolean efx_canStartDrag(@NonNull GenericTab tab) {
        if (this.startFunction != null) {
            return this.startFunction.apply(tab);
        }
        return true;
    }

    private void efx_dragFeedback(@NonNull GenericTab draggedTab, GenericTab targetTab, Bounds bounds,  @NonNull DndTabPaneFactory.DropType dropType) {
        if (this.feedbackConsumer != null) {
            this.feedbackConsumer.accept(new DndTabPaneFactory.FeedbackData(draggedTab, targetTab, bounds, dropType));
        }
    }

    private void efx_dropped(double x, double y, @NonNull GenericTab draggedTab, @Nullable GenericTab targetTab,  @NonNull DndTabPaneFactory.DropType dropType) {
        if (this.dropConsumer != null) {
            this.dropConsumer.accept(new DndTabPaneFactory.DroppedData(x, y, draggedTab, targetTab, dropType));
        }
    }

    private void efx_dragFinished(@NonNull GenericTab tab) {
        if (this.dragFinishedConsumer != null) {
            this.dragFinishedConsumer.accept(tab);
        }
    }

    private String efx_getClipboardContent(@NonNull GenericTab t) {
        if (this.clipboardDataFunction != null) {
            return this.clipboardDataFunction.apply(t);
        }
        return String.valueOf(System.identityHashCode(t));
    }
}

