/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.workbench.renderers.base.BasePartRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPart;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolBar;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.CustomContainerSupport;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;

public class DefPartRenderer
extends BasePartRenderer<Pane, Node, Node> {
    private static final String TOOLBAR_MENU_FLOAT_TAG = "Part-ToolBarMenu-Floating";
    private static final String TOOLBAR_MENU_COLLAPSIBLE_TAG = "Part-ToolBarMenu-Collapsible";
    private static final String TOOLBAR_MENU_BOTTOM_TAG = "Part-ToolBarMenu-Bottom";
    private static final String TOOL_BAR_FULL_SPAN_TAG = "Part-Toolbar-FullSpan";

    protected Class<? extends WPart<Pane, Node, Node>> getWidgetClass(MPart part) {
        return PartImpl.class;
    }

    protected boolean requiresFocus(WPart<Pane, Node, Node> widget) {
        Node n = (Node)widget.getWidget();
        do {
            if (n.getUserData() != widget) continue;
            return false;
        } while ((n = n.getParent()) != null);
        return true;
    }

    public void focus(MUIElement element) {
        super.focus(element);
        if (element.getWidget() instanceof WPart) {
            WPart part = (WPart)element.getWidget();
            if (part == null) {
                return;
            }
            Node node = (Node)part.getWidget();
            node.requestFocus();
        }
    }

    static class HandleGroup
    extends Group {
        public double minHeight(double width) {
            return 11.0;
        }

        public double maxWidth(double height) {
            return 20.0;
        }

        public HandleGroup() {
            Rectangle r = new Rectangle(16.0, 1.0);
            r.setFill((Paint)Color.WHITE);
            r.setStroke((Paint)Color.BLACK);
            r.setLayoutX(0.0);
            r.setLayoutY(1.0);
            r.setStrokeType(StrokeType.OUTSIDE);
            this.getChildren().add((Object)r);
            r = new Rectangle(16.0, 1.0);
            r.setFill((Paint)Color.WHITE);
            r.setStroke((Paint)Color.BLACK);
            r.setLayoutX(0.0);
            r.setLayoutY(4.0);
            r.setStrokeType(StrokeType.OUTSIDE);
            this.getChildren().add((Object)r);
            r = new Rectangle(16.0, 1.0);
            r.setFill((Paint)Color.WHITE);
            r.setStroke((Paint)Color.BLACK);
            r.setLayoutX(0.0);
            r.setLayoutY(7.0);
            r.setStrokeType(StrokeType.OUTSIDE);
            this.getChildren().add((Object)r);
        }
    }

    public static class PartImpl
    extends WLayoutedWidgetImpl<Pane, AnchorPane, MPart>
    implements WPart<Pane, Node, Node> {
        @Inject
        EPartService service;
        @Inject
        IEclipseContext context;
        private AnchorPane contentArea;
        private BorderPane dataArea;
        private StackPane expandGroup;
        private StackPane toolbarGroup;
        private Group menuGroup;

        @Override
        protected Pane createWidget() {
            Pane tmp = CustomContainerSupport.createContainerPane(this.logger, this.context);
            final Pane p = tmp == null ? new BorderPane() : tmp;
            p.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    event.consume();
                    MPart domElement = (MPart)PartImpl.this.getDomElement();
                    PartImpl.this.service.activate(domElement, true);
                    if (!PartImpl.this.checkFocusControl() && domElement.getObject() != null) {
                        ContextInjectionFactory.invoke((Object)domElement.getObject(), Focus.class, (IEclipseContext)domElement.getContext(), null);
                        if (!PartImpl.this.checkFocusControl()) {
                            p.requestFocus();
                        }
                    }
                }
            });
            return p;
        }

        /*
         * Unable to fully structure code
         */
        private boolean checkFocusControl() {
            check = (Parent)this.getWidget();
            if (check == null || check.getScene() == null) {
                return false;
            }
            n = check.getScene().getFocusOwner();
            if (n != null) ** GOTO lbl10
            return false;
lbl-1000:
            // 1 sources

            {
                if (n.getParent() == check) {
                    return true;
                }
                n = n.getParent();
lbl10:
                // 2 sources

                ** while (n.getParent() != null)
            }
lbl11:
            // 1 sources

            return false;
        }

        @Override
        protected AnchorPane getWidgetNode() {
            if (this.contentArea == null) {
                this.menuGroup = new Group();
                this.menuGroup.setVisible(false);
                this.menuGroup.setManaged(false);
                this.expandGroup = new StackPane();
                this.expandGroup.setStyle("-fx-background-color: gray");
                this.expandGroup.setOpacity(0.5);
                HandleGroup handler = new HandleGroup();
                handler.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        PartImpl.this.toolbarGroup.getParent().setVisible(true);
                    }
                });
                this.expandGroup.getChildren().add((Object)handler);
                this.contentArea = new AnchorPane(){

                    protected void layoutChildren() {
                        super.layoutChildren();
                        if (PartImpl.this.menuGroup.isVisible()) {
                            PartImpl.this.menuGroup.relocate(PartImpl.this.contentArea.getWidth() - 20.0, 0.0);
                        }
                    }
                };
                this.dataArea = new BorderPane();
                AnchorPane.setTopAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setRightAnchor((Node)this.dataArea, (Double)0.0);
                this.contentArea.getChildren().addAll((Object[])new Node[]{this.dataArea, this.menuGroup});
                Node n = (Node)this.getWidget();
                if (n != null) {
                    n.getStyleClass().add((Object)"part-content");
                    this.dataArea.setCenter(n);
                } else {
                    this.logger.log(Logger.Level.ERROR, "No widget node to attach");
                }
            }
            return this.contentArea;
        }

        private void initToolbarMenu() {
            if (this.toolbarGroup == null) {
                this.getStaticLayoutNode();
                this.toolbarGroup = new StackPane();
                if (((MPart)this.getDomElement()).getTags().contains(DefPartRenderer.TOOL_BAR_FULL_SPAN_TAG)) {
                    final BorderPane p = new BorderPane();
                    p.setCenter((Node)this.toolbarGroup);
                    p.getStyleClass().add((Object)"view-toolbar-container");
                    if (((MPart)this.getDomElement()).getTags().contains(DefPartRenderer.TOOLBAR_MENU_FLOAT_TAG)) {
                        AnchorPane.setLeftAnchor((Node)p, (Double)0.0);
                        AnchorPane.setRightAnchor((Node)p, (Double)1.0);
                        AnchorPane.setTopAnchor((Node)p, (Double)0.0);
                        this.contentArea.getChildren().add((Object)p);
                        p.setVisible(false);
                        this.dataArea.setTop((Node)this.expandGroup);
                        this.expandGroup.setVisible(true);
                        p.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                p.setVisible(false);
                            }
                        });
                    } else if (((MPart)this.getDomElement()).getTags().contains(DefPartRenderer.TOOLBAR_MENU_BOTTOM_TAG)) {
                        this.dataArea.setBottom((Node)p);
                    } else {
                        this.dataArea.setTop((Node)p);
                    }
                } else {
                    BorderPane p = new BorderPane();
                    p.setRight((Node)this.toolbarGroup);
                    p.getStyleClass().add((Object)"view-toolbar-container");
                    if (((MPart)this.getDomElement()).getTags().contains(DefPartRenderer.TOOLBAR_MENU_BOTTOM_TAG)) {
                        this.dataArea.setBottom((Node)p);
                    } else {
                        this.dataArea.setTop((Node)p);
                    }
                }
            }
        }

        public void setToolbar(WToolBar<Node> widget) {
            if (widget == null) {
                if (this.toolbarGroup != null) {
                    this.toolbarGroup.getChildren().clear();
                    this.dataArea.setTop(null);
                    this.dataArea.setBottom(null);
                }
            } else {
                this.initToolbarMenu();
                Node n = (Node)widget.getWidget();
                n.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        if (((MPart)PartImpl.this.getDomElement()).getTags().contains(DefPartRenderer.TOOLBAR_MENU_FLOAT_TAG)) {
                            PartImpl.this.toolbarGroup.getParent().setVisible(false);
                        }
                    }
                });
                n.getStyleClass().add((Object)"view-toolbar");
                this.toolbarGroup.getChildren().setAll((Object[])new Node[]{n});
            }
        }

        public void setMenu(WMenu<Node> widget) {
            if (widget == null) {
                if (this.menuGroup != null) {
                    this.menuGroup.setVisible(false);
                    this.menuGroup.getChildren().clear();
                }
            } else {
                this.menuGroup.setVisible(true);
                this.menuGroup.getChildren().setAll((Object[])new Node[]{(Node)widget.getWidget()});
            }
        }
    }
}

