/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.fx.ui.workbench.renderers.base.BasePerspectiveStackRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.services.PerspectiveTransitionService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPerspectiveStack;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.PerspectiveStackItem;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;

public class DefPerspectiveStackRenderer
extends BasePerspectiveStackRenderer<BorderPane, PerspectiveStackItem, Node> {
    protected Class<? extends WPerspectiveStack<BorderPane, PerspectiveStackItem, Node>> getWidgetClass(MPerspectiveStack stack) {
        return PerspectiveStackImpl.class;
    }

    public static class PerspectiveStackImpl
    extends WLayoutedWidgetImpl<BorderPane, BorderPane, MPerspectiveStack>
    implements WPerspectiveStack<BorderPane, PerspectiveStackItem, Node> {
        private List<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> items = new ArrayList<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>>();
        private int currentIndex;
        @Inject
        @Optional
        private PerspectiveTransitionService<BorderPane, Node> perspectiveSwitch;

        public Class<? extends WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> getStackItemClass() {
            return PerspectiveStackItemImpl.class;
        }

        public void addItem(WPerspectiveStack.WStackItem<PerspectiveStackItem, Node> item) {
            this.items.add(item);
        }

        public void addItems(List<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> items) {
            this.items.addAll(items);
        }

        public void addItems(int index, List<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> items) {
            this.items.addAll(index, items);
        }

        public void selectItem(int idx) {
            WPerspectiveStack.WStackItem<PerspectiveStackItem, Node> item = this.items.get(idx);
            Node node = ((PerspectiveStackItem)item.getNativeItem()).getContent();
            if (((BorderPane)this.getWidget()).getCenter() != null && this.perspectiveSwitch != null) {
                PerspectiveTransitionService.AnimationDelegate a = this.perspectiveSwitch.getDelegate(this.items.get(this.currentIndex).getDomElement(), item.getDomElement());
                if (a == null) {
                    ((BorderPane)this.getWidget()).setCenter(node);
                } else {
                    a.animate((Object)((BorderPane)this.getWidget()), (Object)node);
                }
            } else {
                ((BorderPane)this.getWidget()).setCenter(node);
            }
            this.currentIndex = idx;
        }

        public int indexOf(WPerspectiveStack.WStackItem<PerspectiveStackItem, Node> item) {
            return this.items.indexOf(item);
        }

        public List<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> getItems() {
            return this.items;
        }

        public void removeItems(List<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>> items) {
            this.items.removeAll(items);
        }

        public void setMouseSelectedItemCallback(WCallback<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>, Void> selectedItemCallback) {
        }

        public void setKeySelectedItemCallback(WCallback<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>, Void> selectedItemCallback) {
        }

        public int getItemCount() {
            return this.items.size();
        }

        @Override
        protected BorderPane getWidgetNode() {
            return (BorderPane)this.getWidget();
        }

        @Override
        protected BorderPane createWidget() {
            return new BorderPane();
        }
    }

    public static class PerspectiveStackItemImpl
    implements WPerspectiveStack.WStackItem<PerspectiveStackItem, Node> {
        private PerspectiveStackItem item;
        private MPerspective domElement;
        private WCallback<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>, Node> initCallback;

        @PostConstruct
        void init() {
            this.getWidget();
        }

        protected PerspectiveStackItem getWidget() {
            if (this.item == null) {
                this.item = this.createWidget();
            }
            return this.item;
        }

        protected PerspectiveStackItem createWidget() {
            final PerspectiveStackItem t = new PerspectiveStackItem();
            t.setInitRunnable(new Runnable(){

                @Override
                public void run() {
                    if (PerspectiveStackItemImpl.this.initCallback != null) {
                        t.setContent((Node)PerspectiveStackItemImpl.this.initCallback.call((Object)PerspectiveStackItemImpl.this));
                    }
                }
            });
            return t;
        }

        public PerspectiveStackItem getNativeItem() {
            return this.item;
        }

        public void setDomElement(MPerspective domElement) {
            this.domElement = domElement;
        }

        public MPerspective getDomElement() {
            return this.domElement;
        }

        public void setInitCallback(WCallback<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>, Node> callback) {
            this.initCallback = callback;
        }

        public void setOnCloseCallback(WCallback<WPerspectiveStack.WStackItem<PerspectiveStackItem, Node>, Boolean> callback) {
        }
    }
}

