/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ui.di.InjectingFXMLLoader;
import org.eclipse.fx.ui.dialogs.Dialog;
import org.eclipse.fx.ui.dialogs.MessageDialog;
import org.eclipse.fx.ui.panes.FillLayoutPane;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.workbench.fx.key.KeyBindingDispatcher;
import org.eclipse.fx.ui.workbench.renderers.base.BaseWindowRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.services.WindowTransitionService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWindow;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.osgi.framework.Bundle;

public class DefWindowRenderer
extends BaseWindowRenderer<Stage> {
    protected ISaveHandler.Save[] promptToSave(MWindow element, Collection<MPart> dirtyParts, WWindow<Stage> widget) {
        Object[] response = new ISaveHandler.Save[dirtyParts.size()];
        GraphicsLoader graphicsLoader = (GraphicsLoader)this.getModelContext((MUIElement)element).get(GraphicsLoader.class);
        MultiMessageDialog d = new MultiMessageDialog((Window)((Stage)widget.getWidget()), dirtyParts, graphicsLoader);
        if (d.open() == 1) {
            List<MPart> parts = d.getSelectedParts();
            Arrays.fill(response, ISaveHandler.Save.NO);
            for (MPart p : parts) {
                response[parts.indexOf((Object)p)] = ISaveHandler.Save.YES;
            }
        } else {
            Arrays.fill(response, ISaveHandler.Save.CANCEL);
        }
        return response;
    }

    protected ISaveHandler.Save promptToSave(MWindow element, MPart dirtyPart, WWindow<Stage> widget) {
        MessageDialog.QuestionCancelResult r = MessageDialog.openQuestionCancelDialog((Window)((Stage)widget.getWidget()), (String)"Unsaved changes", (String)("'" + dirtyPart.getLocalizedLabel() + "' has been modified. Save changes?"));
        switch (r) {
            case CANCEL: {
                return ISaveHandler.Save.CANCEL;
            }
            case NO: {
                return ISaveHandler.Save.NO;
            }
            case YES: {
                return ISaveHandler.Save.YES;
            }
        }
        return ISaveHandler.Save.CANCEL;
    }

    protected Class<? extends WWindow<Stage>> getWidgetClass(MWindow window) {
        return WWindowImpl.class;
    }

    static class MultiMessageDialog
    extends Dialog {
        private Collection<MPart> parts;
        private TableView<Row> tabView;
        private GraphicsLoader graphicsLoader;
        private List<MPart> selectedParts;

        public MultiMessageDialog(Window parent, Collection<MPart> parts, GraphicsLoader graphicsLoader) {
            super(parent, "Save Resources");
            this.parts = parts;
            this.graphicsLoader = graphicsLoader;
        }

        public List<MPart> getSelectedParts() {
            return this.selectedParts;
        }

        protected void okPressed() {
            this.selectedParts = new ArrayList<MPart>();
            for (Row r : this.tabView.getItems()) {
                if (!r.isSelected()) continue;
                this.selectedParts.add((MPart)r.element.get());
            }
            super.okPressed();
        }

        protected Node createDialogArea() {
            BorderPane p = new BorderPane();
            Label l = new Label("Save resources to save");
            p.setTop((Node)l);
            this.tabView = new TableView();
            TableColumn column = new TableColumn();
            column.setCellFactory((Callback)new Callback<TableColumn<Row, Boolean>, TableCell<Row, Boolean>>(){

                public TableCell<Row, Boolean> call(final TableColumn<Row, Boolean> param) {
                    final CheckBox checkBox = new CheckBox();
                    TableCell<Row, Boolean> cell = new TableCell<Row, Boolean>(){

                        protected void updateItem(Boolean item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            if (item == null) {
                                checkBox.setDisable(true);
                                checkBox.setSelected(false);
                                checkBox.setOnAction(null);
                            } else {
                                checkBox.setDisable(false);
                                checkBox.setSelected(item.booleanValue());
                                checkBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                    public void handle(ActionEvent event) {
                                        MultiMessageDialog.this.tabView.edit(0, param);
                                        this.commitEdit(checkBox.isSelected());
                                    }
                                });
                            }
                        }
                    };
                    cell.setGraphic((Node)checkBox);
                    return cell;
                }
            });
            column.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Row, Boolean>>(){

                public void handle(TableColumn.CellEditEvent<Row, Boolean> event) {
                    ((Row)event.getRowValue()).selected.set(((Boolean)event.getNewValue()).booleanValue());
                }
            });
            column.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
            this.tabView.getColumns().add((Object)column);
            column = new TableColumn();
            column.setCellFactory((Callback)new Callback<TableColumn<Row, MPart>, TableCell<Row, MPart>>(){

                public TableCell<Row, MPart> call(TableColumn<Row, MPart> param) {
                    return new TableCell<Row, MPart>(){

                        protected void updateItem(MPart item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            if (item != null) {
                                this.setText(item.getLocalizedLabel());
                                String uri = item.getIconURI();
                                if (uri != null) {
                                    this.setGraphic(MultiMessageDialog.this.graphicsLoader.getGraphicsNode(URI.createURI((String)uri)));
                                }
                            }
                        }
                    };
                }
            });
            column.setCellValueFactory((Callback)new PropertyValueFactory("element"));
            this.tabView.getColumns().add((Object)column);
            this.tabView.setEditable(true);
            ArrayList<Row> list = new ArrayList<Row>();
            for (MPart m : this.parts) {
                list.add(new Row(m));
            }
            this.tabView.setItems(FXCollections.observableArrayList(list));
            p.setCenter(this.tabView);
            return p;
        }
    }

    static class Row {
        private BooleanProperty selected = new SimpleBooleanProperty((Object)this, "selected", true);
        private ObjectProperty<MPart> element = new SimpleObjectProperty((Object)this, "element");

        public Row(MPart element) {
            this.element.set((Object)element);
        }

        public boolean isSelected() {
            return this.selected.get();
        }

        public void setSelected(boolean value) {
            this.selected.set(value);
        }

        public BooleanProperty selectedProperty() {
            return this.selected;
        }

        public MPart getElement() {
            return (MPart)this.element.get();
        }

        public void setElement(MPart value) {
            this.element.set((Object)value);
        }

        public ObjectProperty<MPart> elementProperty() {
            return this.element;
        }
    }

    public static class WWindowImpl
    extends WLayoutedWidgetImpl<Stage, BorderPane, MWindow>
    implements WWindow<Stage> {
        private boolean support3d;
        private BorderPane rootPane;
        private BorderPane trimPane;
        private FillLayoutPane contentPane;
        private KeyBindingDispatcher dispatcher;
        private BorderPane decoratorPane;
        private WindowResizeButton windowResizeButton;
        private Stage stage;
        @Inject
        @Optional
        ThemeManager themeManager;
        private ThemeManager.Registration sceneRegistration;
        private String decorationFXML;
        private boolean fullscreen;
        @Inject
        IEclipseContext context;
        IEclipseContext modelContext;
        MWindow mWindow;
        @Inject
        TranslationService translationService;
        @Inject
        BundleLocalization localizationService;
        @Inject
        @Optional
        WindowTransitionService<Stage> windowTransitionService;
        @Inject
        private GraphicsLoader graphicsLoader;
        boolean initDone;
        private boolean undecorated;
        private IEclipseContext applicationContext;
        private List<WWindow<Stage>> windows = new ArrayList<WWindow<Stage>>();
        private WCallback<WWindow<Stage>, Boolean> onCloseCallback;

        @Inject
        public WWindowImpl(@Named(value="fx.rendering.domElement") MWindow mWindow, @Optional KeyBindingDispatcher dispatcher, MApplication application) {
            this.mWindow = mWindow;
            this.applicationContext = application.getContext();
            if (mWindow.getPersistedState().get("fx.scene.3d") != null) {
                System.err.println("Usage of deprecated persisted state 'fx.scene.3d' please use 'efx.window.scene.3d' instead.");
                this.support3d = Boolean.parseBoolean((String)mWindow.getPersistedState().get("fx.scene.3d"));
            } else {
                this.support3d = Boolean.parseBoolean((String)mWindow.getPersistedState().get("efx.window.scene.3d"));
            }
            this.dispatcher = dispatcher;
            this.modelContext = mWindow.getContext();
            this.decorationFXML = (String)mWindow.getPersistedState().get("fx.stage.decoration");
            if (this.decorationFXML == null) {
                this.decorationFXML = (String)mWindow.getPersistedState().get("efx.window.decoration.fxml");
            } else {
                System.err.println("Useage of deprecated persisted state 'fx.stage.decoration' please use 'efx.window.decoration.fxml' instead.");
            }
            this.undecorated = Boolean.parseBoolean((String)mWindow.getPersistedState().get("efx.window.undecorated"));
        }

        @Override
        @PostConstruct
        protected void init() {
            this.initDone = true;
            super.init();
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            this.sceneRegistration.dispose();
        }

        private static MWindow findParent(EObject e) {
            if (e.eContainer() instanceof MApplication) {
                return null;
            }
            do {
                if (!((e = e.eContainer()) instanceof MWindow)) continue;
                return (MWindow)e;
            } while (e.eContainer() != null);
            return null;
        }

        @Override
        protected Stage createWidget() {
            Scene s;
            this.stage = new Stage();
            MWindow parent = WWindowImpl.findParent((EObject)this.mWindow);
            if (parent != null) {
                this.stage.initOwner((Window)((WWindow)parent.getWidget()).getWidget());
            }
            this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    if (WWindowImpl.this.onCloseCallback != null && !Boolean.TRUE.equals(WWindowImpl.this.onCloseCallback.call((Object)WWindowImpl.this))) {
                        event.consume();
                    }
                }
            });
            this.stage.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        if (WWindowImpl.this.stage.getScene() != null) {
                            WWindowImpl.this.applicationContext.set("efx_APP_FOCUS_NODE", (Object)WWindowImpl.this.stage.getScene().getFocusOwner());
                        }
                        WWindowImpl.this.activate();
                    }
                }
            });
            this.stage.setFullScreen(this.fullscreen);
            this.stage.fullScreenProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    WWindowImpl.this.mWindow.getPersistedState().put("efx.window.fullscreen", newValue.toString());
                }
            });
            if (this.dispatcher != null) {
                this.stage.addEventFilter(KeyEvent.KEY_PRESSED, this.dispatcher.getKeyHandler());
            }
            this.rootPane = new BorderPane(){

                protected void layoutChildren() {
                    super.layoutChildren();
                    if (WWindowImpl.this.windowResizeButton != null) {
                        WWindowImpl.this.windowResizeButton.autosize();
                        WWindowImpl.this.windowResizeButton.setLayoutX(this.getWidth() - WWindowImpl.this.windowResizeButton.getLayoutBounds().getWidth());
                        WWindowImpl.this.windowResizeButton.setLayoutY(this.getHeight() - WWindowImpl.this.windowResizeButton.getLayoutBounds().getHeight());
                    }
                }
            };
            this.trimPane = new BorderPane();
            this.rootPane.setCenter((Node)this.trimPane);
            this.contentPane = new FillLayoutPane();
            this.trimPane.setCenter((Node)this.contentPane);
            if (this.decorationFXML != null) {
                this.windowResizeButton = new WindowResizeButton(this.stage, 50.0, 50.0);
                this.decoratorPane = new BorderPane();
                this.decoratorPane.setTop(this.createTopDecoration(this.stage));
                this.rootPane.setTop((Node)this.decoratorPane);
            }
            if (this.undecorated) {
                this.stage.initStyle(StageStyle.UNDECORATED);
            }
            if (this.support3d && Platform.isSupported((ConditionalFeature)ConditionalFeature.SCENE3D)) {
                s = new Scene((Parent)this.rootPane, (double)this.mWindow.getWidth(), (double)this.mWindow.getHeight(), true);
                s.setCamera((Camera)new PerspectiveCamera());
            } else {
                s = new Scene((Parent)this.rootPane, (double)this.mWindow.getWidth(), (double)this.mWindow.getHeight());
            }
            s.focusOwnerProperty().addListener((ChangeListener)new ChangeListener<Node>(){
                List<WWidget<?>> lastActivationTree = new ArrayList();
                List<WWidget<?>> queuedTree = new ArrayList();

                public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
                    WWindowImpl.this.modelContext.set("efx_WINDOW_FOCUS_NODE", (Object)newValue);
                    if (WWindowImpl.this.stage.isFocused()) {
                        WWindowImpl.this.applicationContext.set("efx_APP_FOCUS_NODE", (Object)newValue);
                    }
                    if (newValue != null) {
                        final ArrayList activationTree = new ArrayList();
                        do {
                            if (!(newValue.getUserData() instanceof WWidget)) continue;
                            activationTree.add((WWidget)newValue.getUserData());
                        } while ((newValue = newValue.getParent()) != null);
                        if (!this.lastActivationTree.equals(activationTree)) {
                            final ArrayList oldTreeReversed = new ArrayList(this.lastActivationTree);
                            final ArrayList newTreeReversed = new ArrayList(activationTree);
                            Collections.reverse(oldTreeReversed);
                            Collections.reverse(newTreeReversed);
                            Iterator it = newTreeReversed.iterator();
                            while (it.hasNext()) {
                                if (oldTreeReversed.isEmpty() || oldTreeReversed.get(0) != it.next()) break;
                                oldTreeReversed.remove(0);
                                it.remove();
                            }
                            Collections.reverse(oldTreeReversed);
                            Collections.reverse(newTreeReversed);
                            this.queuedTree = activationTree;
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (queuedTree == activationTree) {
                                        lastActivationTree = activationTree;
                                        for (WWidget w : oldTreeReversed) {
                                            w.deactivate();
                                        }
                                        for (WWidget w : newTreeReversed) {
                                            w.activate();
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
            });
            if (this.themeManager != null) {
                Theme theme = this.themeManager.getCurrentTheme();
                if (theme != null) {
                    ArrayList<String> sUrls = new ArrayList<String>();
                    for (URL url : theme.getStylesheetURL()) {
                        sUrls.add(url.toExternalForm());
                    }
                    s.getStylesheets().addAll(sUrls);
                }
                this.sceneRegistration = this.themeManager.registerScene(s);
            }
            if (this.windowResizeButton != null) {
                this.rootPane.getChildren().add((Object)this.windowResizeButton);
            }
            this.stage.setScene(s);
            this.modelContext.set(Stage.class, (Object)this.stage);
            this.modelContext.set(Scene.class, (Object)s);
            return this.stage;
        }

        private Node createTopDecoration(Stage stage) {
            URI uri = URI.createURI((String)this.decorationFXML);
            if (uri != null) {
                stage.initStyle(StageStyle.UNDECORATED);
                Bundle b = org.eclipse.core.runtime.Platform.getBundle((String)uri.segment(1));
                if (b != null) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        int i = 2;
                        while (i < uri.segmentCount()) {
                            if (sb.length() != 0) {
                                sb.append("/");
                            }
                            sb.append(uri.segment(i));
                            ++i;
                        }
                        InjectingFXMLLoader loader = InjectingFXMLLoader.create((IEclipseContext)this.context, (Bundle)b, (String)sb.toString());
                        loader.resourceBundle(this.localizationService.getLocalization(b, Locale.getDefault().toString()));
                        return (Node)loader.load();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        @Override
        protected void bindProperties(Stage widget) {
            super.bindProperties(widget);
            this.bindProperty("x", (ObservableValue<Object>)widget.xProperty());
            this.bindProperty("y", (ObservableValue<Object>)widget.yProperty());
            this.bindProperty("width", (ObservableValue<Object>)widget.widthProperty());
            this.bindProperty("height", (ObservableValue<Object>)widget.heightProperty());
        }

        public void setMainMenu(WLayoutedWidget<MMenu> menuWidget) {
            if (this.decoratorPane == null) {
                this.rootPane.setTop((Node)menuWidget.getStaticLayoutNode());
            } else {
                this.decoratorPane.setBottom((Node)menuWidget.getStaticLayoutNode());
            }
        }

        @Override
        protected BorderPane getWidgetNode() {
            return this.rootPane;
        }

        public void setOnCloseCallback(WCallback<WWindow<Stage>, Boolean> onCloseCallback) {
            this.onCloseCallback = onCloseCallback;
        }

        @Inject
        public void setX(@Named(value="x") int x) {
            if (x == Integer.MIN_VALUE) {
                x = 0;
            }
            ((Stage)this.getWidget()).setX((double)x);
        }

        @Inject
        public void setY(@Named(value="y") int y) {
            if (y == Integer.MIN_VALUE) {
                y = 0;
            }
            ((Stage)this.getWidget()).setY((double)y);
        }

        @Inject
        public void setWidth(@Named(value="width") int w) {
            ((Stage)this.getWidget()).setWidth((double)w);
        }

        @Inject
        public void setHeight(@Named(value="height") int h) {
            ((Stage)this.getWidget()).setHeight((double)h);
        }

        @Inject
        public void setVisible(@Named(value="visible") boolean visible) {
            if (!this.initDone) {
                return;
            }
            if (visible) {
                this.internalShow();
            } else {
                this.internalHide();
            }
        }

        @Inject
        public void setFullscreen(@Named(value="persistedState_efx.window.fullscreen") @Optional String fullScreen) {
            if (fullScreen != null) {
                this.fullscreen = Boolean.parseBoolean(fullScreen);
                if (this.stage != null) {
                    this.stage.setFullScreen(this.fullscreen);
                }
            } else {
                this.fullscreen = false;
            }
        }

        @Override
        public void addStyleClasses(List<String> classnames) {
            this.rootPane.getStyleClass().addAll(classnames);
        }

        @Override
        public void setStyleId(String id) {
            this.rootPane.setId(id);
        }

        public void show() {
            this.internalShow();
            ((Stage)this.getWidget()).toFront();
        }

        public void close() {
            ((Stage)this.getWidget()).close();
        }

        public void addChild(WWindow<Stage> widget) {
            this.windows.add(widget);
            if (this.initDone && this.stage.isShowing()) {
                Stage s = (Stage)widget.getWidget();
                s.show();
            }
        }

        public void removeChild(WWindow<Stage> widget) {
            if (widget.getWidget() != null) {
                Stage s = (Stage)widget.getWidget();
                s.hide();
            }
            this.windows.remove(widget);
        }

        private void internalShow() {
            if (((Stage)this.getWidget()).isShowing()) {
                return;
            }
            if (this.windowTransitionService != null) {
                WindowTransitionService.AnimationDelegate delegate = this.windowTransitionService.getShowDelegate(this.mWindow);
                if (delegate != null) {
                    delegate.animate((Object)this.stage);
                } else {
                    ((Stage)this.getWidget()).show();
                }
            } else {
                ((Stage)this.getWidget()).show();
            }
            for (WWindow<Stage> c : this.windows) {
                c.show();
            }
        }

        private void internalHide() {
            if (this.windowTransitionService != null) {
                WindowTransitionService.AnimationDelegate delegate = this.windowTransitionService.getShowDelegate(this.mWindow);
                if (delegate != null) {
                    delegate.animate((Object)this.stage);
                } else {
                    ((Stage)this.getWidget()).hide();
                }
            } else {
                ((Stage)this.getWidget()).hide();
            }
        }

        @Inject
        public void setTitle(@Named(value="localizedLabel") String title) {
            ((Stage)this.getWidget()).setTitle(title);
        }

        @Inject
        public void setImageUrl(@Named(value="iconURI") @Optional String iconUri) {
            if (iconUri != null) {
                String[] split = iconUri.split(";");
                ArrayList<Image> images = new ArrayList<Image>();
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String uri = stringArray[n2];
                    Image img = this.graphicsLoader.getImage(URI.createURI((String)uri));
                    if (img != null) {
                        images.add(img);
                    }
                    ++n2;
                }
                ((Stage)this.getWidget()).getIcons().setAll(images);
            } else {
                ((Stage)this.getWidget()).getIcons().clear();
            }
        }

        public void setBottomTrim(WLayoutedWidget<MTrimBar> trimBar) {
            this.trimPane.setBottom((Node)trimBar.getStaticLayoutNode());
        }

        public void setLeftTrim(WLayoutedWidget<MTrimBar> trimBar) {
            this.trimPane.setLeft((Node)trimBar.getStaticLayoutNode());
        }

        public void setRightTrim(WLayoutedWidget<MTrimBar> trimBar) {
            this.trimPane.setRight((Node)trimBar.getStaticLayoutNode());
        }

        public void setTopTrim(WLayoutedWidget<MTrimBar> trimBar) {
            Node g = (Node)trimBar.getStaticLayoutNode();
            this.trimPane.setTop(g);
        }

        public void addChild(WLayoutedWidget<MWindowElement> widget) {
            this.contentPane.getChildren().add((Object)((Node)widget.getStaticLayoutNode()));
        }

        public void removeChild(WLayoutedWidget<MWindowElement> widget) {
            this.contentPane.getChildren().remove((Object)((Node)widget.getStaticLayoutNode()));
        }

        public void addChild(int idx, WLayoutedWidget<MWindowElement> widget) {
            this.contentPane.getChildren().add(idx, (Object)((Node)widget.getStaticLayoutNode()));
        }
    }

    static class WindowResizeButton
    extends Region {
        private double dragOffsetX;
        private double dragOffsetY;

        public WindowResizeButton(final Stage stage, final double stageMinimumWidth, final double stageMinimumHeight) {
            this.setId("window-resize-button");
            this.setPrefSize(11.0, 11.0);
            this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    WindowResizeButton.this.dragOffsetX = stage.getX() + stage.getWidth() - e.getScreenX();
                    WindowResizeButton.this.dragOffsetY = stage.getY() + stage.getHeight() - e.getScreenY();
                    e.consume();
                }
            });
            this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    ObservableList screens = Screen.getScreensForRectangle((double)stage.getX(), (double)stage.getY(), (double)1.0, (double)1.0);
                    Screen screen = screens.size() > 0 ? (Screen)Screen.getScreensForRectangle((double)stage.getX(), (double)stage.getY(), (double)1.0, (double)1.0).get(0) : (Screen)Screen.getScreensForRectangle((double)0.0, (double)0.0, (double)1.0, (double)1.0).get(0);
                    Rectangle2D visualBounds = screen.getVisualBounds();
                    double maxX = Math.min(visualBounds.getMaxX(), e.getScreenX() + WindowResizeButton.this.dragOffsetX);
                    double maxY = Math.min(visualBounds.getMaxY(), e.getScreenY() - WindowResizeButton.this.dragOffsetY);
                    stage.setWidth(Math.max(stageMinimumWidth, maxX - stage.getX()));
                    stage.setHeight(Math.max(stageMinimumHeight, maxY - stage.getY()));
                    e.consume();
                }
            });
        }
    }
}

