/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.fx.emf.edit.ui.CellUtil;

public class AdapterFactoryTreeItem
extends TreeItem<Object> {
    final AdapterFactory adapterFactory;
    final Control view;
    final ObservableList<TreeItem<Object>> children;
    final ITreeItemContentProvider provider;

    public AdapterFactoryTreeItem(Object object, Control treeView, AdapterFactory adapterFactory) {
        super(object);
        this.view = treeView;
        this.adapterFactory = adapterFactory;
        this.children = FXCollections.unmodifiableObservableList((ObservableList)super.getChildren());
        Object adapter = adapterFactory.adapt(object, ITreeItemContentProvider.class);
        ITreeItemContentProvider iTreeItemContentProvider = this.provider = adapter instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)adapter : null;
        if (object instanceof Notifier) {
            ((Notifier)object).eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() instanceof EReference) {
                        AdapterFactoryTreeItem.this.updateChildren();
                    }
                }
            });
        }
        this.updateChildren();
    }

    public ObservableList<TreeItem<Object>> getChildren() {
        return this.children;
    }

    void updateChildren() {
        ObservableList childTreeItems = super.getChildren();
        MultipleSelectionModel<?> selectionModel = CellUtil.getSelectionModel(this.view);
        ObservableList selection = selectionModel.getSelectedItems();
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        ArrayList<TreeItem> selectedTreeItems = new ArrayList<TreeItem>();
        ArrayList<Object> expandedItems = new ArrayList<Object>();
        for (TreeItem treeItem : childTreeItems) {
            if (!treeItem.isExpanded()) continue;
            expandedItems.add(treeItem.getValue());
        }
        for (Object e : selection) {
            for (TreeItem childTreeItem : childTreeItems) {
                if (e != childTreeItem) continue;
                selectedTreeItems.add(childTreeItem);
                selectedItems.add(childTreeItem.getValue());
            }
        }
        for (TreeItem treeItem : selectedTreeItems) {
            int treeItemIndex = selectionModel.getSelectedItems().indexOf((Object)treeItem);
            int selectionIndex = (Integer)selectionModel.getSelectedIndices().get(treeItemIndex);
            selectionModel.clearSelection(selectionIndex);
        }
        childTreeItems.clear();
        if (this.provider == null) {
            return;
        }
        for (Object e : this.provider.getChildren(this.getValue())) {
            AdapterFactoryTreeItem treeItem = new AdapterFactoryTreeItem(e, this.view, this.adapterFactory);
            childTreeItems.add((Object)treeItem);
            if (expandedItems.contains(e)) {
                treeItem.setExpanded(true);
            }
            if (!selectedItems.contains(e) || !"javafx.scene.control.TreeView$TreeViewBitSetSelectionModel".equals(selectionModel.getClass().getName())) continue;
            try {
                Method m = selectionModel.getClass().getDeclaredMethod("select", TreeItem.class);
                m.setAccessible(true);
                m.invoke(selectionModel, new Object[]{treeItem});
            }
            catch (Exception exception) {}
        }
    }
}

