/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.internal;

import javafx.scene.control.Tab;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.osgi.util.LoggerCreator;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDFeedbackService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragSourceWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragTargetWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WStack;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.BaseDnDSupport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DnDSupport
extends BaseDnDSupport {
    private final @NonNull WCallback<@Nullable Void, @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragSourceWidget.DragData, @NonNull Boolean>> dragStartCallbackProvider;
    private final @NonNull WCallback<@Nullable Void, @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragTargetWidget.DropData, @Nullable Void>> dropCallbackProvider;
    private final @NonNull MPartStack stack;
    private static final @NonNull Logger LOGGER = LoggerCreator.createLogger(DnDSupport.class);

    public DnDSupport(@NonNull WCallback<@Nullable Void, @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragSourceWidget.DragData, @NonNull Boolean>> dragStartCallbackProvider, @NonNull WCallback<@Nullable Void, @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragTargetWidget.DropData, @Nullable Void>> dropCallbackProvider, @NonNull DnDFeedbackService feedbackService, @NonNull MPartStack stack) {
        super(feedbackService);
        this.dragStartCallbackProvider = dragStartCallbackProvider;
        this.dropCallbackProvider = dropCallbackProvider;
        this.stack = stack;
    }

    public @NonNull String clipboardDataFunction(@NonNull Tab tab) {
        MStackElement domElement = ((WStack.WStackItem)tab.getUserData()).getDomElement();
        String rv = null;
        if (domElement != null) {
            EObject eo = (EObject)domElement;
            rv = ((XMIResource)eo.eResource()).getID(eo);
        }
        if (rv != null) {
            return rv;
        }
        return String.valueOf(System.identityHashCode(tab));
    }

    public @NonNull Boolean handleDragStart(@NonNull Tab tab) {
        WCallback dragStartCallback = (WCallback)this.dragStartCallbackProvider.call(null);
        if (dragStartCallback != null) {
            WStack.WStackItem item = (WStack.WStackItem)tab.getUserData();
            MStackElement itemElement = item.getDomElement();
            if (itemElement == null) {
                return Boolean.FALSE;
            }
            MPartStack itemContainer = (MPartStack)itemElement.getParent();
            if (itemContainer != null) {
                WDragSourceWidget.DragData dragData = new WDragSourceWidget.DragData(itemContainer, itemElement);
                if (!((Boolean)dragStartCallback.call((Object)dragData)).booleanValue()) {
                    return Boolean.TRUE;
                }
            } else {
                LOGGER.error("Stack element '" + itemElement + "' has no container");
            }
        }
        return Boolean.TRUE;
    }

    public void handleDropped(DndTabPaneFactory.DroppedData data) {
        WCallback call = (WCallback)this.dropCallbackProvider.call(null);
        if (call != null) {
            WStack.WStackItem referenceItem = (WStack.WStackItem)data.targetTab.getUserData();
            WStack.WStackItem sourceItem = (WStack.WStackItem)data.draggedTab.getUserData();
            MStackElement domElement = sourceItem.getDomElement();
            if (domElement != null) {
                call.call((Object)new WDragTargetWidget.DropData((MUIElement)referenceItem.getDomElement(), (MUIElement)domElement, data.dropType == DndTabPaneFactory.DropType.AFTER ? WDragTargetWidget.DropType.AFTER : WDragTargetWidget.DropType.BEFORE));
            } else {
                LOGGER.error("Source item '" + sourceItem + "' has no dom element attached");
            }
        }
    }

    public void handleFeedback(DndTabPaneFactory.FeedbackData data) {
        if (data.dropType == DndTabPaneFactory.DropType.NONE) {
            DnDSupport.cleanup();
            return;
        }
        MStackElement reference = ((WStack.WStackItem)data.targetTab.getUserData()).getDomElement();
        MStackElement sourceReference = ((WStack.WStackItem)data.draggedTab.getUserData()).getDomElement();
        this.updateFeedback(new DnDFeedbackService.DnDFeedbackData((MUIElement)reference, (MUIElement)sourceReference, data.dropType == DndTabPaneFactory.DropType.AFTER ? WDragTargetWidget.DropType.AFTER : WDragTargetWidget.DropType.BEFORE, (MUIElement)this.stack, new DnDFeedbackService.Region(data.bounds.getMinX(), data.bounds.getMinY(), data.bounds.getWidth(), data.bounds.getHeight())));
    }

    public void handleFinished(Tab tab) {
        DnDSupport.cleanup();
    }
}

