/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.keybindings.e4.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.fx.ui.keybindings.Binding;
import org.eclipse.fx.ui.keybindings.KeyStroke;
import org.eclipse.fx.ui.keybindings.Trigger;
import org.eclipse.fx.ui.keybindings.TriggerSequence;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BindingTable {
    static final BindingComparator BEST_SEQUENCE = new BindingComparator();
    private final @NonNull Context tableId;
    private final @NonNull ArrayList<@NonNull Binding> bindings = new ArrayList();
    private final @NonNull Map<@NonNull TriggerSequence, @NonNull Binding> bindingsByTrigger = new HashMap<TriggerSequence, Binding>();
    private final @NonNull Map<@NonNull ParameterizedCommand, @NonNull ArrayList<@NonNull Binding>> bindingsByCommand = new HashMap<ParameterizedCommand, ArrayList<Binding>>();
    private final @NonNull Map<@NonNull TriggerSequence, @NonNull ArrayList<@NonNull Binding>> bindingsByPrefix = new HashMap<TriggerSequence, ArrayList<Binding>>();
    private final @NonNull Map<@NonNull TriggerSequence, @NonNull ArrayList<@NonNull Binding>> conflicts = new HashMap<TriggerSequence, ArrayList<Binding>>();

    public BindingTable(@NonNull Context context) {
        this.tableId = context;
    }

    public @NonNull Context getTableId() {
        return this.tableId;
    }

    public @NonNull String getId() {
        return this.tableId.getId();
    }

    public @NonNull Collection<@NonNull Binding> getConflicts() {
        ArrayList<@NonNull Binding> conflictsList = new ArrayList<Binding>();
        for (TriggerSequence key : this.conflicts.keySet()) {
            ArrayList<@NonNull Binding> conflictsForTrigger = this.conflicts.get(key);
            conflictsList.addAll(conflictsForTrigger);
        }
        return conflictsList;
    }

    public @Nullable Collection<@NonNull Binding> getConflictsFor(TriggerSequence triggerSequence) {
        return this.conflicts.get(triggerSequence);
    }

    public void addBinding(@NonNull Binding binding) {
        ArrayList<Object> conflictsList;
        if (!this.getId().equals(binding.getContextId())) {
            throw new IllegalArgumentException("Binding context " + binding.getContextId() + " does not match " + this.getId());
        }
        boolean isConflict = false;
        TriggerSequence triggerSequence = binding.getTriggerSequence();
        if (triggerSequence == null) {
            return;
        }
        if (this.bindingsByTrigger.containsKey(triggerSequence)) {
            Binding conflict = this.bindingsByTrigger.get(triggerSequence);
            this.removeBinding(conflict);
            conflictsList = new ArrayList<Binding>();
            conflictsList.add(conflict);
            this.conflicts.put(triggerSequence, conflictsList);
            isConflict = true;
        }
        if (this.conflicts.containsKey(triggerSequence) && this.conflicts.get(triggerSequence).size() > 0) {
            conflictsList = this.conflicts.get(triggerSequence);
            if (!conflictsList.contains(binding)) {
                conflictsList.add(binding);
            }
            isConflict = true;
        }
        if (!isConflict) {
            this.bindings.add(binding);
            this.bindingsByTrigger.put(triggerSequence, binding);
            ArrayList<@NonNull Object> sequences = this.bindingsByCommand.get(binding.getParameterizedCommand());
            if (sequences == null) {
                sequences = new ArrayList();
                this.bindingsByCommand.put(binding.getParameterizedCommand(), sequences);
            }
            sequences.add(binding);
            Collections.sort(sequences, BEST_SEQUENCE);
            TriggerSequence[] prefs = triggerSequence.getPrefixes();
            int i = 1;
            while (i < prefs.length) {
                ArrayList<Object> bindings = this.bindingsByPrefix.get(prefs[i]);
                if (bindings == null) {
                    bindings = new ArrayList();
                    this.bindingsByPrefix.put(prefs[i], bindings);
                }
                bindings.add(binding);
                ++i;
            }
        }
    }

    public void removeBinding(@NonNull Binding binding) {
        if (!this.getId().equals(binding.getContextId())) {
            throw new IllegalArgumentException("Binding context " + binding.getContextId() + " does not match " + this.getId());
        }
        ArrayList<@NonNull Binding> conflictBindings = this.conflicts.get(binding.getTriggerSequence());
        if (!this.bindingsByTrigger.containsKey(binding.getTriggerSequence()) && conflictBindings != null) {
            conflictBindings.remove(binding);
            if (conflictBindings.size() == 1) {
                Binding bindingToReAdd = conflictBindings.remove(0);
                this.addBinding(bindingToReAdd);
            }
        } else {
            this.bindings.remove(binding);
            this.bindingsByTrigger.remove(binding.getTriggerSequence());
            ArrayList<Binding> sequences = this.bindingsByCommand.get(binding.getParameterizedCommand());
            if (sequences != null) {
                sequences.remove(binding);
            }
            TriggerSequence[] prefs = binding.getTriggerSequence().getPrefixes();
            int i = 1;
            while (i < prefs.length) {
                ArrayList<Binding> bindings = this.bindingsByPrefix.get(prefs[i]);
                bindings.remove(binding);
                ++i;
            }
        }
    }

    public @Nullable Binding getPerfectMatch(@NonNull TriggerSequence trigger) {
        return this.bindingsByTrigger.get(trigger);
    }

    public @Nullable Binding getBestSequenceFor(@NonNull ParameterizedCommand command) {
        ArrayList<Binding> sequences = this.bindingsByCommand.get(command);
        if (sequences != null && sequences.size() > 0) {
            return sequences.get(0);
        }
        return null;
    }

    public @NonNull Collection<@NonNull Binding> getSequencesFor(@NonNull ParameterizedCommand command) {
        ArrayList<Binding> triggers = this.bindingsByCommand.get(command);
        return triggers == null ? Collections.emptyList() : new ArrayList<Binding>(triggers);
    }

    public @Nullable Collection<@NonNull Binding> getPartialMatches(@NonNull TriggerSequence sequence) {
        return this.bindingsByPrefix.get(sequence);
    }

    public boolean isPartialMatch(@NonNull TriggerSequence seq) {
        return this.bindingsByPrefix.get(seq) != null;
    }

    public @NonNull Collection<@NonNull Binding> getBindings() {
        return Collections.unmodifiableCollection(this.bindings);
    }

    static class BindingComparator
    implements Comparator<Binding> {
        private String[] activeSchemeIds;

        BindingComparator() {
        }

        private final int compareSchemes(String schemeId1, String schemeId2) {
            if (this.activeSchemeIds == null || this.activeSchemeIds.length == 0) {
                return 0;
            }
            if (!schemeId2.equals(schemeId1)) {
                int i = 0;
                while (i < this.activeSchemeIds.length) {
                    String schemePointer = this.activeSchemeIds[i];
                    if (schemeId2.equals(schemePointer)) {
                        return 1;
                    }
                    if (schemeId1.equals(schemePointer)) {
                        return -1;
                    }
                    ++i;
                }
            }
            return 0;
        }

        public void setActiveSchemes(String[] activeSchemeIds) {
            this.activeSchemeIds = activeSchemeIds;
        }

        @Override
        public int compare(Binding o1, Binding o2) {
            Trigger[] currentTriggers;
            int rc = this.compareSchemes(o1.getSchemeId(), o2.getSchemeId());
            if (rc != 0) {
                return rc;
            }
            Trigger[] bestTriggers = o1.getTriggerSequence().getTriggers();
            int compareTo = bestTriggers.length - (currentTriggers = o2.getTriggerSequence().getTriggers()).length;
            if (compareTo != 0) {
                return compareTo;
            }
            compareTo = BindingComparator.countStrokes(bestTriggers) - BindingComparator.countStrokes(currentTriggers);
            if (compareTo != 0) {
                return compareTo;
            }
            return o1.getTriggerSequence().format().length() - o2.getTriggerSequence().format().length();
        }

        private static final int countStrokes(Trigger[] triggers) {
            int strokeCount = triggers.length;
            int i = 0;
            while (i < triggers.length) {
                Trigger trigger = triggers[i];
                if (trigger instanceof KeyStroke) {
                    KeyStroke keyStroke = (KeyStroke)trigger;
                    if (keyStroke.hasAltModifier()) {
                        strokeCount += 8;
                    }
                    if (keyStroke.hasCtrlModifier()) {
                        strokeCount += 2;
                    }
                    if (keyStroke.hasShiftModifier()) {
                        strokeCount += 4;
                    }
                    if (keyStroke.hasCommandModifier()) {
                        strokeCount += 2;
                    }
                } else {
                    strokeCount += 99;
                }
                ++i;
            }
            return strokeCount;
        }
    }
}

