/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.contexts;

import java.util.WeakHashMap;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.osgi.EclipseContextOSGi;
import org.osgi.framework.BundleContext;

public final class EclipseContextFactory {
    private static WeakHashMap<BundleContext, IEclipseContext> serviceContexts = new WeakHashMap();

    public static IEclipseContext create() {
        return new EclipseContext(null);
    }

    public static IEclipseContext create(String name) {
        IEclipseContext result = EclipseContextFactory.create();
        result.set("debugString", name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IEclipseContext getServiceContext(BundleContext bundleContext) {
        WeakHashMap<BundleContext, IEclipseContext> weakHashMap = serviceContexts;
        synchronized (weakHashMap) {
            IEclipseContext result = serviceContexts.get(bundleContext);
            if (result == null) {
                result = new EclipseContextOSGi(bundleContext);
                result.set("debugString", "OSGi context for bundle: " + bundleContext.getBundle().getSymbolicName());
                serviceContexts.put(bundleContext, result);
            }
            return result;
        }
    }
}

