/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.theme.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableMap;
import javafx.scene.Scene;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.theme.internal.Activator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class DefaultThemeManager
implements ThemeManager {
    static final String ATT_ID = "id";
    static final String ATT_NAME = "name";
    static final String ATT_THEME_ID = "themeId";
    static final String ATT_BASETYLESHEET = "basestylesheet";
    static final String ATT_RESOURCE = "resource";
    private final @NonNull ObservableMap<@NonNull String, @NonNull Theme> themes = FXCollections.observableMap(new HashMap());
    private final @NonNull ObservableMap<@NonNull String, @NonNull Theme> unmodifiableThemes = FXCollections.unmodifiableObservableMap(this.themes);
    private String currentThemeId;
    List<Scene> managedScenes = new ArrayList<Scene>();
    private static Logger LOGGER;
    private EventAdmin eventAdmin;

    public Theme getCurrentTheme() {
        if (this.themes.isEmpty()) {
            return null;
        }
        if (this.themes.size() == 1) {
            return (Theme)this.themes.values().iterator().next();
        }
        String id = this.getCurrentThemeId();
        if (id != null && this.themes.containsKey((Object)id)) {
            return (Theme)this.themes.get((Object)id);
        }
        return null;
    }

    public @NonNull ObservableMap<@NonNull String, @NonNull Theme> getAvailableThemes() {
        return this.unmodifiableThemes;
    }

    private static @NonNull String getCSSClassname(@NonNull String id) {
        return id.replace('.', '-');
    }

    private void handleStylesheetUrlChange(ListChangeListener.Change<? extends URL> change) {
        while (change.next()) {
            for (Scene scene : this.managedScenes) {
                for (URL url : change.getRemoved()) {
                    scene.getStylesheets().remove((Object)url.toExternalForm());
                }
                for (URL url : change.getAddedSubList()) {
                    scene.getStylesheets().add((Object)url.toExternalForm());
                }
            }
        }
    }

    private void unsetTheme(Theme theme) {
        theme.getStylesheetURL().removeListener(this::handleStylesheetUrlChange);
        for (Scene scene : this.managedScenes) {
            Collection availableThemes = this.getAvailableThemes().values();
            for (Theme t : availableThemes) {
                for (URL url : t.getStylesheetURL()) {
                    if (scene.getRoot() != null) {
                        scene.getRoot().getStyleClass().remove((Object)DefaultThemeManager.getCSSClassname(t.getId()));
                    }
                    scene.getStylesheets().remove((Object)url.toExternalForm());
                }
            }
        }
    }

    private void setTheme(Theme theme) {
        theme.getStylesheetURL().addListener(this::handleStylesheetUrlChange);
        for (Scene scene : this.managedScenes) {
            for (URL url : theme.getStylesheetURL()) {
                if (!theme.getId().equals(this.currentThemeId)) continue;
                if (scene.getRoot() != null) {
                    scene.getRoot().getStyleClass().remove((Object)DefaultThemeManager.getCSSClassname(theme.getId()));
                    scene.getRoot().getStyleClass().add((Object)DefaultThemeManager.getCSSClassname(theme.getId()));
                }
                scene.getStylesheets().add((Object)url.toExternalForm());
            }
        }
    }

    public void setCurrentThemeId(String id) {
        if (this.themes.containsKey((Object)id)) {
            if (this.currentThemeId != null && this.themes.containsKey((Object)this.currentThemeId)) {
                this.unsetTheme((Theme)this.themes.get((Object)this.currentThemeId));
            }
            this.currentThemeId = id;
            Theme theme = (Theme)this.themes.get((Object)id);
            this.setTheme(theme);
            EventAdmin eventAdmin = this.getEventAdmin();
            if (eventAdmin != null) {
                eventAdmin.sendEvent(new Event("org/eclipse/fx/Theme/modified", Collections.singletonMap("org.eclipse.e4.data", id)));
            }
            return;
        }
        throw new IllegalArgumentException("Theme with id '" + id + "' is not known.");
    }

    private String getCurrentThemeId() {
        return this.currentThemeId;
    }

    static @NonNull Logger getLogger() {
        Logger logger = LOGGER;
        if (logger == null) {
            ServiceReference ref = Activator.getContext().getServiceReference(LoggerFactory.class);
            LOGGER = logger = ((LoggerFactory)Activator.getContext().getService(ref)).createLogger(DefaultThemeManager.class.getName());
        }
        return LOGGER;
    }

    @Nullable EventAdmin getEventAdmin() {
        EventAdmin eventAdmin = this.eventAdmin;
        if (eventAdmin != null) {
            return eventAdmin;
        }
        ServiceReference ref = Activator.getContext().getServiceReference(EventAdmin.class);
        if (ref != null) {
            eventAdmin = (EventAdmin)Activator.getContext().getService(ref);
        }
        return eventAdmin;
    }

    public ThemeManager.Registration registerScene(final Scene scene) {
        this.managedScenes.add(scene);
        final InvalidationListener l = o -> {
            String themeId = this.currentThemeId;
            if (scene.getRoot() != null && themeId != null) {
                scene.getRoot().getStyleClass().remove((Object)DefaultThemeManager.getCSSClassname(themeId));
                scene.getRoot().getStyleClass().add((Object)DefaultThemeManager.getCSSClassname(themeId));
            }
        };
        String themeId = this.currentThemeId;
        if (themeId != null) {
            scene.getRoot().getStyleClass().remove((Object)DefaultThemeManager.getCSSClassname(themeId));
            scene.getRoot().getStyleClass().add((Object)DefaultThemeManager.getCSSClassname(themeId));
        }
        scene.rootProperty().addListener(l);
        return new ThemeManager.Registration(){

            public void dispose() {
                scene.rootProperty().removeListener(l);
                DefaultThemeManager.this.managedScenes.remove(scene);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTheme(@NonNull Theme theme) {
        ObservableMap<String, Theme> observableMap = this.themes;
        synchronized (observableMap) {
            this.themes.put((Object)theme.getId(), (Object)theme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTheme(@NonNull Theme theme) {
        ObservableMap<String, Theme> observableMap = this.themes;
        synchronized (observableMap) {
            this.themes.remove((Object)theme);
        }
    }
}

