/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.TraceRegion;

public class TraceRegionSerializer {
    private static final int VERSION_3 = 3;
    private static final int VERSION_4 = 4;
    private static final int VERSION_5 = 5;

    public void writeTraceRegionTo(AbstractTraceRegion region, OutputStream stream) throws IOException {
        if (region != null && region.getParent() != null) {
            throw new IllegalArgumentException("region must be the root");
        }
        this.doWriteTo(new IdentityStrategy(), region, stream);
    }

    public <Region, Location> void doWriteTo(final Strategy<Region, Location> strategy, Region region, OutputStream stream) throws IOException {
        final DataOutputStream dataStream = new DataOutputStream(new BufferedOutputStream(stream));
        try {
            dataStream.writeInt(5);
            dataStream.writeBoolean(region != null);
            if (region == null) {
                return;
            }
            strategy.writeRegion(region, new Callback<Region, Location>(){

                @Override
                public void doWriteRegion(int offset, int length, int lineNumber, int endLineNumber, boolean isUseForDebugging, List<Location> locations, List<Region> children) throws IOException {
                    TraceRegionSerializer.this.writeCompressedInt(dataStream, offset);
                    TraceRegionSerializer.this.writeCompressedInt(dataStream, length);
                    TraceRegionSerializer.this.writeCompressedInt(dataStream, lineNumber);
                    TraceRegionSerializer.this.writeCompressedInt(dataStream, endLineNumber);
                    dataStream.writeBoolean(isUseForDebugging);
                    TraceRegionSerializer.this.writeCompressedInt(dataStream, locations.size());
                    for (Object loc : locations) {
                        strategy.writeLocation(loc, this);
                    }
                    TraceRegionSerializer.this.writeCompressedInt(dataStream, children.size());
                    for (Object child : children) {
                        strategy.writeRegion(child, this);
                    }
                }

                @Override
                public void doWriteLocation(int offset, int length, int lineNumber, int endLineNumber, SourceRelativeURI path) throws IOException {
                    TraceRegionSerializer.this.writeCompressedInt(dataStream, offset);
                    TraceRegionSerializer.this.writeCompressedInt(dataStream, length);
                    TraceRegionSerializer.this.writeCompressedInt(dataStream, lineNumber);
                    TraceRegionSerializer.this.writeCompressedInt(dataStream, endLineNumber);
                    if (path != null) {
                        dataStream.writeBoolean(true);
                        dataStream.writeUTF(path.getURI().toString());
                    } else {
                        dataStream.writeBoolean(false);
                    }
                }
            });
        }
        finally {
            dataStream.flush();
        }
    }

    private void writeCompressedInt(DataOutput output, int value) throws IOException {
        if (++value < 0) {
            throw new IOException("All values are expected to be positive, but got: " + String.valueOf(value - 1));
        }
        if (value <= 63) {
            output.writeByte(value);
        } else if (value <= 16383) {
            output.writeByte(value >> 8 | 0x40);
            output.writeByte(value & 0xFF);
        } else if (value <= 0x3FFFFF) {
            output.writeByte(value >> 16 | 0x80);
            output.writeByte(value >> 8 & 0xFF);
            output.writeByte(value & 0xFF);
        } else if (value <= 0x3FFFFFFF) {
            output.writeByte(value >> 24 | 0xC0);
            output.writeByte(value >> 16 & 0xFF);
            output.writeByte(value >> 8 & 0xFF);
            output.writeByte(value & 0xFF);
        } else {
            throw new IOException("Invalid value: " + String.valueOf(value - 1));
        }
    }

    public AbstractTraceRegion readTraceRegionFrom(InputStream contents) throws IOException {
        return this.doReadFrom(contents, new IdentityStrategy());
    }

    public <Region, Location> Region doReadFrom(InputStream contents, Strategy<Region, Location> reader) throws IOException {
        boolean isNull;
        DataInputStream dataStream = new DataInputStream(new BufferedInputStream(contents));
        int version = dataStream.readInt();
        if (version != 3 && version != 4 && version != 5) {
            return null;
        }
        boolean bl = isNull = !dataStream.readBoolean();
        if (isNull) {
            return null;
        }
        if (version >= 5) {
            return this.doReadFrom(new CompressedIntDataInput(dataStream), reader, null, version);
        }
        return this.doReadFrom(dataStream, reader, null, version);
    }

    public <Location, Region> Region doReadFrom(DataInput dataStream, Strategy<Region, Location> reader, Region parent, int version) throws IOException {
        int offset = dataStream.readInt();
        int length = dataStream.readInt();
        int lineNumber = dataStream.readInt();
        int endLineNumber = dataStream.readInt();
        boolean useForDebugging = version < 5 || dataStream.readBoolean();
        int locationSize = dataStream.readInt();
        ArrayList allLocations = Lists.newArrayListWithCapacity((int)locationSize);
        while (locationSize != 0) {
            SourceRelativeURI path;
            int locationOffset = dataStream.readInt();
            int locationLength = dataStream.readInt();
            int locationLineNumber = dataStream.readInt();
            int locationEndLineNumber = dataStream.readInt();
            if (dataStream.readBoolean()) {
                if (version < 5) {
                    URI uri = URI.createURI((String)dataStream.readUTF());
                    if (version == 3 && !uri.isRelative()) {
                        if (uri.isPlatform()) {
                            String platformString = uri.toPlatformString(false);
                            path = new SourceRelativeURI(platformString.substring(platformString.indexOf(47) + 1));
                        } else {
                            path = uri.isFile() ? new SourceRelativeURI(uri.lastSegment()) : SourceRelativeURI.fromAbsolute(uri);
                        }
                    } else {
                        path = new SourceRelativeURI(uri);
                    }
                } else {
                    path = new SourceRelativeURI(dataStream.readUTF());
                }
            } else {
                path = null;
            }
            if (version == 3 && dataStream.readBoolean()) {
                dataStream.readUTF();
            }
            allLocations.add(reader.createLocation(locationOffset, locationLength, locationLineNumber, locationEndLineNumber, path));
            --locationSize;
        }
        Region result = reader.createRegion(offset, length, lineNumber, endLineNumber, useForDebugging, allLocations, parent);
        int childrenSize = dataStream.readInt();
        while (childrenSize != 0) {
            this.doReadFrom(dataStream, reader, result, version);
            --childrenSize;
        }
        return result;
    }

    public static interface Callback<Region, Location> {
        public void doWriteRegion(int var1, int var2, int var3, int var4, boolean var5, List<Location> var6, List<Region> var7) throws IOException;

        public void doWriteLocation(int var1, int var2, int var3, int var4, SourceRelativeURI var5) throws IOException;
    }

    protected static class CompressedIntDataInput
    extends FilterInputStream
    implements DataInput {
        private DataInput delegate;

        public <Delegate extends InputStream> CompressedIntDataInput(Delegate delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.delegate.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.delegate.readByte();
        }

        @Override
        public char readChar() throws IOException {
            return this.delegate.readChar();
        }

        @Override
        public double readDouble() throws IOException {
            return this.delegate.readDouble();
        }

        @Override
        public float readFloat() throws IOException {
            return this.delegate.readFloat();
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.delegate.readFully(b);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.delegate.readFully(b, off, len);
        }

        @Override
        public int readInt() throws IOException {
            byte initialByte = this.readByte();
            int code = initialByte >> 6 & 3;
            switch (code) {
                case 0: {
                    return initialByte - 1;
                }
                case 1: {
                    return (initialByte << 8 & 0x3F00 | this.readByte() & 0xFF) - 1;
                }
                case 2: {
                    return (initialByte << 16 & 0x3F0000 | this.readByte() << 8 & 0xFF00 | this.readByte() & 0xFF) - 1;
                }
            }
            return (initialByte << 24 & 0x3F000000 | this.readByte() << 16 & 0xFF0000 | this.readByte() << 8 & 0xFF00 | this.readByte() & 0xFF) - 1;
        }

        @Override
        public String readLine() throws IOException {
            return null;
        }

        @Override
        public long readLong() throws IOException {
            return this.delegate.readLong();
        }

        @Override
        public short readShort() throws IOException {
            return this.delegate.readShort();
        }

        @Override
        public String readUTF() throws IOException {
            return this.delegate.readUTF();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.delegate.readUnsignedByte();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.delegate.readUnsignedShort();
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return this.delegate.skipBytes(n);
        }
    }

    protected static class IdentityStrategy
    implements Strategy<AbstractTraceRegion, ILocationData> {
        protected IdentityStrategy() {
        }

        @Override
        public ILocationData createLocation(int offset, int length, int lineNumber, int endLineNumber, SourceRelativeURI path) {
            return new LocationData(offset, length, lineNumber, endLineNumber, path);
        }

        @Override
        public AbstractTraceRegion createRegion(int offset, int length, int lineNumber, int endLineNumber, boolean useForDebugging, List<ILocationData> associations, AbstractTraceRegion parent) {
            return new TraceRegion(offset, length, lineNumber, endLineNumber, useForDebugging, associations, parent);
        }

        @Override
        public void writeRegion(AbstractTraceRegion region, Callback<AbstractTraceRegion, ILocationData> callback) throws IOException {
            callback.doWriteRegion(region.getMyOffset(), region.getMyLength(), region.getMyLineNumber(), region.getMyEndLineNumber(), region.isUseForDebugging(), region.getAssociatedLocations(), region.getNestedRegions());
        }

        @Override
        public void writeLocation(ILocationData location, Callback<AbstractTraceRegion, ILocationData> callback) throws IOException {
            callback.doWriteLocation(location.getOffset(), location.getLength(), location.getLineNumber(), location.getEndLineNumber(), location.getSrcRelativePath());
        }
    }

    public static interface Strategy<Region, Location> {
        public Location createLocation(int var1, int var2, int var3, int var4, SourceRelativeURI var5);

        public Region createRegion(int var1, int var2, int var3, int var4, boolean var5, List<Location> var6, Region var7);

        public void writeRegion(Region var1, Callback<Region, Location> var2) throws IOException;

        public void writeLocation(Location var1, Callback<Region, Location> var2) throws IOException;
    }
}

