/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.behavior;

import java.util.List;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.ui.controls.styledtext.ActionEvent;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextLayoutContainer;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;
import org.eclipse.fx.ui.controls.styledtext.skin.StyledTextSkin;

public class StyledTextBehavior {
    private final StyledTextArea styledText;

    public StyledTextBehavior(StyledTextArea styledText) {
        this.styledText = styledText;
        styledText.addEventHandler(KeyEvent.ANY, this::callActionForEvent);
    }

    protected StyledTextArea getControl() {
        return this.styledText;
    }

    protected void callActionForEvent(KeyEvent arg0) {
        if (arg0.getEventType() == KeyEvent.KEY_PRESSED) {
            this._keyPressed(arg0);
        } else if (arg0.getEventType() == KeyEvent.KEY_TYPED) {
            this._keyTyped(arg0);
        }
    }

    public void mousePressed(MouseEvent arg0) {
        this.getControl().requestFocus();
    }

    protected void invokeAction(ActionEvent.ActionType action) {
        ActionEvent evt = new ActionEvent((Object)this.getControl(), (EventTarget)this.getControl(), action);
        Event.fireEvent((EventTarget)this.getControl(), (Event)evt);
    }

    private void _keyPressed(KeyEvent event) {
        VerifyEvent evt = new VerifyEvent((Object)this.getControl(), (EventTarget)this.getControl(), event);
        Event.fireEvent((EventTarget)this.getControl(), (Event)evt);
        if (Util.isMacOS() && (event.getCode() == KeyCode.ALT || event.isAltDown())) {
            event.consume();
        }
        if (evt.isConsumed()) {
            event.consume();
            return;
        }
        int currentRowIndex = this.getControl().getContent().getLineAtOffset(this.getControl().getCaretOffset());
        int offset = this.getControl().getCaretOffset();
        switch (event.getCode()) {
            case SHIFT: 
            case CONTROL: 
            case ALT: {
                break;
            }
            case LEFT: {
                if (event.isAltDown()) {
                    this.invokeAction(ActionEvent.ActionType.WORD_PREVIOUS);
                    break;
                }
                if (offset == 0) {
                    event.consume();
                    break;
                }
                int newOffset = offset - 1;
                this.getControl().getContent().getLineAtOffset(offset);
                this.getControl().getContent().getLineAtOffset(newOffset);
                this.getControl().impl_setCaretOffset(newOffset, event.isShiftDown());
                event.consume();
                break;
            }
            case RIGHT: {
                if (event.isAltDown()) {
                    this.invokeAction(ActionEvent.ActionType.WORD_NEXT);
                    break;
                }
                if (event.isMetaDown()) {
                    int currentLine = this.getControl().getContent().getLineAtOffset(offset);
                    int lineOffset = this.getControl().getContent().getOffsetAtLine(currentLine);
                    String lineContent = this.getControl().getContent().getLine(currentLine);
                    this.getControl().impl_setCaretOffset(lineOffset + lineContent.length(), event.isShiftDown());
                    event.consume();
                    break;
                }
                if (offset + 1 > this.getControl().getContent().getCharCount()) break;
                int newOffset = offset + 1;
                this.getControl().impl_setCaretOffset(newOffset, event.isShiftDown());
                event.consume();
                break;
            }
            case UP: {
                int rowIndex = currentRowIndex;
                if (rowIndex == 0) break;
                int colIdx = offset - this.getControl().getContent().getOffsetAtLine(rowIndex);
                int lineOffset = this.getControl().getContent().getOffsetAtLine(--rowIndex);
                int newCaretPosition = lineOffset + colIdx;
                int maxPosition = lineOffset + this.getControl().getContent().getLine(rowIndex).length();
                this.getControl().impl_setCaretOffset(Math.min(newCaretPosition, maxPosition), event.isShiftDown());
                event.consume();
                break;
            }
            case DOWN: {
                int rowIndex = currentRowIndex;
                if (rowIndex + 1 == this.getControl().getContent().getLineCount()) break;
                int colIdx = offset - this.getControl().getContent().getOffsetAtLine(rowIndex);
                int lineOffset = this.getControl().getContent().getOffsetAtLine(++rowIndex);
                int newCaretPosition = lineOffset + colIdx;
                int maxPosition = lineOffset + this.getControl().getContent().getLine(rowIndex).length();
                this.getControl().impl_setCaretOffset(Math.min(newCaretPosition, maxPosition), event.isShiftDown());
                event.consume();
                break;
            }
            case ENTER: {
                if (!this.getControl().getEditable()) break;
                int line = this.getControl().getContent().getLineAtOffset(this.getControl().getCaretOffset());
                String lineContent = this.getControl().getContent().getLine(line);
                char[] chars = lineContent.toCharArray();
                String prefix = "";
                int i = 0;
                while (i < chars.length) {
                    if (chars[i] != ' ') break;
                    prefix = String.valueOf(prefix) + " ";
                    ++i;
                }
                String newLine = System.getProperty("line.separator");
                this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset(), 0, String.valueOf(newLine) + prefix);
                this.getControl().setCaretOffset(offset + newLine.length() + prefix.length());
                break;
            }
            case DELETE: {
                if (this.getControl().getEditable()) {
                    if (event.isMetaDown()) {
                        this.invokeAction(ActionEvent.ActionType.DELETE_WORD_NEXT);
                        break;
                    }
                    this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset(), 1, "");
                    this.getControl().setCaretOffset(offset);
                    break;
                }
            }
            case BACK_SPACE: {
                if (this.getControl().getEditable()) {
                    if (event.isMetaDown()) {
                        this.invokeAction(ActionEvent.ActionType.DELETE_WORD_PREVIOUS);
                        break;
                    }
                    TextSelection selection = this.getControl().getSelection();
                    if (selection.length > 0) {
                        this.getControl().getContent().replaceTextRange(selection.offset, selection.length, "");
                        this.getControl().setCaretOffset(selection.offset);
                        break;
                    }
                    this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset() - 1, 1, "");
                    this.getControl().setCaretOffset(offset - 1);
                    break;
                }
            }
            case TAB: {
                if (this.getControl().getEditable()) {
                    event.consume();
                    if (event.isShiftDown()) break;
                    this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset(), 0, "\t");
                    this.getControl().setCaretOffset(offset + 1);
                    break;
                }
            }
            case V: {
                if (this.getControl().getEditable() && event.isShortcutDown()) {
                    this.getControl().paste();
                    event.consume();
                    break;
                }
            }
            case X: {
                if (this.getControl().getEditable() && event.isShortcutDown()) {
                    this.getControl().cut();
                    event.consume();
                    break;
                }
            }
            case C: {
                if (!event.isShortcutDown()) break;
                this.getControl().copy();
                event.consume();
                break;
            }
        }
    }

    private void _keyTyped(KeyEvent event) {
        if (this.getControl().getEditable()) {
            String character = event.getCharacter();
            if (character.length() == 0) {
                return;
            }
            if ((event.isControlDown() || event.isAltDown() || Util.isMacOS() && event.isMetaDown()) && (!event.isControlDown() && !Util.isMacOS() || !event.isAltDown())) {
                return;
            }
            if (character.charAt(0) > '\u001f' && character.charAt(0) != '\u007f' && !event.isMetaDown()) {
                int offset = this.getControl().getCaretOffset();
                this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset(), 0, character);
                this.getControl().setCaretOffset(offset + 1);
            }
        }
    }

    public void updateCursor(MouseEvent event, List<StyledTextSkin.LineCell> visibleCells, boolean selection) {
        StyledTextSkin.LineCell lastCell = null;
        for (StyledTextSkin.LineCell tmp : visibleCells) {
            Bounds boundsInParent = tmp.getBoundsInParent();
            if (boundsInParent.getMinY() > event.getY()) {
                int index;
                if (lastCell == null) {
                    lastCell = tmp;
                }
                if (lastCell.getDomainElement() == null) break;
                StyledTextLayoutContainer n = (StyledTextLayoutContainer)lastCell.getGraphic();
                if (n.localToScene(n.getBoundsInLocal()).contains(event.getSceneX(), event.getSceneY()) && (index = n.getCaretIndexAtPoint(n.sceneToLocal(event.getSceneX(), event.getSceneY()))) >= 0) {
                    this.getControl().impl_setCaretOffset(n.getStartOffset() + index, selection);
                    return;
                }
                int offset = lastCell.getDomainElement().getLineOffset() + lastCell.getDomainElement().getLineLength();
                this.getControl().impl_setCaretOffset(offset, selection);
                break;
            }
            lastCell = tmp;
        }
        this.getControl().requestFocus();
        Event.fireEvent((EventTarget)this.getControl(), (Event)event.copyFor((Object)this.getControl(), (EventTarget)this.getControl()));
    }
}

