/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.eclipse.fx.ui.controls.stage.ResizeableFramePane;
import org.eclipse.fx.ui.dialogs.Messages;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Dialog {
    public static final int OK_BUTTON = 1;
    public static final int CANCEL_BUTTON = 2;
    private Stage stage;
    private boolean blockOnOpen = true;
    private int returnCode;
    private List<Button> buttons;
    private String title;
    private Window parent;

    public Dialog(@Nullable Window parent, @NonNull String title) {
        this.parent = parent;
        this.title = title;
    }

    protected Parent createContents() {
        BorderPane p = new BorderPane();
        p.getStyleClass().add((Object)this.getClass().getSimpleName());
        HBox box = new HBox();
        box.setPadding(this.getContentInset());
        Node content = this.createDialogArea();
        HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
        box.getChildren().add((Object)content);
        p.setCenter((Node)box);
        p.setBottom(this.createButtonBar());
        return p;
    }

    protected Insets getContentInset() {
        return new Insets(10.0, 10.0, 0.0, 10.0);
    }

    protected abstract Node createDialogArea();

    protected Node createButtonBar() {
        HBox b = new HBox(10.0);
        b.setPadding(new Insets(10.0));
        Region spacer = new Region();
        b.getChildren().add((Object)spacer);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.buttons = this.createButtonsForBar();
        b.getChildren().addAll(this.buttons);
        return b;
    }

    protected List<Button> createButtonsForBar() {
        ArrayList<Button> rv = new ArrayList<Button>();
        rv.add(this.createButtonForBar(2, Messages.getString("Dialog.Cancel"), this.isOkDefault(2), this.isCancelDefault(2)));
        rv.add(this.createButtonForBar(1, Messages.getString("Dialog.Ok"), this.isOkDefault(1), this.isCancelDefault(1)));
        return rv;
    }

    protected boolean isOkDefault(int buttonId) {
        return buttonId == 1;
    }

    protected boolean isCancelDefault(int buttonId) {
        return buttonId == 2;
    }

    protected Button createButtonForBar(final int type, String label, boolean defaultOkButton, boolean defaultCancel) {
        Button b = new Button(label);
        b.setDefaultButton(defaultOkButton);
        b.setCancelButton(defaultCancel);
        b.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Dialog.this.buttonPressed(type);
            }
        });
        return b;
    }

    protected void buttonPressed(int type) {
        if (type == 2) {
            this.cancelPressed();
        } else if (type == 1) {
            this.okPressed();
        }
    }

    protected void okPressed() {
        this.returnCode = 1;
        this.close();
    }

    protected void cancelPressed() {
        this.returnCode = 2;
        this.close();
    }

    protected void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    protected void close() {
        this.stage.close();
    }

    protected List<String> getStylesheets() {
        if (this.parent != null) {
            return Collections.unmodifiableList(this.parent.getScene().getStylesheets());
        }
        return Collections.emptyList();
    }

    protected Stage create() {
        Stage stage = new Stage();
        stage.setTitle(this.title);
        stage.initOwner(this.parent);
        stage.initModality(this.getModality());
        Parent content = this.createContents();
        ResizeableFramePane rootContainer = this.getCustomWindowPane();
        if (rootContainer == null) {
            rootContainer = new BorderPane();
            ((BorderPane)rootContainer).setCenter((Node)content);
        } else {
            stage.initStyle(StageStyle.UNDECORATED);
            rootContainer.setClientArea((Node)content);
            rootContainer.setTitle(this.title);
        }
        Scene s = new Scene((Parent)rootContainer);
        s.getStylesheets().addAll(this.getStylesheets());
        stage.setScene(s);
        Point2D size = this.getInitialSize((Parent)rootContainer);
        if (size != null) {
            stage.setWidth(size.getX());
            stage.setHeight(size.getY());
        } else {
            rootContainer.impl_processCSS(true);
            size = this.getInitialContentSize((Parent)rootContainer);
            if (size != null) {
                rootContainer.setPrefSize(size.getX(), size.getY());
            }
        }
        Point2D location = this.getInitialLocation(content);
        if (location != null) {
            stage.setX(location.getX());
            stage.setY(location.getY());
        }
        return stage;
    }

    protected ResizeableFramePane getCustomWindowPane() {
        return null;
    }

    protected Point2D getInitialContentSize(Parent rootContainer) {
        return null;
    }

    protected Point2D getInitialSize(Parent rootContainer) {
        return null;
    }

    protected Point2D getInitialLocation(Parent rootContainer) {
        return null;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.stage.setX((double)x);
        this.stage.setY((double)y);
        this.stage.setWidth((double)width);
        this.stage.setHeight((double)height);
    }

    public @NonNull Rectangle getBounds() {
        return new Rectangle(this.stage.getX(), this.stage.getY(), this.stage.getWidth(), this.stage.getHeight());
    }

    public void pack() {
        this.stage.sizeToScene();
    }

    void layout() {
        double maxWidth = 0.0;
        for (Button b : this.buttons) {
            maxWidth = Math.max(maxWidth, b.prefWidth(-1.0));
        }
        for (Button b : this.buttons) {
            b.setPrefWidth(maxWidth);
        }
    }

    protected Modality getModality() {
        return Modality.WINDOW_MODAL;
    }

    public int open() {
        if (this.stage == null) {
            this.stage = this.create();
            this.stage.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        Dialog.this.layout();
                    }
                }
            });
        }
        this.preopen(this.stage);
        if (this.blockOnOpen) {
            this.stage.showAndWait();
        } else {
            this.stage.show();
        }
        return this.returnCode;
    }

    protected void preopen(Stage s) {
    }
}

