/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx.services;

import java.util.function.Supplier;
import javafx.scene.Node;
import org.eclipse.fx.code.editor.services.CompletionProposal;
import org.eclipse.fx.text.ui.contentassist.ICompletionProposal;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.jface.text.IDocument;

public class FXCompletionProposal
implements ICompletionProposal {
    private final CompletionProposal proposal;
    private final Supplier<Node> graphicSupplier;
    private final CharSequence label;

    public FXCompletionProposal(CompletionProposal proposal, Supplier<Node> graphicSupplier) {
        this(proposal, proposal.getLabel(), graphicSupplier);
    }

    public FXCompletionProposal(CompletionProposal proposal, CharSequence label, Supplier<Node> graphicSupplier) {
        this.proposal = proposal;
        this.label = label;
        this.graphicSupplier = graphicSupplier;
    }

    public Node getGraphic() {
        return this.graphicSupplier.get();
    }

    public CharSequence getLabel() {
        return this.label;
    }

    public void apply(IDocument document) {
        this.proposal.apply(document);
    }

    public TextSelection getSelection(IDocument document) {
        CompletionProposal.TextSelection selection = this.proposal.getSelection(document);
        return new TextSelection(selection.offset, selection.length);
    }
}

