/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonObject;
import org.eclipse.fx.code.editor.configuration.Check;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.TokenScanner;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;
import org.eclipse.fx.code.editor.configuration.gson.GsonElementFactory;

public final class GsonTokenScannerImpl
implements GsonBase,
TokenScanner {
    private final Check check;

    public GsonTokenScannerImpl(JsonObject jsonObject) {
        this.check = jsonObject.has("check") ? GsonElementFactory.createCheck(jsonObject.getAsJsonObject("check")) : null;
    }

    public GsonTokenScannerImpl(Check check) {
        this.check = check;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "TokenScanner");
        o.add("check", this.getCheck() == null ? null : ((GsonBase)((Object)this.getCheck())).toJSONObject());
        return o;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()) + " { " + "check : " + (this.check == null ? null : String.valueOf(this.check.getClass().getSimpleName()) + "@" + Integer.toHexString(this.check.hashCode())) + " }";
    }

    @Override
    public Check getCheck() {
        return this.check;
    }

    public static class Builder
    implements TokenScanner.Builder {
        private final EditorGModel instance;
        private Check check;

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder check(Check check) {
            this.check = check;
            return this;
        }

        @Override
        public TokenScanner build() {
            return new GsonTokenScannerImpl(this.check);
        }
    }
}

