/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.skin;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.TextChangedEvent;
import org.eclipse.fx.ui.controls.styledtext.TextChangingEvent;
import org.eclipse.fx.ui.controls.styledtext.behavior.StyledTextBehavior;
import org.eclipse.fx.ui.controls.styledtext.internal.ContentView;
import org.eclipse.fx.ui.controls.styledtext.internal.FXBindUtil;
import org.eclipse.fx.ui.controls.styledtext.internal.LineHelper;
import org.eclipse.fx.ui.controls.styledtext.internal.LineRuler;
import org.eclipse.fx.ui.controls.styledtext.internal.ScrollbarPane;
import org.eclipse.fx.ui.controls.styledtext.internal.Scroller;
import org.eclipse.fx.ui.controls.styledtext.internal.VerticalLineFlow;
import org.eclipse.fx.ui.controls.styledtext.model.Annotation;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationPresenter;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationProvider;
import org.eclipse.fx.ui.controls.styledtext.model.LineRulerAnnotationPresenter;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotationPresenter;

public class StyledTextSkin
extends SkinBase<StyledTextArea> {
    private ScrollbarPane<ContentView> contentArea;
    private ContentView content;
    Scroller scroller;
    private HBox lineRulerArea;
    private ObservableList<LineRuler> sortedLineRulerFlows;
    private HBox rootContainer;
    private final StyledTextBehavior behavior;
    private LineHelper lineHelper;
    private static final String CSS_CLASS_LINE_RULER = "line-ruler";
    private static final String CSS_CLASS_SPACER = "spacer";
    private static final String CSS_LIST_VIEW = "list-view";

    public StyledTextSkin(StyledTextArea styledText) {
        this(styledText, new StyledTextBehavior(styledText));
    }

    public StyledTextSkin(StyledTextArea styledText, StyledTextBehavior behavior) {
        super((Control)styledText);
        this.behavior = behavior;
        this.rootContainer = new HBox();
        this.rootContainer.setSpacing(0.0);
        this.lineRulerArea = new HBox();
        this.lineRulerArea.setPadding(new Insets(1.0, 0.0, 0.0, 0.0));
        this.rootContainer.getChildren().add((Object)this.lineRulerArea);
        styledText.caretOffsetProperty().addListener((obs, ol, ne) -> {
            int lineIdx = styledText.getContent().getLineAtOffset(ne.intValue());
            int colIdx = ne.intValue() - styledText.getContent().getOffsetAtLine(lineIdx);
            this.scrollColumnIntoView(colIdx);
            this.scrollLineIntoView(lineIdx);
        });
        Region spacer = new Region();
        spacer.getStyleClass().addAll((Object[])new String[]{CSS_CLASS_LINE_RULER, CSS_CLASS_SPACER});
        spacer.setMinWidth(2.0);
        spacer.setMaxWidth(2.0);
        this.rootContainer.getChildren().add((Object)spacer);
        this.lineHelper = new LineHelper((StyledTextArea)this.getSkinnable());
        this.content = new ContentView(this.lineHelper, styledText);
        this.content.lineHeightProperty().bind((ObservableValue)styledText.fixedLineHeightProperty());
        this.contentArea = new ScrollbarPane();
        this.contentArea.setCenter(this.content);
        HashMap<AnnotationProvider, Subscription> subscriptions = new HashMap<AnnotationProvider, Subscription>();
        Consumer<RangeSet<Integer>> onAnnotationChange = r -> {
            this.content.updateAnnotations((RangeSet<Integer>)r);
            this.sortedLineRulerFlows.forEach(f -> f.update((RangeSet<Integer>)r));
        };
        ((StyledTextArea)this.getSkinnable()).getAnnotationProvider().addListener(c -> {
            Subscription s;
            if (c.wasAdded()) {
                s = ((AnnotationProvider)c.getElementAdded()).registerChangeListener(onAnnotationChange);
                subscriptions.put((AnnotationProvider)c.getElementAdded(), s);
            }
            if (c.wasRemoved() && (s = (Subscription)subscriptions.remove(c.getElementRemoved())) != null) {
                s.dispose();
            }
        });
        for (AnnotationProvider p2 : ((StyledTextArea)this.getSkinnable()).getAnnotationProvider()) {
            if (subscriptions.containsKey(p2)) continue;
            Subscription s = p2.registerChangeListener(onAnnotationChange);
            subscriptions.put(p2, s);
        }
        this.content.getStyleClass().addAll((Object[])new String[]{CSS_LIST_VIEW});
        this.content.focusedProperty().addListener((x, o, n) -> {
            if (n != null && n.booleanValue()) {
                ((StyledTextArea)this.getSkinnable()).requestFocus();
            }
        });
        this.getBehavior().installContentListeners((Region)this.content);
        this.content.contentProperty().bind(((StyledTextArea)this.getSkinnable()).contentProperty());
        this.content.setOnScroll(e -> this.scroller.scrollBy(Math.round(-e.getDeltaY())));
        HBox.setHgrow(this.contentArea, (Priority)Priority.ALWAYS);
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.contentArea});
        this.getChildren().addAll((Object[])new Node[]{this.rootContainer});
        this.scroller = new Scroller();
        this.scroller.contentAreaHeightProperty().bind((ObservableValue)this.content.heightProperty());
        this.scroller.lineHeightProperty().bind((ObservableValue)this.content.lineHeightProperty());
        this.content.bindHorizontalScrollbar(this.contentArea.horizontal);
        ((IntegerProperty)((StyledTextArea)this.getSkinnable()).lineCountProperty()).bind((ObservableValue)this.content.numberOfLinesProperty());
        this.scroller.lineCountProperty().bind((ObservableValue)this.content.numberOfLinesProperty());
        this.scroller.bind(this.contentArea.vertical);
        this.content.textSelectionProperty().bind(((StyledTextArea)this.getSkinnable()).selectionProperty());
        this.content.caretOffsetProperty().bind((ObservableValue)((StyledTextArea)this.getSkinnable()).caretOffsetProperty());
        this.content.visibleLinesProperty().bind(this.scroller.visibleLinesProperty());
        Consumer<Double> updateOffset = offset -> {
            Range visibleLines = (Range)this.scroller.visibleLinesProperty().get();
            ContiguousSet set = ContiguousSet.create((Range)visibleLines, (DiscreteDomain)DiscreteDomain.integers());
            double lineHeight = this.scroller.lineHeightProperty().get();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                double y = (double)index * lineHeight - offset;
                for (VerticalLineFlow flow : this.sortedLineRulerFlows) {
                    flow.setLineOffset(index, y);
                }
            }
        };
        this.content.offsetYProperty().bind((ObservableValue)this.scroller.offsetProperty());
        this.scroller.offsetProperty().addListener((x, o, offset) -> updateOffset.accept(offset.doubleValue()));
        this.scroller.visibleLinesProperty().addListener(x -> updateOffset.accept(this.scroller.offsetProperty().get()));
        ((StyledTextArea)this.getSkinnable()).getContent().addTextChangeListener(new StyledTextContent.TextChangeListener(){

            @Override
            public void textSet(TextChangedEvent event) {
                StyledTextSkin.this.scroller.refresh();
            }

            @Override
            public void textChanging(TextChangingEvent event) {
            }

            @Override
            public void textChanged(TextChangedEvent event) {
            }
        });
        ObservableList lineRulerPresenters = FXCollections.observableArrayList();
        SortedList sortedLineRulerPresenters = new SortedList(lineRulerPresenters, (a, b) -> a.getOrder() - b.getOrder());
        Function<LineRulerAnnotationPresenter, LineRuler> map = ap -> {
            Function<Integer, Set<Annotation>> converter = index -> this.lineHelper.getAnnotations((int)index).stream().filter(ap::isApplicable).collect(Collectors.toSet());
            Predicate<Set<Annotation>> needsPresentation = ap::isVisible;
            Supplier<Node> nodeFactory = ap::createNode;
            BiConsumer<Node, Set<Annotation>> populator = ap::updateNode;
            LineRuler flow = new LineRuler(ap.getLayoutHint(), converter, needsPresentation, nodeFactory, populator);
            flow.visibleLinesProperty().bind(this.scroller.visibleLinesProperty());
            flow.numberOfLinesProperty().bind((ObservableValue)this.content.numberOfLinesProperty());
            flow.lineHeightProperty().bind((ObservableValue)this.content.lineHeightProperty());
            flow.yOffsetProperty().bind((ObservableValue)this.scroller.offsetProperty());
            flow.absoluteMinWidthProperty().bind((ObservableValue)ap.getWidth());
            flow.prefWidthProperty().addListener((x, o, n) -> this.rootContainer.requestLayout());
            return flow;
        };
        this.sortedLineRulerFlows = FXCollections.observableArrayList();
        this.sortedLineRulerFlows.addListener(x -> {
            for (VerticalLineFlow flow : this.sortedLineRulerFlows) {
                flow.getStyleClass().setAll((Object[])new String[]{CSS_CLASS_LINE_RULER});
            }
        });
        FXBindUtil.uniMapBindList(sortedLineRulerPresenters, this.sortedLineRulerFlows, map);
        FXBindUtil.uniMapBindList(this.sortedLineRulerFlows, this.lineRulerArea.getChildren(), flow -> flow);
        this.sortedLineRulerFlows.addListener(c -> {
            while (c.next()) {
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(f -> {
                    f.visibleLinesProperty().unbind();
                    f.numberOfLinesProperty().unbind();
                    f.prefWidthProperty().unbind();
                });
            }
        });
        Consumer<AnnotationPresenter> installPresenter = p -> {
            if (p instanceof LineRulerAnnotationPresenter) {
                LineRulerAnnotationPresenter lrp = (LineRulerAnnotationPresenter)p;
                lineRulerPresenters.add((Object)lrp);
            } else if (p instanceof TextAnnotationPresenter) {
                TextAnnotationPresenter tp = (TextAnnotationPresenter)p;
                this.content.textAnnotationPresenterProperty().add((Object)tp);
            }
        };
        Consumer<AnnotationPresenter> uninstallPresenter = p -> {
            if (p instanceof LineRulerAnnotationPresenter) {
                LineRulerAnnotationPresenter lrp = (LineRulerAnnotationPresenter)p;
                lineRulerPresenters.remove((Object)lrp);
            } else if (p instanceof TextAnnotationPresenter) {
                TextAnnotationPresenter tp = (TextAnnotationPresenter)p;
                this.content.textAnnotationPresenterProperty().remove((Object)tp);
            }
        };
        ((StyledTextArea)this.getSkinnable()).getAnnotationPresenter().addListener(c -> {
            if (c.wasAdded()) {
                installPresenter.accept((AnnotationPresenter)c.getElementAdded());
            }
            if (c.wasRemoved()) {
                uninstallPresenter.accept((AnnotationPresenter)c.getElementRemoved());
            }
            RangeSet r = TreeRangeSet.create().complement();
            this.content.updateAnnotations((RangeSet<Integer>)r);
            this.sortedLineRulerFlows.forEach(f -> f.update((RangeSet<Integer>)r));
            this.rootContainer.requestLayout();
        });
        ((StyledTextArea)this.getSkinnable()).getAnnotationPresenter().forEach(installPresenter);
    }

    private void scrollColumnIntoView(int colIndex) {
        double lastColDiff;
        double colOffset;
        double w = 8.0;
        double curOffset = this.contentArea.horizontal.getValue();
        if (curOffset > (colOffset = w * (double)colIndex)) {
            this.contentArea.horizontal.setValue(colOffset);
        }
        if (curOffset + (lastColDiff = this.content.getWidth() - w) < colOffset) {
            this.contentArea.horizontal.setValue(colOffset - lastColDiff);
        }
    }

    private void scrollLineIntoView(int lineIndex) {
        this.scroller.scrollIntoView(lineIndex);
    }

    StyledTextBehavior getBehavior() {
        return this.behavior;
    }

    public double getLineHeight(int caretPosition) {
        if (((StyledTextArea)this.getSkinnable()).getFixedLineHeight() >= 0.0) {
            return ((StyledTextArea)this.getSkinnable()).getFixedLineHeight();
        }
        return -1.0;
    }

    public Point2D getCaretLocation(int caretPosition) {
        if (caretPosition < 0) {
            return null;
        }
        Optional<Point2D> location = this.content.getLocationInScene(caretPosition);
        return location.map(l -> this.rootContainer.sceneToLocal(l)).map(l -> new Point2D(l.getX(), l.getY() + this.content.getLineHeight())).orElse(null);
    }

    public void scrollLineUp() {
        this.scroller.scrollBy(-1);
    }

    public void scrollLineDown() {
        this.scroller.scrollBy(1);
    }

    static String removeLineending(String s) {
        return s.replace("\n", "").replace("\r", "");
    }

    public int getOffsetAtPosition(double x, double y) {
        return this.content.getLineIndex(new Point2D(x, y)).orElse(-1);
    }
}

