/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.internal;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.text.Text;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.text.ui.IFeature;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.model.Annotation;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationProvider;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotation;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotationPresenter;
import org.eclipse.jdt.annotation.NonNull;

public class InvisibleCharSupport
implements IFeature {
    @Override
    public Subscription install(final StyledTextArea control) {
        final InvisibleCharAnnotationProvider provider = new InvisibleCharAnnotationProvider(control);
        final InvisibleCharAnnotationPresenter presenter = new InvisibleCharAnnotationPresenter();
        control.getAnnotationProvider().add((Object)provider);
        control.getAnnotationPresenter().add((Object)presenter);
        return new Subscription(){

            public void dispose() {
                control.getAnnotationProvider().remove((Object)provider);
                control.getAnnotationPresenter().remove((Object)presenter);
            }
        };
    }

    public class InvisibleCharAnnotation
    implements TextAnnotation {
        private final Range range;
        private final String symbol;

        public Range getRange() {
            return this.range;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public InvisibleCharAnnotation(String symbol, Range range) {
            this.symbol = symbol;
            this.range = range;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
            result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InvisibleCharAnnotation other = (InvisibleCharAnnotation)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.range == null ? other.range != null : !this.range.equals((Object)other.range)) {
                return false;
            }
            return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
        }

        private InvisibleCharSupport getOuterType() {
            return InvisibleCharSupport.this;
        }
    }

    public class InvisibleCharAnnotationPresenter
    implements TextAnnotationPresenter {
        public boolean isApplicable(Annotation annotation) {
            return annotation instanceof InvisibleCharAnnotation;
        }

        public Node createNode() {
            Text n = new Text();
            n.getStyleClass().add((Object)"invisible-char");
            return n;
        }

        public boolean isVisible(Annotation annotation) {
            return true;
        }

        public void updateNode(Node node, Annotation annotation) {
            Text t = (Text)node;
            InvisibleCharAnnotation a = (InvisibleCharAnnotation)annotation;
            t.setText(a.getSymbol());
        }
    }

    public class InvisibleCharAnnotationProvider
    implements AnnotationProvider {
        private StyledTextArea control;

        public InvisibleCharAnnotationProvider(StyledTextArea control) {
            this.control = control;
        }

        public Set<? extends Annotation> computeAnnotations(int index) {
            @NonNull StyledTextContent content = this.control.getContent();
            HashSet<InvisibleCharAnnotation> annotations = new HashSet<InvisibleCharAnnotation>();
            int lineBegin = content.getOffsetAtLine(index);
            int lineLength = content.getLine(index).length();
            String line = content.getTextRange(lineBegin, lineLength);
            int numOfLines = content.getLineCount();
            Pattern tab = Pattern.compile("\\t");
            Matcher matcher = tab.matcher(line);
            while (matcher.find()) {
                annotations.add(new InvisibleCharAnnotation("\u21e5", Range.closed((Comparable)Integer.valueOf(matcher.start()), (Comparable)Integer.valueOf(matcher.start() + 1))));
            }
            if (index < numOfLines - 1) {
                annotations.add(new InvisibleCharAnnotation("\u21b5", Range.closed((Comparable)Integer.valueOf(lineLength), (Comparable)Integer.valueOf(lineLength + 1))));
            }
            return annotations;
        }

        public Subscription registerChangeListener(Consumer<RangeSet<Integer>> onChange) {
            return new Subscription(){

                public void dispose() {
                }
            };
        }
    }
}

