/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding.converters;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.jdt.annotation.NonNull;

public abstract class LocalDateConverter
extends Converter {
    LocalDateConverter(@NonNull Object fromType, @NonNull Object toType) {
        super(fromType, toType);
    }

    public static LocalDateConverter fromDateToLocalDate() {
        return new LocalDateConverter(Date.class, LocalDate.class){

            public Object convert(Object fromObject) {
                if (fromObject == null) {
                    return null;
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime((Date)fromObject);
                ZonedDateTime zdt = cal.toZonedDateTime();
                return zdt.toLocalDateTime().toLocalDate();
            }
        };
    }

    public static LocalDateConverter fromLocalDateTotoDate() {
        return new LocalDateConverter(LocalDate.class, Date.class){

            public Object convert(Object fromObject) {
                if (fromObject == null) {
                    return null;
                }
                return GregorianCalendar.from(((LocalDate)fromObject).atStartOfDay(ZoneId.systemDefault())).getTime();
            }
        };
    }
}

