/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base.addons;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.ui.workbench.renderers.base.services.MaximizationService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMinMaxableWidget;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.event.Event;

public class MinMaxAddon {
    static String MINIMIZED = "Minimized";
    static String MAXIMIZED = "Maximized";
    private final EModelService modelService;

    @Inject
    MinMaxAddon(IEventBroker eventBroker, EModelService modelService) {
        this.modelService = modelService;
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this::handleWidget);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this::handleChildrenChanged);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this::handleVisibleChildrenChanged);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", this::handleVisibleChildrenChanged);
    }

    void handleChildrenChanged(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (changedElement instanceof MElementContainer && this.modelService.toBeRenderedCount((MElementContainer)changedElement) == 0) {
            this.handleMinMaxCallback(WMinMaxableWidget.WMinMaxState.RESTORE, changedElement);
        }
    }

    void handleVisibleChildrenChanged(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (!changedElement.isToBeRendered() || !changedElement.isVisible()) {
            this.handleMinMaxCallback(WMinMaxableWidget.WMinMaxState.RESTORE, changedElement);
        }
        if (changedElement.getParent() != null && this.modelService.toBeRenderedCount(changedElement.getParent()) == 0) {
            this.handleMinMaxCallback(WMinMaxableWidget.WMinMaxState.RESTORE, (MUIElement)changedElement.getParent());
        }
    }

    void handleWidget(Event event) {
        WMinMaxableWidget widget;
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (changedElement != null && (widget = this.getTargetWidget(changedElement)) != null) {
            widget.setMinMaxCallback(s -> this.handleMinMaxCallback((WMinMaxableWidget.WMinMaxState)((Object)s), changedElement));
        }
    }

    Void handleMinMaxCallback(WMinMaxableWidget.WMinMaxState state, @NonNull MUIElement changedElement) {
        IEclipseContext context = changedElement instanceof MContext ? ((MContext)changedElement).getContext() : this.modelService.getContainingContext(changedElement);
        if (context == null) {
            return null;
        }
        MaximizationService maximizationService = (MaximizationService)context.get(MaximizationService.class);
        if (state == WMinMaxableWidget.WMinMaxState.TOGGLE) {
            if (maximizationService.isMaximized(changedElement)) {
                maximizationService.restore();
            } else {
                maximizationService.maximize(changedElement);
            }
        } else if (state == WMinMaxableWidget.WMinMaxState.MAXIMIZE) {
            if (!maximizationService.isMaximized(changedElement)) {
                maximizationService.maximize(changedElement);
            }
        } else if (maximizationService.isMaximized(changedElement)) {
            maximizationService.restore();
        }
        return null;
    }

    private WMinMaxableWidget getTargetWidget(MUIElement changedElement) {
        if (changedElement instanceof MPlaceholder) {
            return this.getTargetWidget(((MPlaceholder)changedElement).getRef());
        }
        if (changedElement.getWidget() instanceof WMinMaxableWidget) {
            return (WMinMaxableWidget)changedElement.getWidget();
        }
        return null;
    }
}

