/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.hover.internal;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.stage.PopupWindow;
import javafx.stage.Screen;
import javafx.stage.Window;
import org.eclipse.fx.text.ui.hover.internal.ResizeablePane;

public class ResizeablePopupWindow
extends PopupWindow {
    private ResizeablePane root = new ResizeablePane();
    private Consumer<Point2D> windowSizePersister;
    private Supplier<Point2D> windowSizeRetriever;
    private double lineHeight = 20.0;

    public void configureWindowSize(Supplier<Point2D> windowSizeRetriever, Consumer<Point2D> windowSizePersister) {
        this.windowSizePersister = windowSizePersister;
        this.windowSizeRetriever = windowSizeRetriever;
    }

    public ResizeablePopupWindow(Node content) {
        this.root.setContent(content);
        this.root.setWindow((Window)this);
        this.root.widthProperty().addListener((x, o, n) -> this.setWidth(n.doubleValue()));
        this.root.heightProperty().addListener((x, o, n) -> this.setHeight(n.doubleValue()));
        this.getScene().setRoot((Parent)this.root);
        this.root.widthProperty().addListener(this::saveWindowSize);
        this.root.heightProperty().addListener(this::saveWindowSize);
    }

    private void saveWindowSize(Observable o) {
        if (this.windowSizePersister != null) {
            Point2D size = new Point2D(this.root.getWidth(), this.root.getHeight());
            this.windowSizePersister.accept(size);
        }
    }

    public void show(Node ownerNode, double anchorX, double anchorY, double lineHeight) {
        this.lineHeight = lineHeight;
        super.show(ownerNode, anchorX, anchorY);
    }

    public void show(Window ownerWindow, double anchorX, double anchorY, double lineHeight) {
        this.lineHeight = lineHeight;
        super.show(ownerWindow, anchorX, anchorY);
    }

    protected void show() {
        if (this.windowSizeRetriever != null) {
            Point2D size = this.windowSizeRetriever.get();
            double w = size.getX();
            double h = size.getY();
            this.root.layout();
            this.root.applyCss();
            w = Math.max(w, this.root.computeMinWidth(-1.0) + 30.0);
            h = Math.max(h, this.root.computeMinHeight(-1.0) + 20.0);
            this.root.setMinWidth(w);
            this.root.setMaxWidth(w);
            this.root.setPrefWidth(w);
            this.root.setMinHeight(h);
            this.root.setMaxHeight(h);
            this.root.setPrefHeight(h);
        }
        Screen screen = (Screen)Screen.getScreensForRectangle((double)this.getAnchorX(), (double)this.getAnchorY(), (double)0.0, (double)0.0).get(0);
        Rectangle2D popupArea = new Rectangle2D(this.getAnchorX(), this.getAnchorY(), this.root.getWidth(), this.root.getHeight());
        double x = this.getAnchorX();
        double y = this.getAnchorY();
        if (!screen.getVisualBounds().contains(popupArea)) {
            if (popupArea.getMaxX() > screen.getVisualBounds().getMaxX()) {
                x = screen.getVisualBounds().getMaxX() - popupArea.getWidth();
            }
            if (popupArea.getMaxY() > screen.getVisualBounds().getMaxY()) {
                y -= popupArea.getHeight() + this.lineHeight;
            }
        }
        this.setX(x);
        this.setY(y);
        super.show();
    }
}

