/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.form;

import javafx.beans.property.ReadOnlyProperty;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.ui.controls.form.SimpleDecoratedNode;

public class StatusNode
extends Region {
    private static PseudoClass error = PseudoClass.getPseudoClass((String)"error");
    private static PseudoClass warning = PseudoClass.getPseudoClass((String)"warning");
    private static PseudoClass ok = PseudoClass.getPseudoClass((String)"ok");
    private static PseudoClass cancel = PseudoClass.getPseudoClass((String)"cancel");
    static final String BASE_STYLESHEET = SimpleDecoratedNode.class.getResource("status-icon.css").toExternalForm();

    public StatusNode(ReadOnlyProperty<Status> statusProperty) {
        Label statusIcon = new Label();
        statusIcon.getStyleClass().add((Object)"status-icon");
        StatusNode.updatePseudoState((Node)statusIcon, (Status)statusProperty.getValue());
        statusProperty.addListener((o, ol, ne) -> StatusNode.updatePseudoState((Node)statusIcon, ne));
        this.getChildren().add((Object)statusIcon);
    }

    public String getUserAgentStylesheet() {
        return BASE_STYLESHEET;
    }

    private static void updatePseudoState(Node statusIcon, Status status) {
        statusIcon.pseudoClassStateChanged(error, status.getState() == Status.State.ERROR);
        statusIcon.pseudoClassStateChanged(warning, status.getState() == Status.State.WARNING);
        statusIcon.pseudoClassStateChanged(ok, status.getState() == Status.State.OK);
        statusIcon.pseudoClassStateChanged(cancel, status.getState() == Status.State.CANCEL);
    }
}

