/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.fxloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.fx.osgi.fxloader.FXClassloaderConfigurator;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;

public class FXClassLoader
extends ClassLoaderHook {
    private static final String FX_SYMBOLIC_NAME = "org.eclipse.fx.javafx";
    private static final String SWT_SYMBOLIC_NAME = "org.eclipse.swt";
    private URLClassLoader classLoader;
    private BundleContext frameworkContext;
    private ClassLoader j9Classloader;
    private Object moduleLayer;
    private static Boolean IS_EQUAL_GREATER_11;
    private static Boolean IS_JAVA_8;
    private static Map<String, ServiceTracker<Object, URLConverter>> urlTrackers;

    static {
        urlTrackers = new HashMap<String, ServiceTracker<Object, URLConverter>>();
    }

    static boolean isJDK8() {
        if (IS_JAVA_8 != null) {
            return IS_JAVA_8;
        }
        boolean rv = System.getProperty("java.version", "").startsWith("1.8");
        IS_JAVA_8 = rv;
        return rv;
    }

    private static boolean isEqualGreaterJDK11() {
        if (IS_EQUAL_GREATER_11 != null) {
            return IS_EQUAL_GREATER_11;
        }
        String version = System.getProperty("java.version", "");
        String[] parts = version.split("\\D");
        boolean rv = false;
        try {
            rv = Integer.parseInt(parts[0]) >= 11;
        }
        catch (Throwable throwable) {}
        IS_EQUAL_GREATER_11 = rv;
        return rv;
    }

    public Class<?> postFindClass(String name, ModuleClassLoader moduleClassLoader) throws ClassNotFoundException {
        if (FXClassLoader.isJDK8()) {
            if ((name.startsWith("javafx") || name.startsWith("netscape.javascript") || name.startsWith("com.sun.glass.events") || name.startsWith("com.sun.glass.ui") || name.startsWith("com.sun.javafx") || name.startsWith("com.sun.media.jfxmedia") || name.startsWith("com.sun.media.jfxmediaimpl") || name.startsWith("com.sun.openpisces") || name.startsWith("com.sun.pisces") || name.startsWith("com.sun.prism") || name.startsWith("com.sun.scenario") || name.startsWith("com.sun.webkit")) && !moduleClassLoader.getBundle().getSymbolicName().equals(SWT_SYMBOLIC_NAME)) {
                URLClassLoader fxClassloader = this.getFXClassloader();
                if (fxClassloader != null) {
                    return fxClassloader.loadClass(name);
                }
                throw new ClassNotFoundException("Unable to locate JavaFX. Please make sure you have a JDK with JavaFX installed eg on Linux you require an Oracle JDK");
            }
        } else {
            if (FXClassLoader.isEqualGreaterJDK11()) {
                try {
                    return this.findClassJavaFX11(name, moduleClassLoader);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            if (name.startsWith("javafx.embed")) {
                if (this.j9Classloader == null) {
                    try {
                        this.j9Classloader = FXClassLoader.createModuleLoader(this.getModuleLayer(), "javafx.swt");
                        try {
                            this.j9Classloader.loadClass("javafx.application.Platform").getDeclaredMethod("setImplicitExit", Boolean.TYPE).invoke(null, Boolean.FALSE);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Throwable e) {
                        throw new ClassNotFoundException("Could not find class '" + name + "'", e);
                    }
                }
                return this.j9Classloader.loadClass(name);
            }
        }
        return super.postFindClass(name, moduleClassLoader);
    }

    private Class<?> findClassJavaFX11(String name, ModuleClassLoader moduleClassLoader) throws Throwable {
        ClassLoader parentClassloader;
        if (FXClassloaderConfigurator.DEBUG) {
            System.err.println("FXClassLoader#findClassJavaFX11 - started");
            System.err.println("Loading class '" + name + "'");
        }
        if ((parentClassloader = FXClassLoader.getSWTClassloader(this.frameworkContext)) == null) {
            parentClassloader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if (FXClassloaderConfigurator.DEBUG) {
            System.err.println("FXClassLoader#findClassJavaFX11 - Classloader used " + parentClassloader);
        }
        ClassLoader javafxClassloader = FXClassLoader.createModuleLoader(this.getModuleLayer(), "javafx.base");
        if (FXClassloaderConfigurator.DEBUG) {
            System.err.println("FXClassLoader#findClassJavaFX11 - Using classloader " + javafxClassloader);
        }
        Class<?> loadClass = javafxClassloader.loadClass(name);
        if (FXClassloaderConfigurator.DEBUG) {
            System.err.println("FXClassLoader#findClassJavaFX11 - ended");
        }
        return loadClass;
    }

    private static ClassLoader createModuleLoader(Object moduleLayer, String moduleName) throws Throwable {
        ClassLoader loader = (ClassLoader)moduleLayer.getClass().getMethod("findLoader", String.class).invoke(moduleLayer, moduleName);
        return loader;
    }

    private Object getModuleLayer() throws Throwable {
        ClassLoader parentClassloader = FXClassLoader.getSWTClassloader(this.frameworkContext);
        if (parentClassloader == null) {
            parentClassloader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if (FXClassLoader.isEqualGreaterJDK11()) {
            if (this.moduleLayer == null) {
                String javafxDir = System.getProperty("efxclipse.java-modules.dir");
                List<FXProviderBundle> providers = javafxDir == null ? FXClassLoader.getDeployedJavaModuleBundlePaths(this.frameworkContext) : Files.list(Paths.get(javafxDir, new String[0])).filter(p -> p.toString().endsWith(".jar")).map(p -> new FXProviderBundle(p.getFileName().toString().replace(".jar", "").replace('-', '.'), (Path)p)).collect(Collectors.toList());
                this.moduleLayer = this.initModuleLayer(parentClassloader, providers);
            }
        } else if (this.moduleLayer == null) {
            Path path = Paths.get(System.getProperty("java.home"), new String[0]).resolve("lib").resolve("javafx-swt.jar");
            this.moduleLayer = this.initModuleLayer(parentClassloader, Collections.singletonList(new FXProviderBundle("javafx.swt", path)));
        }
        return this.moduleLayer;
    }

    private Object initModuleLayer(ClassLoader parentClassloader, List<FXProviderBundle> bundles) throws Throwable {
        Path[] paths = (Path[])bundles.stream().map(p -> p.path).toArray(Path[]::new);
        Set modules = bundles.stream().map(p -> p.module).collect(Collectors.toSet());
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        Class<?> ModuleFinderClass = cl.loadClass("java.lang.module.ModuleFinder");
        Class<?> LayerClass = cl.loadClass("java.lang.ModuleLayer");
        Class<?> ConfigurationClass = cl.loadClass("java.lang.module.Configuration");
        Object finder = ModuleFinderClass.getMethod("of", Path[].class).invoke(null, new Object[]{paths});
        Object boot = LayerClass.getMethod("boot", new Class[0]).invoke(null, new Object[0]);
        Object configuration = LayerClass.getMethod("configuration", new Class[0]).invoke(boot, new Object[0]);
        Object of = ModuleFinderClass.getMethod("of", Path[].class).invoke(null, new Object[]{new Path[0]});
        Object cf = ConfigurationClass.getMethod("resolve", ModuleFinderClass, ModuleFinderClass, Collection.class).invoke(configuration, finder, of, modules);
        Object layer = LayerClass.getMethod("defineModulesWithOneLoader", ConfigurationClass, ClassLoader.class).invoke(boot, cf, parentClassloader);
        return layer;
    }

    private URLClassLoader getFXClassloader() {
        if (this.classLoader == null) {
            ClassLoader swtClassloader = FXClassLoader.getSWTClassloader(this.frameworkContext);
            this.classLoader = FXClassLoader.createJREBundledClassloader(swtClassloader == null ? ClassLoader.getSystemClassLoader() : swtClassloader, swtClassloader != null);
        }
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URLConverter getURLConverter(URL url, BundleContext ctx) {
        if (url == null || ctx == null) {
            return null;
        }
        String protocol = url.getProtocol();
        Map<String, ServiceTracker<Object, URLConverter>> map = urlTrackers;
        synchronized (map) {
            ServiceTracker tracker = urlTrackers.get(protocol);
            if (tracker == null) {
                String FILTER_PREFIX = "(&(objectClass=" + URLConverter.class.getName() + ")(protocol=";
                String FILTER_POSTFIX = "))";
                Filter filter = null;
                try {
                    filter = ctx.createFilter(String.valueOf(FILTER_PREFIX) + protocol + FILTER_POSTFIX);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    return null;
                }
                tracker = new ServiceTracker(ctx, filter, null);
                tracker.open();
                urlTrackers.put(protocol, (ServiceTracker<Object, URLConverter>)tracker);
            }
            return (URLConverter)tracker.getService();
        }
    }

    public ModuleClassLoader createClassLoader(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
        if (this.frameworkContext == null) {
            this.frameworkContext = generation.getBundleInfo().getStorage().getModuleContainer().getFrameworkWiring().getBundle().getBundleContext();
        }
        if (FX_SYMBOLIC_NAME.equals(generation.getRevision().getBundle().getSymbolicName())) {
            System.err.println("ERROR: Binding against 'org.eclipse.fx.javafx' had been deprecated since 2.x and has been removed in 3.x ");
        }
        return super.createClassLoader(parent, configuration, delegate, generation);
    }

    private static ClassLoader getSWTClassloader(BundleContext context) {
        try {
            Bundle[] bundleArray = context.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                if (SWT_SYMBOLIC_NAME.equals(b.getSymbolicName()) && (b.getState() & 2) == 0) {
                    if ((b.getState() & 0x20) != 0) {
                        try {
                            b.start();
                        }
                        catch (BundleException e) {
                            e.printStackTrace();
                        }
                    }
                    return ((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader();
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            System.err.println("Failed to access swt classloader");
            t.printStackTrace();
        }
        return null;
    }

    private static List<FXProviderBundle> getDeployedJavaModuleBundlePaths(BundleContext context) {
        ArrayList<FXProviderBundle> paths = new ArrayList<FXProviderBundle>();
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getHeaders().get("Java-Module") != null) {
                String name = (String)b.getHeaders().get("Java-Module");
                URL entry = b.getEntry(String.valueOf(name) + ".jar");
                if (entry == null) {
                    entry = b.getEntry(String.valueOf(name.replace('.', '-')) + ".jar");
                }
                if (entry != null) {
                    URLConverter converter = FXClassLoader.getURLConverter(entry, context);
                    try {
                        URL url = converter.toFileURL(entry);
                        paths.add(new FXProviderBundle(name, Paths.get(url.getFile(), new String[0])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        return paths;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URLClassLoader createJREBundledClassloader(ClassLoader parent, boolean swtAvailable) {
        block30: {
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Started");
            }
            try {
                javaHome = new File(System.getProperty("java.home")).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to locate java home", e);
            }
            if (!javaHome.exists()) {
                throw new IllegalStateException("The java home '" + javaHome.getAbsolutePath() + "' does not exits");
            }
            jarFile = new File(new File(new File(javaHome.getAbsolutePath(), "lib"), "ext"), "jfxrt.jar");
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Assumed location (Java 8/Java 7): " + jarFile.getAbsolutePath());
            }
            if (!jarFile.exists()) ** GOTO lbl63
            if (!swtAvailable) break block30;
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - SWT is available use different loading strategy");
            }
            swtFX = new File(new File(javaHome.getAbsolutePath(), "lib"), "jfxswt.jar");
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Searching for SWT-FX integration at " + swtFX.getAbsolutePath());
            }
            if (swtFX.exists()) {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Found SWT/FX");
                }
                if ((extClassLoader = ClassLoader.getSystemClassLoader().getParent()).getClass().getName().equals("sun.misc.Launcher$ExtClassLoader")) {
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader#createJREBundledClassloader - Delegate to system classloader");
                    }
                    var7_13 = new URLClassLoader(new URL[]{swtFX.getCanonicalFile().toURI().toURL()}, (ClassLoader)new SWTFXClassloader(parent, extClassLoader));
                    if (FXClassloaderConfigurator.DEBUG == false) return var7_13;
                    System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                    return var7_13;
                }
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Using an URL classloader");
                }
                return new URLClassLoader(new URL[]{jarFile.getCanonicalFile().toURI().toURL(), swtFX.getCanonicalFile().toURI().toURL()}, parent);
            }
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Assume that SWT-FX part of jfxrt.jar");
            }
            url = jarFile.getCanonicalFile().toURI().toURL();
            var7_15 = new URLClassLoader(new URL[]{url}, parent);
            if (FXClassloaderConfigurator.DEBUG == false) return var7_15;
            System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
            return var7_15;
        }
        try {
            extClassLoader = ClassLoader.getSystemClassLoader().getParent();
            if (extClassLoader.getClass().getName().equals("sun.misc.Launcher$ExtClassLoader")) {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Delegate to system classloader");
                }
                var7_16 = new URLClassLoader(new URL[0], extClassLoader);
                if (FXClassloaderConfigurator.DEBUG == false) return var7_16;
                System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                return var7_16;
            }
            ** GOTO lbl55
        }
        catch (Throwable t) {
            block31: {
                t.printStackTrace();
lbl55:
                // 2 sources

                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Using an URL classloader");
                }
                url = jarFile.getCanonicalFile().toURI().toURL();
                var7_17 = cl = new URLClassLoader(new URL[]{url}, parent);
                if (FXClassloaderConfigurator.DEBUG == false) return var7_17;
                System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                return var7_17;
lbl63:
                // 2 sources

                jarFile = new File(new File(javaHome.getAbsolutePath(), "lib"), "jfxrt.jar");
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Assumed location (Java 7): " + jarFile.getAbsolutePath());
                }
                if (!jarFile.exists()) break block31;
                url = jarFile.getCanonicalFile().toURI().toURL();
                var7_18 = new URLClassLoader(new URL[]{url}, parent);
                if (FXClassloaderConfigurator.DEBUG == false) return var7_18;
                System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                return var7_18;
            }
            try {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - File does not exist.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (FXClassloaderConfigurator.DEBUG == false) return null;
        System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
        return null;
    }

    static class EmptyEnumeration
    implements Enumeration<URL> {
        static Enumeration<URL> INSTANCE = new EmptyEnumeration();

        EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            return null;
        }
    }

    static class FXProviderBundle {
        final String module;
        final Path path;

        public FXProviderBundle(String module, Path path) {
            this.module = module;
            this.path = path;
        }

        public String toString() {
            return "FXProviderBundle [module=" + this.module + ", path=" + this.path + "]";
        }
    }

    static class SWTFXClassloader
    extends ClassLoader {
        private final ClassLoader lastResortLoader;
        private final ClassLoader primaryLoader;
        private Boolean checkFlag = null;

        public SWTFXClassloader(ClassLoader lastResortLoader, ClassLoader primaryLoader) {
            this.lastResortLoader = lastResortLoader;
            this.primaryLoader = primaryLoader;
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader.SWTFXClassloader#init - Primary Loader " + primaryLoader);
                System.err.println("FXClassLoader.SWTFXClassloader#init - Lastresort Loader " + lastResortLoader);
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("javafx.embed.swt")) {
                if (this.checkFlag == null) {
                    this.checkFlag = Boolean.TRUE;
                    if (FXClassLoader.isJDK8()) {
                        Boolean isGTK3 = Boolean.FALSE;
                        try {
                            String value;
                            if (FXClassloaderConfigurator.DEBUG) {
                                System.err.println("FXModuleClassloader#findLocalClass - Someone is trying to load FXCanvas. Need to check for GTK3");
                            }
                            if ("gtk".equals(value = (String)this.loadClass("org.eclipse.swt.SWT").getDeclaredMethod("getPlatform", new Class[0]).invoke(null, new Object[0]))) {
                                if (FXClassloaderConfigurator.DEBUG) {
                                    System.err.println("FXModuleClassloader#findLocalClass - We are on GTK need to take a closer look");
                                }
                                try {
                                    isGTK3 = (Boolean)this.loadClass("org.eclipse.swt.internal.gtk.GTK").getDeclaredField("GTK3").get(null);
                                }
                                catch (Throwable throwable) {
                                    isGTK3 = (Boolean)this.loadClass("org.eclipse.swt.internal.gtk.OS").getDeclaredField("GTK3").get(null);
                                }
                            } else if (FXClassloaderConfigurator.DEBUG) {
                                System.err.println("FXModuleClassloader#findLocalClass - OS is '" + value + "' no need to get upset all is fine");
                            }
                        }
                        catch (Throwable e) {
                            System.err.println("FXModuleClassloader#findLocalClass - Failed to check for Gtk3");
                            e.printStackTrace();
                        }
                        if (isGTK3.booleanValue()) {
                            if (FXClassloaderConfigurator.DEBUG) {
                                System.err.println("FXModuleClassloader#findLocalClass - We are on GTK3 - too bad need to disable JavaFX for now else we'll crash the JVM");
                            }
                            throw new ClassNotFoundException("SWT is running with GTK3 but JavaFX is linked against GTK2");
                        }
                    }
                    try {
                        this.loadClass("javafx.application.Platform").getDeclaredMethod("setImplicitExit", Boolean.TYPE).invoke(null, Boolean.FALSE);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                return super.findClass(name);
            }
            try {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - Loading " + name + " with primary");
                }
                Class<?> loadClass = this.primaryLoader.loadClass(name);
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - Result " + name + " " + loadClass);
                }
                return loadClass;
            }
            catch (ClassNotFoundException c) {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - ClassNotFoundException thrown");
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - Loading " + name + " with last resort");
                }
                try {
                    Class<?> loadClass = this.lastResortLoader.loadClass(name);
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader.SWTFXClassloader#findClass - Result " + name + " " + loadClass);
                    }
                    return loadClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader.SWTFXClassloader#findClass - Even last resort was unable to load " + name);
                    }
                    throw c;
                }
            }
        }

        @Override
        protected URL findResource(String name) {
            URL url = this.primaryLoader.getResource(name);
            if (url == null) {
                url = this.lastResortLoader.getResource(name);
            }
            return url;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            final Enumeration<URL> en1 = this.primaryLoader.getResources(name);
            final Enumeration<URL> en2 = this.lastResortLoader.getResources(name);
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    if (en1.hasMoreElements()) {
                        return true;
                    }
                    return en2.hasMoreElements();
                }

                @Override
                public URL nextElement() {
                    if (!en1.hasMoreElements()) {
                        return (URL)en2.nextElement();
                    }
                    return (URL)en1.nextElement();
                }
            };
        }

        @Override
        public URL getResource(String name) {
            URL url = this.primaryLoader.getResource(name);
            if (url == null) {
                url = this.lastResortLoader.getResource(name);
            }
            return url;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream in = this.primaryLoader.getResourceAsStream(name);
            if (in == null) {
                in = this.lastResortLoader.getResourceAsStream(name);
            }
            return in;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final Enumeration<URL> en1 = this.primaryLoader.getResources(name);
            final Enumeration<URL> en2 = this.lastResortLoader.getResources(name);
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    if (en1.hasMoreElements()) {
                        return true;
                    }
                    return en2.hasMoreElements();
                }

                @Override
                public URL nextElement() {
                    if (!en1.hasMoreElements()) {
                        return (URL)en2.nextElement();
                    }
                    return (URL)en1.nextElement();
                }
            };
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.primaryLoader.loadClass(name);
            }
            catch (ClassNotFoundException c) {
                try {
                    return this.lastResortLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw c;
                }
            }
        }
    }
}

