/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings;

import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import org.eclipse.fx.core.bindings.FXCollector;
import org.eclipse.fx.core.bindings.internal.BindingStreamImpl;

public class FXCollectors {
    public static <T, S> FXCollector<T, Property<S>> toProperty(Function<T, Property<S>> map) {
        return stream -> {
            ObjectBinding binding = stream.mapNoObservable(map).collect(FXCollectors.toBinding());
            SimpleObjectProperty rv = new SimpleObjectProperty<S>(binding){
                private ObjectBinding<Property<S>> b;
                {
                    this.b = objectBinding;
                }
            };
            if (binding.get() != null) {
                rv.bindBidirectional((Property)binding.get());
            }
            binding.addListener((arg_0, arg_1, arg_2) -> FXCollectors.lambda$10((ObjectProperty)rv, arg_0, arg_1, arg_2));
            return rv;
        };
    }

    public static <T, S> FXCollector<T, ObjectProperty<S>> toObjectProperty(Function<T, ObjectProperty<S>> map) {
        return stream -> {
            ObjectBinding binding = stream.mapNoObservable(map).collect(FXCollectors.toBinding());
            SimpleObjectProperty rv = new SimpleObjectProperty<S>(binding){
                private ObjectBinding<ObjectProperty<S>> b;
                {
                    this.b = objectBinding;
                }
            };
            if (binding.get() != null) {
                rv.bindBidirectional((Property)binding.get());
            }
            binding.addListener((arg_0, arg_1, arg_2) -> FXCollectors.lambda$11((ObjectProperty)rv, arg_0, arg_1, arg_2));
            return rv;
        };
    }

    public static <T> FXCollector<T, StringProperty> toStringProperty(Function<T, StringProperty> map) {
        return stream -> {
            ObjectBinding binding = stream.mapNoObservable(map).collect(FXCollectors.toBinding());
            SimpleStringProperty rv = new SimpleStringProperty(binding){
                private ObjectBinding<StringProperty> b;
                {
                    this.b = objectBinding;
                }
            };
            if (binding.get() != null) {
                rv.bindBidirectional((Property)binding.get());
            }
            binding.addListener((arg_0, arg_1, arg_2) -> FXCollectors.lambda$12((StringProperty)rv, arg_0, arg_1, arg_2));
            return rv;
        };
    }

    public static <T> FXCollector<T, DoubleProperty> toDoubleProperty(Function<T, DoubleProperty> map) {
        return stream -> {
            ObjectBinding binding = stream.mapNoObservable(map).collect(FXCollectors.toBinding());
            SimpleDoubleProperty rv = new SimpleDoubleProperty(binding){
                private ObjectBinding<DoubleProperty> b;
                {
                    this.b = objectBinding;
                }
            };
            if (binding.get() != null) {
                rv.bindBidirectional((Property)binding.get());
            }
            binding.addListener((arg_0, arg_1, arg_2) -> FXCollectors.lambda$13((DoubleProperty)rv, arg_0, arg_1, arg_2));
            return rv;
        };
    }

    public static <T> FXCollector<T, BooleanProperty> toBooleanProperty(Function<T, BooleanProperty> map) {
        return stream -> {
            ObjectBinding binding = stream.mapNoObservable(map).collect(FXCollectors.toBinding());
            SimpleBooleanProperty rv = new SimpleBooleanProperty(binding){
                private ObjectBinding<BooleanProperty> b;
                {
                    this.b = objectBinding;
                }
            };
            if (binding.get() != null) {
                rv.bindBidirectional((Property)binding.get());
            }
            binding.addListener((arg_0, arg_1, arg_2) -> FXCollectors.lambda$14((BooleanProperty)rv, arg_0, arg_1, arg_2));
            return rv;
        };
    }

    public static <T> FXCollector<T, FloatProperty> toFloatProperty(Function<T, FloatProperty> map) {
        return stream -> {
            ObjectBinding binding = stream.mapNoObservable(map).collect(FXCollectors.toBinding());
            SimpleFloatProperty rv = new SimpleFloatProperty(binding){
                private ObjectBinding<FloatProperty> b;
                {
                    this.b = objectBinding;
                }
            };
            if (binding.get() != null) {
                rv.bindBidirectional((Property)binding.get());
            }
            binding.addListener((arg_0, arg_1, arg_2) -> FXCollectors.lambda$15((FloatProperty)rv, arg_0, arg_1, arg_2));
            return rv;
        };
    }

    public static <T> FXCollector<T, LongProperty> toLongProperty(Function<T, LongProperty> map) {
        return stream -> {
            ObjectBinding binding = stream.mapNoObservable(map).collect(FXCollectors.toBinding());
            SimpleLongProperty rv = new SimpleLongProperty(binding){
                private ObjectBinding<LongProperty> b;
                {
                    this.b = objectBinding;
                }
            };
            if (binding.get() != null) {
                rv.bindBidirectional((Property)binding.get());
            }
            binding.addListener((arg_0, arg_1, arg_2) -> FXCollectors.lambda$16((LongProperty)rv, arg_0, arg_1, arg_2));
            return rv;
        };
    }

    public static <T> FXCollector<T, IntegerProperty> toIntegerProperty(Function<T, IntegerProperty> map) {
        return stream -> {
            ObjectBinding binding = stream.mapNoObservable(map).collect(FXCollectors.toBinding());
            SimpleIntegerProperty rv = new SimpleIntegerProperty(binding){
                private ObjectBinding<IntegerProperty> b;
                {
                    this.b = objectBinding;
                }
            };
            if (binding.get() != null) {
                rv.bindBidirectional((Property)binding.get());
            }
            binding.addListener((arg_0, arg_1, arg_2) -> FXCollectors.lambda$17((IntegerProperty)rv, arg_0, arg_1, arg_2));
            return rv;
        };
    }

    public static <T> FXCollector<T, ObjectBinding<T>> toBinding() {
        return stream -> new BindingStreamImpl.StreamBinding(((BindingStreamImpl)stream).base, ((BindingStreamImpl)stream).path);
    }

    public static <T> FXCollector<T, ObjectBinding<T>> toBinding(final T nullReplacement) {
        return stream -> {
            final ObjectBinding b = stream.collect(FXCollectors.toBinding());
            ObjectBinding rv = new ObjectBinding<T>(){
                {
                    this.bind(new Observable[]{objectBinding});
                }

                protected T computeValue() {
                    return b.get() == null ? nullReplacement : b.get();
                }
            };
            return rv;
        };
    }

    private static /* synthetic */ void lambda$10(ObjectProperty objectProperty, ObservableValue o, Property ol, Property ne) {
        if (ol != null) {
            objectProperty.unbindBidirectional(ol);
        }
        if (ne != null) {
            objectProperty.bindBidirectional(ne);
        } else {
            objectProperty.set(null);
        }
    }

    private static /* synthetic */ void lambda$11(ObjectProperty objectProperty, ObservableValue o, ObjectProperty ol, ObjectProperty ne) {
        if (ol != null) {
            objectProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            objectProperty.bindBidirectional((Property)ne);
        } else {
            objectProperty.set(null);
        }
    }

    private static /* synthetic */ void lambda$12(StringProperty stringProperty, ObservableValue o, StringProperty ol, StringProperty ne) {
        if (ol != null) {
            stringProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            stringProperty.bindBidirectional((Property)ne);
        } else {
            stringProperty.set(null);
        }
    }

    private static /* synthetic */ void lambda$13(DoubleProperty doubleProperty, ObservableValue o, DoubleProperty ol, DoubleProperty ne) {
        if (ol != null) {
            doubleProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            doubleProperty.bindBidirectional((Property)ne);
        } else {
            doubleProperty.set(0.0);
        }
    }

    private static /* synthetic */ void lambda$14(BooleanProperty booleanProperty, ObservableValue o, BooleanProperty ol, BooleanProperty ne) {
        if (ol != null) {
            booleanProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            booleanProperty.bindBidirectional((Property)ne);
        } else {
            booleanProperty.set(false);
        }
    }

    private static /* synthetic */ void lambda$15(FloatProperty floatProperty, ObservableValue o, FloatProperty ol, FloatProperty ne) {
        if (ol != null) {
            floatProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            floatProperty.bindBidirectional((Property)ne);
        } else {
            floatProperty.set(0.0f);
        }
    }

    private static /* synthetic */ void lambda$16(LongProperty longProperty, ObservableValue o, LongProperty ol, LongProperty ne) {
        if (ol != null) {
            longProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            longProperty.bindBidirectional((Property)ne);
        } else {
            longProperty.set(0L);
        }
    }

    private static /* synthetic */ void lambda$17(IntegerProperty integerProperty, ObservableValue o, IntegerProperty ol, IntegerProperty ne) {
        if (ol != null) {
            integerProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            integerProperty.bindBidirectional((Property)ne);
        } else {
            integerProperty.set(0);
        }
    }
}

