/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.storage.friends;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.security.auth.AuthPlugin;
import org.eclipse.equinox.internal.security.auth.nls.SecAuthMessages;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesContainer;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesWrapper;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;

public class ReEncrypter {
    private final ISecurePreferences root;
    private final String moduleID;
    private boolean processedOK = true;
    private ArrayList<TmpElement> elements = new ArrayList();

    public ReEncrypter(ISecurePreferences prefs, String moduleID) {
        this.moduleID = moduleID;
        this.root = prefs.node("/");
    }

    public boolean decrypt() {
        this.decrypt(this.root);
        return this.processedOK;
    }

    private void decrypt(ISecurePreferences node) {
        String[] childrenNames;
        int n;
        int n2;
        String[] stringArray;
        String[] keys = node.keys();
        if (keys.length > 0) {
            HashMap<String, String> map = new HashMap<String, String>(keys.length);
            stringArray = keys;
            n2 = keys.length;
            n = 0;
            while (n < n2) {
                String key = stringArray[n];
                try {
                    String encryptionModule;
                    if (node.isEncrypted(key) && node instanceof SecurePreferencesWrapper && (encryptionModule = ((SecurePreferencesWrapper)node).getModule(key)) != null && encryptionModule.equals(this.moduleID)) {
                        map.put(key, node.get(key, null));
                    }
                }
                catch (StorageException e) {
                    String msg = NLS.bind((String)SecAuthMessages.decryptingError, (Object)key, (Object)node.absolutePath());
                    AuthPlugin.getDefault().logError(msg, e);
                    this.processedOK = false;
                }
                ++n;
            }
            if (map.size() != 0) {
                this.elements.add(new TmpElement(node.absolutePath(), map));
            }
        }
        stringArray = childrenNames = node.childrenNames();
        n2 = childrenNames.length;
        n = 0;
        while (n < n2) {
            String childrenName = stringArray[n];
            this.decrypt(node.node(childrenName));
            ++n;
        }
    }

    public boolean switchToNewPassword() {
        return ((SecurePreferencesWrapper)this.root).passwordChanging(this.moduleID);
    }

    public boolean encrypt() {
        boolean result = true;
        SecurePreferencesContainer container = ((SecurePreferencesWrapper)this.root).getContainer();
        Object originalProperty = container.getOption("org.eclipse.equinox.security.storage.requiredID");
        container.setOption("org.eclipse.equinox.security.storage.requiredID", this.moduleID);
        for (TmpElement element : this.elements) {
            ISecurePreferences node = this.root.node(element.getPath());
            Map<String, String> values = element.getValues();
            for (Map.Entry<String, String> entry : values.entrySet()) {
                String key = entry.getKey();
                try {
                    node.put(key, entry.getValue(), true);
                }
                catch (StorageException e) {
                    String msg = NLS.bind((String)SecAuthMessages.encryptingError, (Object)key, (Object)node.absolutePath());
                    AuthPlugin.getDefault().logError(msg, e);
                    result = false;
                }
            }
        }
        if (originalProperty != null) {
            container.setOption("org.eclipse.equinox.security.storage.requiredID", originalProperty);
        } else {
            container.removeOption("org.eclipse.equinox.security.storage.requiredID");
        }
        return result;
    }

    private class TmpElement {
        private String path;
        private Map<String, String> values;

        public TmpElement(String path, Map<String, String> values) {
            this.path = path;
            this.values = values;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, String> getValues() {
            return this.values;
        }
    }
}

