/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.fx.core.StatusImpl;
import org.eclipse.fx.core.ValueStatusImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface Status {
    public static final int UNKNOWN_RETURN_CODE = -1;

    public @NonNull State getState();

    public @Nullable String getMessage();

    public @Nullable Throwable getThrowable();

    public int getCode();

    public Optional<State> state();

    default public boolean isOk() {
        return this.getState() == State.OK;
    }

    default public boolean isNotOk() {
        return this.getState() != State.OK;
    }

    default public Optional<Status> filter(State ... states) {
        return this.is(states) ? Optional.of(this) : Optional.empty();
    }

    default public boolean is(State ... states) {
        return Stream.of(states).anyMatch(s -> s == this.getState());
    }

    public static @NonNull Status ok() {
        return StatusImpl.OK;
    }

    public static <O> @NonNull ValueStatus<O> ok(O value) {
        return Status.status(value, State.OK, 0, "", null);
    }

    public static @NonNull Status status(@NonNull State state, int code, @NonNull String message, @Nullable Throwable t) {
        return new StatusImpl(state, code, message, t);
    }

    public static <O> @NonNull ValueStatus<O> status(@Nullable O value, @NonNull State state, int code, @NonNull String message, @Nullable Throwable t) {
        return new ValueStatusImpl<O>(value, state, code, message, t);
    }

    public static enum State {
        ERROR,
        WARNING,
        CANCEL,
        OK;

    }

    public static interface ValueStatus<O>
    extends Status {
        public O getValue();
    }
}

