/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.fxloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.eclipse.fx.osgi.fxloader.FXClassloaderConfigurator;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWiring;

public class FXClassLoader
extends ClassLoaderHook {
    private static final String FX_SYMBOLIC_NAME = "org.eclipse.fx.javafx";
    private static final String SWT_SYMBOLIC_NAME = "org.eclipse.swt";

    public ModuleClassLoader createClassLoader(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
        if (FX_SYMBOLIC_NAME.equals(generation.getRevision().getBundle().getSymbolicName())) {
            ClassLoader swtClassloader = FXClassLoader.getSWTClassloader(generation);
            URLClassLoader cl = FXClassLoader.createJREBundledClassloader(swtClassloader == null ? parent : swtClassloader, swtClassloader != null);
            return new FXModuleClassloader(swtClassloader != null, cl, parent, configuration, delegate, generation);
        }
        return null;
    }

    private static ClassLoader getSWTClassloader(BundleInfo.Generation generation) {
        try {
            Bundle[] bundleArray = generation.getBundleInfo().getStorage().getModuleContainer().getFrameworkWiring().getBundle().getBundleContext().getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                if (SWT_SYMBOLIC_NAME.equals(b.getSymbolicName()) && (b.getState() & 2) == 0) {
                    if ((b.getState() & 0x20) != 0) {
                        try {
                            b.start();
                        }
                        catch (BundleException e) {
                            e.printStackTrace();
                        }
                    }
                    return ((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader();
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            System.err.println("Failed to access swt classloader");
            t.printStackTrace();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URLClassLoader createJREBundledClassloader(ClassLoader parent, boolean swtAvailable) {
        block30: {
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Started");
            }
            try {
                javaHome = new File(System.getProperty("java.home")).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to locate java home", e);
            }
            if (!javaHome.exists()) {
                throw new IllegalStateException("The java home '" + javaHome.getAbsolutePath() + "' does not exits");
            }
            jarFile = new File(new File(new File(javaHome.getAbsolutePath(), "lib"), "ext"), "jfxrt.jar");
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Assumed location (Java 8/Java 7): " + jarFile.getAbsolutePath());
            }
            if (!jarFile.exists()) ** GOTO lbl63
            if (!swtAvailable) break block30;
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - SWT is available use different loading strategy");
            }
            swtFX = new File(new File(javaHome.getAbsolutePath(), "lib"), "jfxswt.jar");
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Searching for SWT-FX integration at " + swtFX.getAbsolutePath());
            }
            if (swtFX.exists()) {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Found SWT/FX");
                }
                if ((extClassLoader = ClassLoader.getSystemClassLoader().getParent()).getClass().getName().equals("sun.misc.Launcher$ExtClassLoader")) {
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader#createJREBundledClassloader - Delegate to system classloader");
                    }
                    var7_13 = new URLClassLoader(new URL[]{swtFX.getCanonicalFile().toURI().toURL()}, (ClassLoader)new SWTFXClassloader(parent, extClassLoader));
                    if (FXClassloaderConfigurator.DEBUG == false) return var7_13;
                    System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                    return var7_13;
                }
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Using an URL classloader");
                }
                return new URLClassLoader(new URL[]{jarFile.getCanonicalFile().toURI().toURL(), swtFX.getCanonicalFile().toURI().toURL()}, parent);
            }
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader#createJREBundledClassloader - Assume that SWT-FX part of jfxrt.jar");
            }
            url = jarFile.getCanonicalFile().toURI().toURL();
            var7_15 = new URLClassLoader(new URL[]{url}, parent);
            if (FXClassloaderConfigurator.DEBUG == false) return var7_15;
            System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
            return var7_15;
        }
        try {
            extClassLoader = ClassLoader.getSystemClassLoader().getParent();
            if (extClassLoader.getClass().getName().equals("sun.misc.Launcher$ExtClassLoader")) {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Delegate to system classloader");
                }
                var7_16 = new URLClassLoader(new URL[0], extClassLoader);
                if (FXClassloaderConfigurator.DEBUG == false) return var7_16;
                System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                return var7_16;
            }
            ** GOTO lbl55
        }
        catch (Throwable t) {
            block31: {
                t.printStackTrace();
lbl55:
                // 2 sources

                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Using an URL classloader");
                }
                url = jarFile.getCanonicalFile().toURI().toURL();
                var7_17 = cl = new URLClassLoader(new URL[]{url}, parent);
                if (FXClassloaderConfigurator.DEBUG == false) return var7_17;
                System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                return var7_17;
lbl63:
                // 2 sources

                jarFile = new File(new File(javaHome.getAbsolutePath(), "lib"), "jfxrt.jar");
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - Assumed location (Java 7): " + jarFile.getAbsolutePath());
                }
                if (!jarFile.exists()) break block31;
                url = jarFile.getCanonicalFile().toURI().toURL();
                var7_18 = new URLClassLoader(new URL[]{url}, parent);
                if (FXClassloaderConfigurator.DEBUG == false) return var7_18;
                System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
                return var7_18;
            }
            try {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader#createJREBundledClassloader - File does not exist.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (FXClassloaderConfigurator.DEBUG == false) return null;
        System.err.println("FXClassLoader#createJREBundledClassloader - Ended");
        return null;
    }

    static class EmptyEnumeration
    implements Enumeration<URL> {
        static Enumeration<URL> INSTANCE = new EmptyEnumeration();

        EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            return null;
        }
    }

    static class FXModuleClassloader
    extends ModuleClassLoader {
        private final EquinoxConfiguration configuration;
        private final BundleLoader delegate;
        private final BundleInfo.Generation generation;
        private ClasspathManager classpathManager;
        boolean flag;

        public FXModuleClassloader(final boolean isSWT, final URLClassLoader fxClassloader, ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
            super(parent);
            this.configuration = configuration;
            this.delegate = delegate;
            this.generation = generation;
            this.classpathManager = new ClasspathManager(generation, this){

                public Class<?> findLocalClass(String classname) throws ClassNotFoundException {
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXModuleClassloader#findLocalClass trying to load class '" + classname + "'");
                    }
                    if (isSWT && !FXModuleClassloader.this.flag && "javafx.embed.swt.FXCanvas".equals(classname)) {
                        Boolean b = Boolean.FALSE;
                        FXModuleClassloader.this.flag = true;
                        try {
                            String value;
                            if (FXClassloaderConfigurator.DEBUG) {
                                System.err.println("FXModuleClassloader#findLocalClass - Someone is trying to load FXCanvas. Need to check for GTK3");
                            }
                            if ("gtk".equals(value = (String)FXModuleClassloader.this.loadClass("org.eclipse.swt.SWT").getDeclaredMethod("getPlatform", new Class[0]).invoke(null, new Object[0]))) {
                                if (FXClassloaderConfigurator.DEBUG) {
                                    System.err.println("FXModuleClassloader#findLocalClass - We are on GTK need to take a closer look");
                                }
                                b = (Boolean)FXModuleClassloader.this.loadClass("org.eclipse.swt.internal.gtk.OS").getDeclaredField("GTK3").get(null);
                            } else if (FXClassloaderConfigurator.DEBUG) {
                                System.err.println("FXModuleClassloader#findLocalClass - OS is '" + value + "' no need to get upset all is fine");
                            }
                        }
                        catch (Throwable e) {
                            System.err.println("FXModuleClassloader#findLocalClass - Failed to check for Gtk3");
                            e.printStackTrace();
                        }
                        if (b.booleanValue()) {
                            if (FXClassloaderConfigurator.DEBUG) {
                                System.err.println("FXModuleClassloader#findLocalClass - We are on GTK3 - too bad need to disable JavaFX for now else we'll crash the JVM");
                            }
                            throw new ClassNotFoundException("SWT is running with GTK3 but JavaFX is linked against GTK2");
                        }
                        try {
                            if (FXClassloaderConfigurator.DEBUG) {
                                System.err.println("FXModuleClassloader#findLocalClass - We need to disable implicit exiting when running in embedded mode");
                            }
                            FXModuleClassloader.this.loadClass("javafx.application.Platform").getDeclaredMethod("setImplicitExit", Boolean.TYPE).invoke(null, Boolean.FALSE);
                        }
                        catch (Throwable e) {
                            System.err.println("FXModuleClassloader#findLocalClass - Unable to setImplicitExit to false");
                            e.printStackTrace();
                        }
                    }
                    return fxClassloader.loadClass(classname);
                }

                public URL findLocalResource(String resource) {
                    return fxClassloader.getResource(resource);
                }

                public Enumeration<URL> findLocalResources(String resource) {
                    try {
                        return fxClassloader.getResources(resource);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return EmptyEnumeration.INSTANCE;
                    }
                }
            };
        }

        protected BundleInfo.Generation getGeneration() {
            return this.generation;
        }

        protected Debug getDebug() {
            return this.configuration.getDebug();
        }

        public ClasspathManager getClasspathManager() {
            return this.classpathManager;
        }

        protected EquinoxConfiguration getConfiguration() {
            return this.configuration;
        }

        public BundleLoader getBundleLoader() {
            return this.delegate;
        }

        public boolean isRegisteredAsParallel() {
            return false;
        }
    }

    static class SWTFXClassloader
    extends ClassLoader {
        private final ClassLoader lastResortLoader;
        private final ClassLoader primaryLoader;

        public SWTFXClassloader(ClassLoader lastResortLoader, ClassLoader primaryLoader) {
            this.lastResortLoader = lastResortLoader;
            this.primaryLoader = primaryLoader;
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("FXClassLoader.SWTFXClassloader#init - Primary Loader " + primaryLoader);
                System.err.println("FXClassLoader.SWTFXClassloader#init - Lastresort Loader " + lastResortLoader);
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - Loading " + name + " with primary");
                }
                Class<?> loadClass = this.primaryLoader.loadClass(name);
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - Result " + name + " " + loadClass);
                }
                return loadClass;
            }
            catch (ClassNotFoundException c) {
                if (FXClassloaderConfigurator.DEBUG) {
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - ClassNotFoundException thrown");
                    System.err.println("FXClassLoader.SWTFXClassloader#findClass - Loading " + name + " with last resort");
                }
                try {
                    Class<?> loadClass = this.lastResortLoader.loadClass(name);
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader.SWTFXClassloader#findClass - Result " + name + " " + loadClass);
                    }
                    return loadClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (FXClassloaderConfigurator.DEBUG) {
                        System.err.println("FXClassLoader.SWTFXClassloader#findClass - Even last resort was unable to load " + name);
                    }
                    throw c;
                }
            }
        }

        @Override
        protected URL findResource(String name) {
            URL url = this.primaryLoader.getResource(name);
            if (url == null) {
                url = this.lastResortLoader.getResource(name);
            }
            return url;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            final Enumeration<URL> en1 = this.primaryLoader.getResources(name);
            final Enumeration<URL> en2 = this.lastResortLoader.getResources(name);
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    if (en1.hasMoreElements()) {
                        return true;
                    }
                    return en2.hasMoreElements();
                }

                @Override
                public URL nextElement() {
                    if (!en1.hasMoreElements()) {
                        return (URL)en2.nextElement();
                    }
                    return (URL)en1.nextElement();
                }
            };
        }

        @Override
        public URL getResource(String name) {
            URL url = this.primaryLoader.getResource(name);
            if (url == null) {
                url = this.lastResortLoader.getResource(name);
            }
            return url;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream in = this.primaryLoader.getResourceAsStream(name);
            if (in == null) {
                in = this.lastResortLoader.getResourceAsStream(name);
            }
            return in;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final Enumeration<URL> en1 = this.primaryLoader.getResources(name);
            final Enumeration<URL> en2 = this.lastResortLoader.getResources(name);
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    if (en1.hasMoreElements()) {
                        return true;
                    }
                    return en2.hasMoreElements();
                }

                @Override
                public URL nextElement() {
                    if (!en1.hasMoreElements()) {
                        return (URL)en2.nextElement();
                    }
                    return (URL)en1.nextElement();
                }
            };
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.primaryLoader.loadClass(name);
            }
            catch (ClassNotFoundException c) {
                try {
                    return this.lastResortLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw c;
                }
            }
        }
    }
}

