/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.fx.ui.keybindings.KeySequence;
import org.eclipse.fx.ui.keybindings.TriggerSequence;
import org.eclipse.fx.ui.keybindings.e4.EBindingService;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuItem;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;

public abstract class BaseMenuItemRenderer<N>
extends BaseItemRenderer<MMenuItem, WMenuItem<N>> {
    @Inject
    UISynchronize sync;

    @Override
    protected void initWidget(final MMenuItem element, WMenuItem<N> widget) {
        super.initWidget(element, widget);
        widget.setOnActionCallback(new Runnable(){

            @Override
            public void run() {
                BaseMenuItemRenderer.this.executeAction(element, BaseMenuItemRenderer.this.getModelContext((MUIElement)element));
            }
        });
        if (element instanceof MHandledMenuItem) {
            Collection sequences;
            IEclipseContext lclContext = this.getModelContext((MUIElement)element);
            if (lclContext == null) {
                this.getLogger().error("The model context should not be null at this point");
                return;
            }
            EBindingService service = (EBindingService)lclContext.get(EBindingService.class);
            ParameterizedCommand command = this.generateParameterizedCommand((MHandledItem)((MHandledMenuItem)element), lclContext);
            if (command != null && !(sequences = service.getSequencesFor(command)).isEmpty()) {
                for (TriggerSequence s : sequences) {
                    if (!(s instanceof KeySequence)) continue;
                    widget.setAccelerator((KeySequence)s);
                    break;
                }
            }
        }
    }

    @Override
    protected void initRenderingContext(MMenuItem element, IEclipseContext context) {
        super.initRenderingContext(element, context);
        context.set(MenuPackageImpl.Literals.ITEM__TYPE.getName(), (Object)element.getType());
    }

    @Override
    public void doProcessContent(MMenuItem element) {
    }

    public void childRendered(MMenuItem parentElement, MUIElement element) {
    }

    public void hideChild(MMenuItem container, MUIElement changedObj) {
    }

    @Override
    public void checkEnablement(final MMenuItem menuElement) {
        final WMenuItem widget = (WMenuItem)menuElement.getWidget();
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IEclipseContext context = BaseMenuItemRenderer.this.getModelContext((MUIElement)menuElement);
                    if (context != null && (widget.getWidgetState() == WWidget.WidgetState.CREATED || widget.getWidgetState() == WWidget.WidgetState.IN_SETUP)) {
                        widget.setHandled(BaseMenuItemRenderer.this.canExecute(menuElement, context));
                        if (menuElement.getTags().contains("hideOnDisable")) {
                            BaseMenuItemRenderer.this.eventBroker.send("org/eclipse/fx/MUIElement/UpdateVisibleWhenResult", (Object)menuElement);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }
}

