package org.eclipse.fx.formats.svg;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Line;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.formats.svg.fx.FXToSvgUtils;
import org.eclipse.fx.formats.svg.fx.PresentationAttributesUtil;
import org.eclipse.fx.formats.svg.svg.SvgClipPathElement;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgFactory;
import org.eclipse.fx.formats.svg.svg.SvgGElement;
import org.eclipse.fx.formats.svg.svg.SvgImageElement;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgSvgElement;
import org.eclipse.fx.formats.svg.svg.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class FXToSvg {
  private SvgSvgElement root;
  
  private SvgDefsElement defs;
  
  private Scene s;
  
  private Parent p;
  
  @Extension
  private PresentationAttributesUtil e = new PresentationAttributesUtil(new Supplier<SvgDefsElement>() {
    @Override
    public SvgDefsElement get() {
      return FXToSvg.this.getDefs();
    }
  });
  
  public FXToSvg(final Scene s) {
    this.s = s;
  }
  
  public FXToSvg(final Parent p) {
    this.p = p;
  }
  
  public SvgDefsElement getDefs() {
    boolean _equals = Objects.equal(this.defs, null);
    if (_equals) {
      SvgDefsElement _createSvgDefsElement = SvgFactory.eINSTANCE.createSvgDefsElement();
      this.defs = _createSvgDefsElement;
      EList<SvgElement> _children = this.root.getChildren();
      _children.add(0, this.defs);
    }
    return this.defs;
  }
  
  public SvgSvgElement getSvgRoot() {
    boolean _equals = Objects.equal(this.root, null);
    if (_equals) {
      SvgSvgElement _createSvgSvgElement = SvgFactory.eINSTANCE.createSvgSvgElement();
      this.root = _createSvgSvgElement;
      boolean _notEquals = (!Objects.equal(this.s, null));
      if (_notEquals) {
        double _width = this.s.getWidth();
        String _string = Double.valueOf(_width).toString();
        this.root.setWidth(_string);
        double _height = this.s.getHeight();
        String _string_1 = Double.valueOf(_height).toString();
        this.root.setHeight(_string_1);
        Paint _fill = this.s.getFill();
        boolean _notEquals_1 = (!Objects.equal(_fill, null));
        if (_notEquals_1) {
          Paint _fill_1 = this.s.getFill();
          this.e.applyFill(this.root, _fill_1);
        }
        EList<SvgElement> _children = this.root.getChildren();
        Parent _root = this.s.getRoot();
        SvgElement _transform = this.transform(_root);
        _children.add(_transform);
      } else {
        SvgSvgElement _createSvgSvgElement_1 = SvgFactory.eINSTANCE.createSvgSvgElement();
        this.root = _createSvgSvgElement_1;
        Bounds _layoutBounds = this.p.getLayoutBounds();
        double _width_1 = _layoutBounds.getWidth();
        String _string_2 = Double.valueOf(_width_1).toString();
        this.root.setWidth(_string_2);
        Bounds _layoutBounds_1 = this.p.getLayoutBounds();
        double _height_1 = _layoutBounds_1.getHeight();
        String _string_3 = Double.valueOf(_height_1).toString();
        this.root.setHeight(_string_3);
        SvgElement _transform_1 = this.transform(this.p);
        final SvgGElement rr = ((SvgGElement) _transform_1);
        rr.setTransform(null);
        EList<SvgElement> _children_1 = this.root.getChildren();
        _children_1.add(rr);
      }
    }
    return this.root;
  }
  
  protected SvgElement _transform(final Region r) {
    SvgGElement e = SvgFactory.eINSTANCE.createSvgGElement();
    boolean _isVisible = r.isVisible();
    Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
    e.setVisibility(_visibility);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("translate(");
    Bounds _boundsInParent = r.getBoundsInParent();
    double _minX = _boundsInParent.getMinX();
    _builder.append(_minX, "");
    _builder.append(",");
    Bounds _boundsInParent_1 = r.getBoundsInParent();
    double _minY = _boundsInParent_1.getMinY();
    _builder.append(_minY, "");
    _builder.append(")");
    e.setTransform(_builder.toString());
    Shape _shape = r.getShape();
    boolean _notEquals = (!Objects.equal(_shape, null));
    if (_notEquals) {
      final SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
      String _generateUUID = EcoreUtil.generateUUID();
      cp.setId(_generateUUID);
      EList<SvgElement> _children = cp.getChildren();
      Shape _shape_1 = r.getShape();
      SvgElement _transform = this.transform(_shape_1);
      _children.add(_transform);
      SvgDefsElement _defs = this.getDefs();
      EList<SvgElement> _children_1 = _defs.getChildren();
      _children_1.add(cp);
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("url(#");
      String _id = cp.getId();
      _builder_1.append(_id, "");
      _builder_1.append(")");
      e.setClip_path(_builder_1.toString());
      Background _background = r.getBackground();
      boolean _notEquals_1 = (!Objects.equal(_background, null));
      if (_notEquals_1) {
        EList<SvgElement> _children_2 = e.getChildren();
        Background _background_1 = r.getBackground();
        List<BackgroundFill> _fills = _background_1.getFills();
        final Function1<BackgroundFill, SvgElement> _function = new Function1<BackgroundFill, SvgElement>() {
          @Override
          public SvgElement apply(final BackgroundFill it) {
            return FXToSvg.this.e.createBackgroundFill(it, r);
          }
        };
        List<SvgElement> _map = ListExtensions.<BackgroundFill, SvgElement>map(_fills, _function);
        List<SvgElement> _list = IterableExtensions.<SvgElement>toList(_map);
        Iterables.<SvgElement>addAll(_children_2, _list);
      }
      Border _border = r.getBorder();
      boolean _notEquals_2 = (!Objects.equal(_border, null));
      if (_notEquals_2) {
        EList<SvgElement> _children_3 = e.getChildren();
        Border _border_1 = r.getBorder();
        List<SvgElement> _createBorder = this.e.createBorder(_border_1, r);
        Iterables.<SvgElement>addAll(_children_3, _createBorder);
      }
    } else {
      Background _background_2 = r.getBackground();
      boolean _notEquals_3 = (!Objects.equal(_background_2, null));
      if (_notEquals_3) {
        EList<SvgElement> _children_4 = e.getChildren();
        Background _background_3 = r.getBackground();
        List<BackgroundFill> _fills_1 = _background_3.getFills();
        final Function1<BackgroundFill, SvgElement> _function_1 = new Function1<BackgroundFill, SvgElement>() {
          @Override
          public SvgElement apply(final BackgroundFill it) {
            return FXToSvg.this.e.createBackgroundFill(it, r);
          }
        };
        List<SvgElement> _map_1 = ListExtensions.<BackgroundFill, SvgElement>map(_fills_1, _function_1);
        List<SvgElement> _list_1 = IterableExtensions.<SvgElement>toList(_map_1);
        Iterables.<SvgElement>addAll(_children_4, _list_1);
      }
      Border _border_2 = r.getBorder();
      boolean _notEquals_4 = (!Objects.equal(_border_2, null));
      if (_notEquals_4) {
        EList<SvgElement> _children_5 = e.getChildren();
        Border _border_3 = r.getBorder();
        List<SvgElement> _createBorder_1 = this.e.createBorder(_border_3, r);
        Iterables.<SvgElement>addAll(_children_5, _createBorder_1);
      }
    }
    EList<SvgElement> _children_6 = e.getChildren();
    ObservableList<Node> _childrenUnmodifiable = r.getChildrenUnmodifiable();
    final Function1<Node, Boolean> _function_2 = new Function1<Node, Boolean>() {
      @Override
      public Boolean apply(final Node it) {
        return Boolean.valueOf(it.isVisible());
      }
    };
    Iterable<Node> _filter = IterableExtensions.<Node>filter(_childrenUnmodifiable, _function_2);
    final Function1<Node, SvgElement> _function_3 = new Function1<Node, SvgElement>() {
      @Override
      public SvgElement apply(final Node it) {
        return FXToSvg.this.transform(it);
      }
    };
    Iterable<SvgElement> _map_2 = IterableExtensions.<Node, SvgElement>map(_filter, _function_3);
    List<SvgElement> _list_2 = IterableExtensions.<SvgElement>toList(_map_2);
    Iterables.<SvgElement>addAll(_children_6, _list_2);
    Node _clip = r.getClip();
    boolean _notEquals_5 = (!Objects.equal(_clip, null));
    if (_notEquals_5) {
      Node _clip_1 = r.getClip();
      String _plus = ("Region-Clip " + _clip_1);
      InputOutput.<String>println(_plus);
      final SvgClipPathElement cp_1 = SvgFactory.eINSTANCE.createSvgClipPathElement();
      String _generateUUID_1 = EcoreUtil.generateUUID();
      cp_1.setId(_generateUUID_1);
      EList<SvgElement> _children_7 = cp_1.getChildren();
      Node _clip_2 = r.getClip();
      SvgElement _transform_1 = this.transform(_clip_2);
      _children_7.add(_transform_1);
      SvgDefsElement _defs_1 = this.getDefs();
      EList<SvgElement> _children_8 = _defs_1.getChildren();
      _children_8.add(cp_1);
      StringConcatenation _builder_2 = new StringConcatenation();
      _builder_2.append("url(#");
      String _id_1 = cp_1.getId();
      _builder_2.append(_id_1, "");
      _builder_2.append(")");
      e.setClip_path(_builder_2.toString());
    }
    return e;
  }
  
  protected SvgElement _transform(final Group g) {
    SvgGElement e = SvgFactory.eINSTANCE.createSvgGElement();
    boolean _isVisible = g.isVisible();
    Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
    e.setVisibility(_visibility);
    EList<SvgElement> _children = e.getChildren();
    ObservableList<Node> _childrenUnmodifiable = g.getChildrenUnmodifiable();
    final Function1<Node, Boolean> _function = new Function1<Node, Boolean>() {
      @Override
      public Boolean apply(final Node it) {
        return Boolean.valueOf(it.isVisible());
      }
    };
    Iterable<Node> _filter = IterableExtensions.<Node>filter(_childrenUnmodifiable, _function);
    final Function1<Node, SvgElement> _function_1 = new Function1<Node, SvgElement>() {
      @Override
      public SvgElement apply(final Node it) {
        return FXToSvg.this.transform(it);
      }
    };
    Iterable<SvgElement> _map = IterableExtensions.<Node, SvgElement>map(_filter, _function_1);
    List<SvgElement> _list = IterableExtensions.<SvgElement>toList(_map);
    Iterables.<SvgElement>addAll(_children, _list);
    Node _clip = g.getClip();
    boolean _notEquals = (!Objects.equal(_clip, null));
    if (_notEquals) {
      Node _clip_1 = g.getClip();
      String _plus = ("Group-CLIP: " + _clip_1);
      InputOutput.<String>println(_plus);
      final SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
      String _generateUUID = EcoreUtil.generateUUID();
      cp.setId(_generateUUID);
      EList<SvgElement> _children_1 = cp.getChildren();
      Node _clip_2 = g.getClip();
      SvgElement _transform = this.transform(_clip_2);
      _children_1.add(_transform);
      SvgDefsElement _defs = this.getDefs();
      EList<SvgElement> _children_2 = _defs.getChildren();
      _children_2.add(cp);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("url(#");
      String _id = cp.getId();
      _builder.append(_id, "");
      _builder.append(")");
      e.setClip_path(_builder.toString());
    }
    return e;
  }
  
  protected SvgElement _transform(final ImageView v) {
    SvgImageElement e = SvgFactory.eINSTANCE.createSvgImageElement();
    boolean _isVisible = v.isVisible();
    Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
    e.setVisibility(_visibility);
    return e;
  }
  
  protected SvgElement _transform(final Arc a) {
    SvgPathElement e = FXToSvgUtils.createPath(a);
    boolean _isVisible = a.isVisible();
    Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
    e.setVisibility(_visibility);
    Paint _fill = a.getFill();
    this.e.applyFill(e, _fill);
    return e;
  }
  
  protected SvgElement _transform(final Circle c) {
    InputOutput.<String>print("Circle arc");
    return null;
  }
  
  protected SvgElement _transform(final Ellipse e) {
    InputOutput.<String>print("Ellipse arc");
    return null;
  }
  
  protected SvgElement _transform(final Line e) {
    InputOutput.<String>print("Line arc");
    return null;
  }
  
  protected SvgElement _transform(final Path p) {
    SvgPathElement e = FXToSvgUtils.createPath(p);
    boolean _isVisible = p.isVisible();
    Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
    e.setVisibility(_visibility);
    Paint _fill = p.getFill();
    this.e.applyFill(e, _fill);
    Node _clip = p.getClip();
    boolean _notEquals = (!Objects.equal(_clip, null));
    if (_notEquals) {
      Node _clip_1 = p.getClip();
      String _plus = ("PATH_CLIP:" + _clip_1);
      InputOutput.<String>println(_plus);
      final SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
      String _generateUUID = EcoreUtil.generateUUID();
      cp.setId(_generateUUID);
      EList<SvgElement> _children = cp.getChildren();
      Node _clip_2 = p.getClip();
      SvgElement _transform = this.transform(_clip_2);
      _children.add(_transform);
      SvgDefsElement _defs = this.getDefs();
      EList<SvgElement> _children_1 = _defs.getChildren();
      _children_1.add(cp);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("url(#");
      String _id = cp.getId();
      _builder.append(_id, "");
      _builder.append(")");
      e.setClip_path(_builder.toString());
    }
    return e;
  }
  
  protected SvgElement _transform(final Polygon e) {
    InputOutput.<String>print("Polygon arc");
    return null;
  }
  
  protected SvgElement _transform(final Polyline e) {
    InputOutput.<String>print("Polyline arc");
    return null;
  }
  
  protected SvgElement _transform(final QuadCurve e) {
    InputOutput.<String>print("QuadCurve arc");
    return null;
  }
  
  protected SvgElement _transform(final Rectangle e) {
    final SvgRectElement r = SvgFactory.eINSTANCE.createSvgRectElement();
    double _x = e.getX();
    String _string = Double.valueOf(_x).toString();
    r.setX(_string);
    double _y = e.getY();
    String _string_1 = Double.valueOf(_y).toString();
    r.setY(_string_1);
    double _width = e.getWidth();
    String _string_2 = Double.valueOf(_width).toString();
    r.setWidth(_string_2);
    double _height = e.getHeight();
    String _string_3 = Double.valueOf(_height).toString();
    r.setHeight(_string_3);
    boolean _isVisible = e.isVisible();
    Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
    r.setVisibility(_visibility);
    Paint _fill = e.getFill();
    this.e.applyFill(r, _fill);
    return r;
  }
  
  protected SvgElement _transform(final SVGPath e) {
    final SvgPathElement p = SvgFactory.eINSTANCE.createSvgPathElement();
    String _content = e.getContent();
    p.setD(_content);
    return p;
  }
  
  protected SvgElement _transform(final Text e) {
    final SvgPathElement p = FXToSvgUtils.createPath(e);
    boolean _isVisible = e.isVisible();
    Visibility _visibility = FXToSvgUtils.toVisibility(_isVisible);
    p.setVisibility(_visibility);
    Paint _fill = e.getFill();
    this.e.applyFill(p, _fill);
    SvgGElement g = SvgFactory.eINSTANCE.createSvgGElement();
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("translate(");
    Bounds _boundsInParent = e.getBoundsInParent();
    double _minX = _boundsInParent.getMinX();
    _builder.append(_minX, "");
    _builder.append(",");
    Bounds _boundsInParent_1 = e.getBoundsInParent();
    double _minY = _boundsInParent_1.getMinY();
    double _baselineOffset = e.getBaselineOffset();
    double _plus = (_minY + _baselineOffset);
    _builder.append(_plus, "");
    _builder.append(")");
    g.setTransform(_builder.toString());
    EList<SvgElement> _children = g.getChildren();
    _children.add(p);
    return g;
  }
  
  public SvgElement transform(final Node g) {
    if (g instanceof Group) {
      return _transform((Group)g);
    } else if (g instanceof Region) {
      return _transform((Region)g);
    } else if (g instanceof Arc) {
      return _transform((Arc)g);
    } else if (g instanceof Circle) {
      return _transform((Circle)g);
    } else if (g instanceof Ellipse) {
      return _transform((Ellipse)g);
    } else if (g instanceof Line) {
      return _transform((Line)g);
    } else if (g instanceof Path) {
      return _transform((Path)g);
    } else if (g instanceof Polygon) {
      return _transform((Polygon)g);
    } else if (g instanceof Polyline) {
      return _transform((Polyline)g);
    } else if (g instanceof QuadCurve) {
      return _transform((QuadCurve)g);
    } else if (g instanceof Rectangle) {
      return _transform((Rectangle)g);
    } else if (g instanceof SVGPath) {
      return _transform((SVGPath)g);
    } else if (g instanceof Text) {
      return _transform((Text)g);
    } else if (g instanceof ImageView) {
      return _transform((ImageView)g);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(g).toString());
    }
  }
}
