/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CssExtension;
import org.eclipse.fx.ide.css.cssext.ui.adapter.ICssResource;
import org.eclipse.fx.osgi.util.LoggerCreator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class CSSEditorPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Logger logger;
    private IObservableValue master = new WritableValue();

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerCreator.createLogger(CSSEditorPropertyPage.class);
        }
        return this.logger;
    }

    protected Control createContents(Composite parent) {
        DataBindingContext dbc = new DataBindingContext();
        this.getElementContainer();
        IFile elementFile = this.getElementFile();
        boolean useCustom = false;
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(1, true));
        final Button b = new Button(area, 32);
        b.setText("Use custom definition");
        IObservableValue useCustomObsModel = BeansObservables.observeDetailValue((IObservableValue)this.master, (String)"useCustom", Boolean.class);
        ISWTObservableValue useCustomObsUI = SWTObservables.observeSelection((Control)b);
        dbc.bindValue((IObservableValue)useCustomObsUI, useCustomObsModel);
        final Label l = new Label(area, 0);
        l.setEnabled(useCustom);
        ISWTObservableValue lEnabled = SWTObservables.observeEnabled((Control)l);
        dbc.bindValue((IObservableValue)lEnabled, useCustomObsModel);
        l.setText("Computed Extensions:");
        final TableViewer extensionViewer = new TableViewer(area, 67584);
        extensionViewer.getTable().setLayoutData((Object)new GridData(1808));
        TableViewerColumn colInherited = new TableViewerColumn(extensionViewer, 0);
        colInherited.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                URI uri = (URI)element;
                if (CSSEditorPropertyPage.this.isInherited(uri)) {
                    return "I";
                }
                return "";
            }
        });
        colInherited.getColumn().setWidth(30);
        colInherited.getColumn().setText("Inherited");
        TableViewerColumn colDisabled = new TableViewerColumn(extensionViewer, 0);
        colDisabled.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                URI uri = (URI)element;
                if (CSSEditorPropertyPage.this.isDisabledInherited(uri)) {
                    return "DI";
                }
                if (CSSEditorPropertyPage.this.isDisabledLocal(uri)) {
                    return "D";
                }
                return "";
            }
        });
        colDisabled.getColumn().setWidth(30);
        colDisabled.getColumn().setText("Disabled");
        TableViewerColumn colName = new TableViewerColumn(extensionViewer, 0);
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                URI uri = (URI)element;
                return CSSEditorPropertyPage.this.lookupRootPackage(uri);
            }
        });
        colName.getColumn().setWidth(200);
        colName.getColumn().setText("Name");
        TableViewerColumn colURI = new TableViewerColumn(extensionViewer, 0);
        colURI.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                URI uri = (URI)element;
                return uri.toString();
            }
        });
        colURI.getColumn().setWidth(200);
        colURI.getColumn().setText("URI");
        extensionViewer.getTable().setHeaderVisible(true);
        extensionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ISWTObservableValue vClasspathEnabled = SWTObservables.observeEnabled((Control)extensionViewer.getControl());
        dbc.bindValue((IObservableValue)vClasspathEnabled, useCustomObsModel);
        Label l2 = new Label(area, 0);
        l2.setEnabled(useCustom);
        ISWTObservableValue l2Enabled = SWTObservables.observeEnabled((Control)l2);
        dbc.bindValue((IObservableValue)l2Enabled, useCustomObsModel);
        l2.setText("User Extensions:");
        final TableViewer vUser = new TableViewer(area, 67616);
        vUser.getTable().setLayoutData((Object)new GridData(1808));
        vUser.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                URI uri = (URI)element;
                return uri.toString();
            }
        });
        vUser.setContentProvider((IContentProvider)new ArrayContentProvider());
        ISWTObservableValue vUserEnabled = SWTObservables.observeEnabled((Control)vUser.getControl());
        dbc.bindValue((IObservableValue)vUserEnabled, useCustomObsModel);
        Action disable = new Action("disable"){

            public void run() {
                URI uri;
                IStructuredSelection ss = (IStructuredSelection)extensionViewer.getSelection();
                if (!ss.isEmpty() && !CSSEditorPropertyPage.this.isDisabledLocal(uri = (URI)ss.getFirstElement())) {
                    CSSEditorPropertyPage.this.getMasterValue().addDisabledExtension(uri);
                    extensionViewer.refresh();
                }
            }
        };
        Action enable = new Action("enable"){

            public void run() {
                URI uri;
                IStructuredSelection ss = (IStructuredSelection)extensionViewer.getSelection();
                if (!ss.isEmpty() && CSSEditorPropertyPage.this.isDisabledLocal(uri = (URI)ss.getFirstElement())) {
                    CSSEditorPropertyPage.this.getMasterValue().removeDisabledExtension(uri);
                    extensionViewer.refresh();
                }
            }
        };
        MenuManager mm = new MenuManager();
        Menu m = mm.createContextMenu((Control)extensionViewer.getTable());
        mm.addMenuListener(new IMenuListener((IAction)enable, (IAction)disable){
            private final /* synthetic */ IAction val$enable;
            private final /* synthetic */ IAction val$disable;
            {
                this.val$enable = iAction;
                this.val$disable = iAction2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection ss = (IStructuredSelection)extensionViewer.getSelection();
                if (!ss.isEmpty()) {
                    URI e = (URI)ss.getFirstElement();
                    if (CSSEditorPropertyPage.this.isDisabledLocal(e)) {
                        manager.add(this.val$enable);
                    } else if (!CSSEditorPropertyPage.this.isDisabledInherited(e)) {
                        manager.add(this.val$disable);
                    }
                }
            }
        });
        mm.setRemoveAllWhenShown(true);
        extensionViewer.getTable().setMenu(m);
        this.master.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ICssResource r;
                if (event.diff.getNewValue() != null) {
                    event.diff.getNewValue().toString();
                }
                if ((r = (ICssResource)event.diff.getNewValue()) != null) {
                    ArrayList<URI> input = new ArrayList<URI>();
                    List<URI> inheritedClasspathExtensions = r.getInheritedClasspathExtensions();
                    CSSEditorPropertyPage.this.getLogger().debug("adding inherited classpath extensions: " + inheritedClasspathExtensions.size() + " / " + inheritedClasspathExtensions);
                    input.addAll(inheritedClasspathExtensions);
                    CSSEditorPropertyPage.this.getLogger().debug("result -> " + input.size() + " / " + input);
                    List<URI> classpathExtensions = r.getClasspathExtensions();
                    CSSEditorPropertyPage.this.getLogger().debug("adding classpath extensions: " + classpathExtensions.size() + " / " + classpathExtensions);
                    input.addAll(classpathExtensions);
                    CSSEditorPropertyPage.this.getLogger().debug("result -> " + input.size() + " / " + input);
                    List<URI> inheritedCustomExtensions = r.getInheritedCustomExtensions();
                    CSSEditorPropertyPage.this.getLogger().debug("adding inherited custom extensions: " + inheritedCustomExtensions.size() + " / " + inheritedCustomExtensions);
                    input.addAll(inheritedCustomExtensions);
                    CSSEditorPropertyPage.this.getLogger().debug("result -> " + input.size() + " / " + input);
                    List<URI> customExtensions = r.getCustomExtensions();
                    CSSEditorPropertyPage.this.getLogger().debug("adding custom extensions: " + customExtensions.size() + " / " + customExtensions);
                    input.addAll(customExtensions);
                    CSSEditorPropertyPage.this.getLogger().debug("result -> " + input.size() + " / " + input);
                    CSSEditorPropertyPage.this.getLogger().debug("SETTING INPUT TO " + input);
                    extensionViewer.setInput(input);
                } else {
                    extensionViewer.setInput(null);
                    vUser.setInput(null);
                }
            }
        });
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useCustom = b.getSelection();
                l.setEnabled(useCustom);
                vUser.getTable().setEnabled(useCustom);
            }
        });
        this.master.setValue((Object)this.getCssResource());
        return area;
    }

    protected boolean isInherited(URI uri) {
        return this.getMasterValue().getInheritedClasspathExtensions().contains(uri) || this.getMasterValue().getCustomExtensions().contains(uri);
    }

    protected boolean isDisabledInherited(URI uri) {
        return this.getMasterValue().getInheritedDisabledExtensions().contains(uri);
    }

    protected boolean isDisabledLocal(URI uri) {
        return this.getMasterValue().getDisabledExtensions().contains(uri);
    }

    protected String lookupRootPackage(URI uri) {
        CssExtension extension = this.getMasterValue().getExtension(uri);
        if (extension != null) {
            return extension.getPackageDef().getName();
        }
        return "read error";
    }

    protected void performApply() {
        try {
            ((ICssResource)this.master.getValue()).save();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void performDefaults() {
        this.getMasterValue().clearCustomExtensions();
        this.getMasterValue().clearDisabledExtensions();
    }

    protected ICssResource getMasterValue() {
        return (ICssResource)this.master.getValue();
    }

    private IContainer getElementContainer() {
        return (IContainer)Platform.getAdapterManager().getAdapter((Object)this.getElement(), IContainer.class);
    }

    private IFile getElementFile() {
        return (IFile)Platform.getAdapterManager().getAdapter((Object)this.getElement(), IFile.class);
    }

    private IResource getElementAsResource() {
        if (this.getElement() instanceof IResource) {
            return (IResource)this.getElement();
        }
        return (IResource)Platform.getAdapterManager().getAdapter((Object)this.getElement(), IResource.class);
    }

    private ICssResource getCssResource() {
        return (ICssResource)Platform.getAdapterManager().getAdapter((Object)this.getElementAsResource(), ICssResource.class);
    }
}

