/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.animation.pagetransition;

import javafx.animation.Animation;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import org.eclipse.jdt.annotation.NonNull;

public abstract class CenterSwitchAnimation {
    public ImageView imageView = null;

    public void animate(final BorderPane pane, final Node newNode, final Runnable animationFinished) {
        final Node curNode = pane.getCenter();
        pane.setCenter(null);
        Bounds b = curNode.getBoundsInParent();
        newNode.resizeRelocate(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
        pane.getChildren().add(0, (Object)newNode);
        pane.getChildren().add(1, (Object)curNode);
        if (this.imageView != null) {
            pane.getChildren().add(0, (Object)this.imageView);
        }
        Animation animation = this.createAndPrepareAnimation(curNode, newNode);
        animation.onFinishedProperty().set((Object)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                pane.getChildren().remove((Object)curNode);
                pane.getChildren().remove((Object)newNode);
                pane.setCenter(newNode);
                CenterSwitchAnimation.this.resetProperties(curNode, newNode);
                if (CenterSwitchAnimation.this.imageView != null) {
                    pane.getChildren().remove((Object)CenterSwitchAnimation.this.imageView);
                }
                if (animationFinished != null) {
                    animationFinished.run();
                }
            }
        });
        animation.play();
    }

    protected abstract @NonNull Animation createAndPrepareAnimation(@NonNull Node var1, @NonNull Node var2);

    protected abstract void resetProperties(@NonNull Node var1, @NonNull Node var2);
}

