/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls;

import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.eclipse.fx.ui.controls.styledtext.StyledString;
import org.eclipse.fx.ui.controls.styledtext.StyledStringSegment;

public class Util {
    public static String dumpSceneGraph(Node n) {
        return new SceneGraphDumper().dump(n).toString();
    }

    public static Node toNode(StyledString s) {
        ArrayList<Text> segList = new ArrayList<Text>();
        for (StyledStringSegment seg : s.getSegmentList()) {
            Text t = new Text(seg.getText());
            t.getStyleClass().addAll(seg.getStyleClass());
            segList.add(t);
        }
        return new TextFlow(segList.toArray(new Node[0]));
    }

    static class SceneGraphDumper {
        private StringBuilder sb = new StringBuilder();
        private int ident = 0;

        SceneGraphDumper() {
        }

        public StringBuilder dump(Node n) {
            int i = 0;
            while (i < this.ident) {
                this.sb.append("    ");
                ++i;
            }
            ++this.ident;
            this.sb.append("<" + n.getClass().getName() + " styleClass=\"" + n.getStyleClass() + "\">\n");
            if (n instanceof Parent) {
                for (Node subNode : ((Parent)n).getChildrenUnmodifiable()) {
                    this.dump(subNode);
                }
            }
            --this.ident;
            i = 0;
            while (i < this.ident) {
                this.sb.append("    ");
                ++i;
            }
            this.sb.append("</" + n.getClass().getName() + ">\n");
            return this.sb;
        }
    }
}

