/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.stage;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import org.eclipse.fx.ui.controls.stage.ResizeableFramePane;
import org.eclipse.jdt.annotation.Nullable;

public class DefaultFramePane
extends ResizeableFramePane {
    private static final PseudoClass ACTIVE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"active");
    private ObjectProperty<@Nullable Node> contentProperty;
    private StringProperty titleProperty;
    private TitleAreaNode dialogAreaNode;
    private ObjectProperty<Node> clientArea = new SimpleObjectProperty((Object)this, "clientArea", null);
    private BorderPane trimPane;

    public DefaultFramePane() {
        this(null);
    }

    public DefaultFramePane(boolean lightweight) {
        this(null, lightweight);
    }

    public DefaultFramePane(@Nullable Pane contentContainer) {
        this(contentContainer, false);
    }

    public DefaultFramePane(@Nullable Pane contentContainer, boolean lightweight) {
        super(lightweight);
        if (lightweight) {
            this.setMinimizable(false);
            this.setMaximizable(false);
        }
        this.clientAreaProperty().addListener(this::updateClientArea);
        if (contentContainer != null) {
            contentContainer.setId("client-area");
            this.setContent((Node)contentContainer);
        }
    }

    @Override
    protected Node createWindowArea() {
        BorderPane root = new BorderPane();
        this.getStyleClass().addAll((Object[])new String[]{"default-window", "decorated-root"});
        Object dialogTitleBar = this.createTitleBar();
        this.dialogAreaNode = (TitleAreaNode)dialogTitleBar;
        this.registerTitleBar((Node)dialogTitleBar);
        this.titleProperty = ((TitleAreaNode)dialogTitleBar).titleProperty();
        root.setTop(dialogTitleBar);
        dialogTitleBar.applyCss();
        this.sceneProperty().addListener(o -> {
            Scene s = this.getScene();
            if (s != null) {
                if (s.getWindow() != null) {
                    this.handleStageAttached();
                } else {
                    s.windowProperty().addListener(o2 -> {
                        if (s.getWindow() != null) {
                            this.handleStageAttached();
                        }
                    });
                }
            }
        });
        this.trimPane = new BorderPane();
        root.setCenter((Node)this.trimPane);
        this.contentProperty = this.trimPane.centerProperty();
        return root;
    }

    private void handleStageAttached() {
        if (!this.isLightweight()) {
            this.handleFocus(this.getStage().focusedProperty());
            if (this.getStage().getModality() == Modality.WINDOW_MODAL) {
                this.dialogAreaNode.getMinButton().setVisible(false);
            }
        }
    }

    protected <N extends Node> N createTitleBar() {
        return (N)new TitleAreaNodeImpl();
    }

    protected void requestCancelClose() {
        this.close();
    }

    private void handleFocus(ReadOnlyBooleanProperty readOnlyBooleanProperty) {
        readOnlyBooleanProperty.addListener(o -> this.pseudoClassStateChanged(ACTIVE_PSEUDO_CLASS, readOnlyBooleanProperty.get()));
    }

    @Override
    protected StringProperty impl_titleProperty() {
        return this.titleProperty;
    }

    @Override
    protected ObjectProperty<Node> impl_clientAreaProperty() {
        return this.clientArea;
    }

    protected void updateClientArea(ObservableValue<? extends Node> o, Node oldClientArea, Node newClientArea) {
        if (oldClientArea != null) {
            ((Pane)this.lookup("#client-area")).getChildren().remove((Object)oldClientArea);
        }
        if (newClientArea != null) {
            ((Pane)this.lookup("#client-area")).getChildren().add((Object)newClientArea);
        }
    }

    @Override
    public ObjectProperty<Node> impl_contentProperty() {
        return this.contentProperty;
    }

    public String getUserAgentStylesheet() {
        return DefaultFramePane.class.getResource("window.css").toExternalForm();
    }

    public static interface TitleAreaNode {
        public StringProperty titleProperty();

        public Node getMinButton();
    }

    class TitleAreaNodeImpl
    extends ToolBar
    implements TitleAreaNode {
        private static final int HEADER_HEIGHT = 28;
        private Label titleLabel;
        private WindowButton minButton;

        public TitleAreaNodeImpl() {
            this.getStyleClass().add((Object)"window-header");
            this.setPrefHeight(28.0);
            this.setMinHeight(28.0);
            this.setMaxHeight(28.0);
            this.titleLabel = new Label();
            this.titleLabel.setMaxHeight(Double.MAX_VALUE);
            this.titleLabel.setId("window-label-title");
            this.titleLabel.getStyleClass().add((Object)"window-title");
            Region spacer = new Region();
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            WindowButton closeButton = new WindowButton("close");
            closeButton.setFocusTraversable(false);
            closeButton.setOnAction(e -> DefaultFramePane.this.requestCancelClose());
            this.minButton = new WindowButton("minimize");
            this.minButton.setFocusTraversable(false);
            this.minButton.setOnAction(e -> DefaultFramePane.this.minimize());
            this.minButton.visibleProperty().bind((ObservableValue)DefaultFramePane.this.minimizableProperty());
            WindowButton maxButton = new WindowButton("maximize");
            maxButton.setFocusTraversable(false);
            maxButton.setOnAction(e -> DefaultFramePane.this.maximize());
            maxButton.visibleProperty().bind((ObservableValue)DefaultFramePane.this.maximizableProperty());
            HBox windowBtns = new HBox(3.0);
            windowBtns.getStyleClass().add((Object)"window-buttons");
            windowBtns.getChildren().addAll((Object[])new Node[]{this.minButton, maxButton, closeButton});
            this.getItems().addAll((Object[])new Node[]{this.titleLabel, spacer, windowBtns});
        }

        @Override
        public StringProperty titleProperty() {
            return this.titleLabel.textProperty();
        }

        @Override
        public Node getMinButton() {
            return this.minButton;
        }
    }

    private static class WindowButton
    extends Button {
        WindowButton(String name) {
            this.getStyleClass().setAll((Object[])new String[]{"window-button"});
            this.getStyleClass().add((Object)("window-" + name + "-button"));
            StackPane graphic = new StackPane();
            graphic.getStyleClass().setAll((Object[])new String[]{"graphic"});
            this.setGraphic((Node)graphic);
            this.setMinSize(17.0, 17.0);
            this.setPrefSize(17.0, 17.0);
        }
    }
}

