/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.behavior;

import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.events.TextHoverEvent;

public class HoverSupport {
    private Region control;
    private TextHoverEvent lastHover;

    public HoverSupport(Region control) {
        this.control = control;
    }

    protected void install() {
        this.control.addEventHandler(MouseEvent.MOUSE_PRESSED, this::onMousePressed);
        this.control.addEventHandler(MouseEvent.MOUSE_MOVED, this::onMouseMoved);
        this.control.addEventHandler(MouseEvent.MOUSE_EXITED, this::onMouseExited);
        Util.installHoverCallback((Node)this.control, Duration.millis((double)1000.0), this::handleHover);
    }

    public static HoverSupport install(Region control) {
        HoverSupport support = new HoverSupport(control);
        support.install();
        return support;
    }

    private void onMouseExited(MouseEvent event) {
        if (this.lastHover != null) {
            Event.fireEvent((EventTarget)this.control, (Event)new TextHoverEvent(event, -1, -1, -1, ""));
            this.lastHover = null;
        }
    }

    private void onMouseMoved(MouseEvent event) {
        if (this.lastHover != null) {
            TextHoverEvent hoverEvent = HoverSupport.createHoverEvent(event);
            if (this.lastHover.getOffsetTokenStart() != hoverEvent.getOffsetTokenStart()) {
                Event.fireEvent((EventTarget)this.control, (Event)new TextHoverEvent(event, -1, -1, -1, ""));
                this.lastHover = null;
            }
        }
    }

    private void onMousePressed(MouseEvent event) {
        if (this.lastHover != null) {
            Event.fireEvent((EventTarget)this.control, (Event)new TextHoverEvent(event, -1, -1, -1, ""));
            this.lastHover = null;
        }
    }

    protected static TextHoverEvent createHoverEvent(MouseEvent e) {
        return new TextHoverEvent(e, -1, -1, -1, "");
    }

    protected void handleHover(MouseEvent e) {
        TextHoverEvent event = HoverSupport.createHoverEvent(e);
        if (this.lastHover == null || this.lastHover.getOffsetTokenStart() != event.getOffsetTokenStart()) {
            Event.fireEvent((EventTarget)this.control, (Event)event);
            this.lastHover = event.getOffset() == -1 ? null : event;
        }
    }
}

