/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.l10n.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.l10n.nLSDsl.Message;
import org.eclipse.fx.ide.l10n.nLSDsl.MessageEntry;
import org.eclipse.fx.ide.l10n.nLSDsl.MessageParam;
import org.eclipse.fx.ide.l10n.nLSDsl.NLS;
import org.eclipse.fx.ide.l10n.nLSDsl.NLSBundle;
import org.eclipse.fx.ide.l10n.nLSDsl.NLSFormatter;
import org.eclipse.fx.ide.l10n.nLSDsl.PredefinedTypes;
import org.eclipse.fx.ide.l10n.nLSDsl.RichString;
import org.eclipse.fx.ide.l10n.nLSDsl.RichStringLiteral;
import org.eclipse.fx.ide.l10n.nLSDsl.RichStringLiteralEnd;
import org.eclipse.fx.ide.l10n.nLSDsl.RichStringLiteralInbetween;
import org.eclipse.fx.ide.l10n.nLSDsl.RichStringLiteralStart;
import org.eclipse.fx.ide.l10n.nLSDsl.RichVarPart;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class NLSDslGenerator
implements IGenerator {
    public void doGenerate(Resource resource, final IFileSystemAccess fsa) {
        EObject _head = (EObject)IterableExtensions.head((Iterable)resource.getContents());
        final NLS root = (NLS)_head;
        Consumer<NLSBundle> _function = new Consumer<NLSBundle>(){

            @Override
            public void accept(NLSBundle b) {
                NLSDslGenerator.this.handleBundle(root, b, fsa);
            }
        };
        root.getBundleList().forEach((Consumer)_function);
    }

    public void handleBundle(final NLS root, final NLSBundle b, final IFileSystemAccess fsa) {
        String _replace = root.getPackage().getName().replace(".", "/");
        String _plus = String.valueOf(_replace) + "/";
        String _name = b.getName();
        String _plus_1 = String.valueOf(_plus) + _name;
        String _plus_2 = String.valueOf(_plus_1) + ".properties";
        fsa.generateFile(_plus_2, this.genPropertyFile(b, b.getLang()));
        String _replace_1 = root.getPackage().getName().replace(".", "/");
        String _plus_3 = String.valueOf(_replace_1) + "/";
        String _name_1 = b.getName();
        String _plus_4 = String.valueOf(_plus_3) + _name_1;
        String _plus_5 = String.valueOf(_plus_4) + ".java";
        fsa.generateFile(_plus_5, this.genClass(b, root));
        String _replace_2 = root.getPackage().getName().replace(".", "/");
        String _plus_6 = String.valueOf(_replace_2) + "/";
        String _name_2 = b.getName();
        String _plus_7 = String.valueOf(_plus_6) + _name_2;
        String _plus_8 = String.valueOf(_plus_7) + "Registry.java";
        fsa.generateFile(_plus_8, this.genRegistryClass(b, root));
        HashSet set = new HashSet();
        Functions.Function2<HashSet<String>, MessageEntry, HashSet<String>> _function = new Functions.Function2<HashSet<String>, MessageEntry, HashSet<String>>(){

            public HashSet<String> apply(HashSet<String> r, MessageEntry s) {
                Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

                    public Boolean apply(Message m) {
                        String _name = m.getName();
                        return !Objects.equal((Object)_name, null);
                    }
                };
                Functions.Function1<Message, String> _function_1 = new Functions.Function1<Message, String>(){

                    public String apply(Message m) {
                        return m.getName();
                    }
                };
                Iterables.addAll(r, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(s.getMessageList(), (Functions.Function1)_function), (Functions.Function1)_function_1));
                return r;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String lang) {
                String _replace = root.getPackage().getName().replace(".", "/");
                String _plus = String.valueOf(_replace) + "/";
                String _name = b.getName();
                String _plus_1 = String.valueOf(_plus) + _name;
                String _plus_2 = String.valueOf(_plus_1) + "_";
                String _plus_3 = String.valueOf(_plus_2) + lang;
                String _plus_4 = String.valueOf(_plus_3) + ".properties";
                fsa.generateFile(_plus_4, NLSDslGenerator.this.genPropertyFile(b, lang));
            }
        };
        ((HashSet)IterableExtensions.fold(b.getMessageEntryList(), set, (Functions.Function2)_function)).forEach(_function_1);
    }

    public CharSequence genClass(NLSBundle nls, NLS root) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = root.getPackage().getName();
        _builder.append(_name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify - Auto generated from ");
        String _lastSegment = root.eResource().getURI().lastSegment();
        _builder.append(_lastSegment, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class ");
        String _name_1 = nls.getName();
        _builder.append(_name_1);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        Functions.Function1<MessageEntry, Boolean> _function = new Functions.Function1<MessageEntry, Boolean>(){

            public Boolean apply(MessageEntry m) {
                MessageEntry _entryRef = m.getEntryRef();
                return Objects.equal((Object)_entryRef, null);
            }
        };
        Iterable _filter = IterableExtensions.filter(nls.getMessageEntryList(), (Functions.Function1)_function);
        for (MessageEntry me : _filter) {
            _builder.append("\t");
            _builder.append("public String ");
            String _name_2 = me.getName();
            _builder.append(_name_2, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence genRegistryClass(NLSBundle nls, NLS root) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = root.getPackage().getName();
        _builder.append(_name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify - Auto generated from ");
        String _lastSegment = root.eResource().getURI().lastSegment();
        _builder.append(_lastSegment, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@org.eclipse.e4.core.di.annotations.Creatable");
        _builder.newLine();
        _builder.append("public class ");
        String _name_1 = nls.getName();
        _builder.append(_name_1);
        _builder.append("Registry extends org.eclipse.fx.core.text.AbstractTextRegistry<");
        String _name_2 = nls.getName();
        _builder.append(_name_2);
        _builder.append("> {");
        _builder.newLineIfNotEmpty();
        Functions.Function1<RichVarPart, Boolean> _function = new Functions.Function1<RichVarPart, Boolean>(){

            public Boolean apply(RichVarPart p) {
                String _findFormatter = NLSDslGenerator.this.findFormatter(p);
                return Objects.equal((Object)_findFormatter, (Object)"-number");
            }
        };
        RichVarPart _findFirst = (RichVarPart)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)nls.eAllContents(), RichVarPart.class), (Functions.Function1)_function);
        boolean bl = _notEquals = !Objects.equal((Object)_findFirst, null);
        if (_notEquals) {
            _builder.append("\t");
            _builder.append("@javax.inject.Inject");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("private org.eclipse.fx.core.text.NumberFormatter _number;");
            _builder.newLine();
        }
        _builder.newLine();
        Functions.Function1<RichVarPart, Boolean> _function_1 = new Functions.Function1<RichVarPart, Boolean>(){

            public Boolean apply(RichVarPart p) {
                String _findFormatter = NLSDslGenerator.this.findFormatter(p);
                return Objects.equal((Object)_findFormatter, (Object)"-date");
            }
        };
        RichVarPart _findFirst_1 = (RichVarPart)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)nls.eAllContents(), RichVarPart.class), (Functions.Function1)_function_1);
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_findFirst_1, null);
        if (_notEquals_1) {
            _builder.append("\t");
            _builder.append("@javax.inject.Inject");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("private org.eclipse.fx.core.text.DateFormatter _date;");
            _builder.newLine();
        }
        _builder.newLine();
        Functions.Function1<RichVarPart, Boolean> _function_2 = new Functions.Function1<RichVarPart, Boolean>(){

            public Boolean apply(RichVarPart p) {
                String _findFormatter = NLSDslGenerator.this.findFormatter(p);
                return Objects.equal((Object)_findFormatter, (Object)"-temporal");
            }
        };
        RichVarPart _findFirst_2 = (RichVarPart)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)nls.eAllContents(), RichVarPart.class), (Functions.Function1)_function_2);
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_findFirst_2, null);
        if (_notEquals_2) {
            _builder.append("\t");
            _builder.append("@javax.inject.Inject");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("private org.eclipse.fx.core.text.TemporalAccessorFormatter _temporal;");
            _builder.newLine();
        }
        _builder.newLine();
        EList<NLSFormatter> _formatterList = nls.getFormatterList();
        for (NLSFormatter f : _formatterList) {
            _builder.append("\t");
            _builder.append("@javax.inject.Inject");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("private ");
            String _classRef = f.getClassRef();
            _builder.append(_classRef, "\t");
            _builder.append(" cust_");
            String _name_3 = f.getName();
            _builder.append(_name_3, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1<MessageEntry, Boolean> _function_3 = new Functions.Function1<MessageEntry, Boolean>(){

            public Boolean apply(MessageEntry m) {
                MessageEntry _entryRef = m.getEntryRef();
                return !Objects.equal((Object)_entryRef, null);
            }
        };
        Iterable _filter = IterableExtensions.filter(nls.getMessageEntryList(), (Functions.Function1)_function_3);
        HashSet _hashSet = new HashSet();
        Functions.Function2<HashSet<NLSBundle>, MessageEntry, HashSet<NLSBundle>> _function_4 = new Functions.Function2<HashSet<NLSBundle>, MessageEntry, HashSet<NLSBundle>>(){

            public HashSet<NLSBundle> apply(HashSet<NLSBundle> s, MessageEntry e) {
                s.add(NLSDslGenerator.this.findNLSBundle(e.getEntryRef()));
                return s;
            }
        };
        HashSet elements = (HashSet)IterableExtensions.fold((Iterable)_filter, _hashSet, (Functions.Function2)_function_4);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        boolean dummy = elements.addAll(nls.getIncludedBundleList());
        _builder.newLineIfNotEmpty();
        for (NLSBundle b : elements) {
            _builder.append("\t");
            _builder.append("@javax.inject.Inject");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("private ");
            EObject _eContainer = b.eContainer();
            String _name_4 = ((NLS)_eContainer).getPackage().getName();
            _builder.append(_name_4, "\t");
            _builder.append(".");
            String _name_5 = b.getName();
            _builder.append(_name_5, "\t");
            _builder.append("Registry bundle_");
            String _name_6 = b.getName();
            _builder.append(_name_6, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@javax.inject.Inject");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void updateMessages(@org.eclipse.e4.core.services.nls.Translation ");
        String _name_7 = nls.getName();
        _builder.append(_name_7, "\t");
        _builder.append(" messages) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super.updateMessages(messages);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public java.util.function.Supplier<String> getSupplierByKey(String key, Object... values) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch(key) {");
        _builder.newLine();
        EList<MessageEntry> _messageEntryList = nls.getMessageEntryList();
        for (final MessageEntry me : _messageEntryList) {
            _builder.append("\t\t");
            _builder.append("case \"");
            String _name_8 = me.getName();
            _builder.append(_name_8, "\t\t");
            _builder.append("\":");
            _builder.newLineIfNotEmpty();
            boolean _isEmpty = me.getParamList().isEmpty();
            if (_isEmpty) {
                _builder.append("\t\t");
                _builder.append("return this::");
                String _name_9 = me.getName();
                _builder.append(_name_9, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("\t\t");
            _builder.append("return ");
            String _name_10 = me.getName();
            _builder.append(_name_10, "\t\t");
            _builder.append("_supplier(");
            Functions.Function1<MessageParam, String> _function_5 = new Functions.Function1<MessageParam, String>(){

                public String apply(MessageParam p) {
                    String _sourceString = NLSDslGenerator.this.toSourceString(p.getPredefined());
                    String _plus = "(" + _sourceString;
                    String _plus_1 = String.valueOf(_plus) + ") values[";
                    int _indexOf = me.getParamList().indexOf((Object)p);
                    String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_indexOf);
                    return String.valueOf(_plus_2) + "]";
                }
            };
            String _join = IterableExtensions.join((Iterable)ListExtensions.map(me.getParamList(), (Functions.Function1)_function_5), (CharSequence)", ");
            _builder.append(_join, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        EList<NLSBundle> _includedBundleList = nls.getIncludedBundleList();
        for (NLSBundle in : _includedBundleList) {
            EList<MessageEntry> _messageEntryList_1 = in.getMessageEntryList();
            for (final MessageEntry me_1 : _messageEntryList_1) {
                _builder.append("\t\t");
                _builder.append("case \"");
                String _name_11 = me_1.getName();
                _builder.append(_name_11, "\t\t");
                _builder.append("\":");
                _builder.newLineIfNotEmpty();
                boolean _isEmpty_1 = me_1.getParamList().isEmpty();
                if (_isEmpty_1) {
                    _builder.append("\t\t");
                    _builder.append("return this::");
                    String _name_12 = me_1.getName();
                    _builder.append(_name_12, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t\t");
                _builder.append("return ");
                String _name_13 = me_1.getName();
                _builder.append(_name_13, "\t\t");
                _builder.append("_supplier(");
                Functions.Function1<MessageParam, String> _function_6 = new Functions.Function1<MessageParam, String>(){

                    public String apply(MessageParam p) {
                        String _sourceString = NLSDslGenerator.this.toSourceString(p.getPredefined());
                        String _plus = "(" + _sourceString;
                        String _plus_1 = String.valueOf(_plus) + ") values[";
                        int _indexOf = me_1.getParamList().indexOf((Object)p);
                        String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_indexOf);
                        return String.valueOf(_plus_2) + "]";
                    }
                };
                String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(me_1.getParamList(), (Functions.Function1)_function_6), (CharSequence)", ");
                _builder.append(_join_1, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("throw new IllegalArgumentException(\"Key '\"+key+\"' is unknown\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        EList<MessageEntry> _messageEntryList_2 = nls.getMessageEntryList();
        for (MessageEntry me_2 : _messageEntryList_2) {
            boolean _not;
            boolean _notEquals_3;
            _builder.append("\t");
            _builder.append("public String ");
            String _name_14 = me_2.getName();
            _builder.append(_name_14, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            MessageEntry _entryRef = me_2.getEntryRef();
            boolean bl4 = _notEquals_3 = !Objects.equal((Object)_entryRef, null);
            if (_notEquals_3) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return bundle_");
                String _name_15 = this.findNLSBundle(me_2.getEntryRef()).getName();
                _builder.append(_name_15, "\t\t");
                _builder.append(".");
                String _name_16 = me_2.getEntryRef().getName();
                _builder.append(_name_16, "\t\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return getMessages().");
                String _name_17 = me_2.getName();
                _builder.append(_name_17, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            boolean _isEmpty_2 = me_2.getParamList().isEmpty();
            boolean bl5 = _not = !_isEmpty_2;
            if (_not) {
                boolean _notEquals_4;
                _builder.append("\t");
                _builder.append("public String ");
                String _name_18 = me_2.getName();
                _builder.append(_name_18, "\t");
                _builder.append("(");
                Functions.Function1<MessageParam, String> _function_7 = new Functions.Function1<MessageParam, String>(){

                    public String apply(MessageParam p) {
                        String _sourceString = NLSDslGenerator.this.toSourceString(p.getPredefined());
                        String _plus = String.valueOf(_sourceString) + " ";
                        String _var = p.getVar();
                        return String.valueOf(_plus) + _var;
                    }
                };
                String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(me_2.getParamList(), (Functions.Function1)_function_7), (CharSequence)", ");
                _builder.append(_join_2, "\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                MessageEntry _entryRef_1 = me_2.getEntryRef();
                boolean bl6 = _notEquals_4 = !Objects.equal((Object)_entryRef_1, null);
                if (_notEquals_4) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return bundle_");
                    String _name_19 = this.findNLSBundle(me_2.getEntryRef()).getName();
                    _builder.append(_name_19, "\t\t");
                    _builder.append(".");
                    String _name_20 = me_2.getEntryRef().getName();
                    _builder.append(_name_20, "\t\t");
                    _builder.append("(");
                    Functions.Function1<MessageParam, String> _function_8 = new Functions.Function1<MessageParam, String>(){

                        public String apply(MessageParam p) {
                            return p.getVar();
                        }
                    };
                    String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map(me_2.getParamList(), (Functions.Function1)_function_8), (CharSequence)", ");
                    _builder.append(_join_3, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                } else {
                    boolean _notEquals_5;
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("java.util.Map<String,Object> dataMap = new java.util.HashMap<>();");
                    _builder.newLine();
                    EList<MessageParam> _paramList = me_2.getParamList();
                    for (MessageParam p : _paramList) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("dataMap.put(\"");
                        String _var = p.getVar();
                        _builder.append(_var, "\t\t");
                        _builder.append("\",");
                        String _var_1 = p.getVar();
                        _builder.append(_var_1, "\t\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                    }
                    Functions.Function1<RichVarPart, Boolean> _function_9 = new Functions.Function1<RichVarPart, Boolean>(){

                        public Boolean apply(RichVarPart p) {
                            String _format = p.getFormat();
                            return !Objects.equal((Object)_format, null);
                        }
                    };
                    RichVarPart _findFirst_3 = (RichVarPart)IterableExtensions.findFirst((Iterable)Iterables.filter(((Message)IterableExtensions.head(me_2.getMessageList())).getMessage().getExpressions(), RichVarPart.class), (Functions.Function1)_function_9);
                    boolean bl7 = _notEquals_5 = !Objects.equal((Object)_findFirst_3, null);
                    if (_notEquals_5) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("java.util.Map<String,org.eclipse.fx.core.text.Formatter<?>> formatterMap = new java.util.HashMap<>();");
                        _builder.newLine();
                        Functions.Function1<RichVarPart, Boolean> _function_10 = new Functions.Function1<RichVarPart, Boolean>(){

                            public Boolean apply(RichVarPart p) {
                                String _format = p.getFormat();
                                return !Objects.equal((Object)_format, null);
                            }
                        };
                        Functions.Function1<RichVarPart, String> _function_11 = new Functions.Function1<RichVarPart, String>(){

                            public String apply(RichVarPart it) {
                                return NLSDslGenerator.this.findFormatter(it);
                            }
                        };
                        Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(((Message)IterableExtensions.head(me_2.getMessageList())).getMessage().getExpressions(), RichVarPart.class), (Functions.Function1)_function_10), (Functions.Function1)_function_11);
                        HashSet _hashSet_1 = new HashSet();
                        Functions.Function2<HashSet<String>, String, HashSet<String>> _function_12 = new Functions.Function2<HashSet<String>, String, HashSet<String>>(){

                            public HashSet<String> apply(HashSet<String> s, String p) {
                                s.add(p);
                                return s;
                            }
                        };
                        HashSet _fold = (HashSet)IterableExtensions.fold((Iterable)_map, _hashSet_1, (Functions.Function2)_function_12);
                        for (String o : _fold) {
                            boolean _equals = Objects.equal((Object)o, (Object)"-default");
                            if (_equals) {
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("formatterMap.put(\"");
                                _builder.append(o, "\t\t");
                                _builder.append("\",org.eclipse.fx.core.text.Formatter.TO_STRING);");
                                _builder.newLineIfNotEmpty();
                                continue;
                            }
                            boolean _equals_1 = Objects.equal((Object)o, (Object)"-date");
                            if (_equals_1) {
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("formatterMap.put(\"");
                                _builder.append(o, "\t\t");
                                _builder.append("\",_date);");
                                _builder.newLineIfNotEmpty();
                                continue;
                            }
                            boolean _equals_2 = Objects.equal((Object)o, (Object)"-number");
                            if (_equals_2) {
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("formatterMap.put(\"");
                                _builder.append(o, "\t\t");
                                _builder.append("\",_number);");
                                _builder.newLineIfNotEmpty();
                                continue;
                            }
                            boolean _equals_3 = Objects.equal((Object)o, (Object)"-temporal");
                            if (_equals_3) {
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("formatterMap.put(\"");
                                _builder.append(o, "\t\t");
                                _builder.append("\",_temporal);");
                                _builder.newLineIfNotEmpty();
                                continue;
                            }
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("formatterMap.put(\"");
                            _builder.append(o, "\t\t");
                            _builder.append("\",cust_");
                            _builder.append(o, "\t\t");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("return org.eclipse.fx.core.text.MessageFormatter.create(dataMap::get,formatterMap::get).apply( ");
                        String _name_21 = me_2.getName();
                        _builder.append(_name_21, "\t\t");
                        _builder.append("() );");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("return org.apache.commons.lang.text.StrSubstitutor.replace( ");
                        String _name_22 = me_2.getName();
                        _builder.append(_name_22, "\t\t");
                        _builder.append("(), dataMap);");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("public java.util.function.Supplier<String> ");
                String _name_23 = me_2.getName();
                _builder.append(_name_23, "\t");
                _builder.append("_supplier(");
                Functions.Function1<MessageParam, String> _function_13 = new Functions.Function1<MessageParam, String>(){

                    public String apply(MessageParam p) {
                        String _sourceString = NLSDslGenerator.this.toSourceString(p.getPredefined());
                        String _plus = String.valueOf(_sourceString) + " ";
                        String _var = p.getVar();
                        return String.valueOf(_plus) + _var;
                    }
                };
                String _join_4 = IterableExtensions.join((Iterable)ListExtensions.map(me_2.getParamList(), (Functions.Function1)_function_13), (CharSequence)", ");
                _builder.append(_join_4, "\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return () -> ");
                String _name_24 = me_2.getName();
                _builder.append(_name_24, "\t\t");
                _builder.append("(");
                Functions.Function1<MessageParam, String> _function_14 = new Functions.Function1<MessageParam, String>(){

                    public String apply(MessageParam p) {
                        return p.getVar();
                    }
                };
                String _join_5 = IterableExtensions.join((Iterable)ListExtensions.map(me_2.getParamList(), (Functions.Function1)_function_14), (CharSequence)", ");
                _builder.append(_join_5, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.newLine();
        }
        _builder.newLine();
        EList<NLSBundle> _includedBundleList_1 = nls.getIncludedBundleList();
        for (NLSBundle in_1 : _includedBundleList_1) {
            EList<MessageEntry> _messageEntryList_3 = in_1.getMessageEntryList();
            for (MessageEntry me_3 : _messageEntryList_3) {
                boolean _not_1;
                _builder.append("\t");
                _builder.append("public String ");
                String _name_25 = me_3.getName();
                _builder.append(_name_25, "\t");
                _builder.append("() {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return bundle_");
                String _name_26 = in_1.getName();
                _builder.append(_name_26, "\t\t");
                _builder.append(".");
                String _name_27 = me_3.getName();
                _builder.append(_name_27, "\t\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                boolean _isEmpty_3 = me_3.getParamList().isEmpty();
                boolean bl8 = _not_1 = !_isEmpty_3;
                if (_not_1) {
                    _builder.append("\t");
                    _builder.append("public String ");
                    String _name_28 = me_3.getName();
                    _builder.append(_name_28, "\t");
                    _builder.append("(");
                    Functions.Function1<MessageParam, String> _function_15 = new Functions.Function1<MessageParam, String>(){

                        public String apply(MessageParam p) {
                            String _sourceString = NLSDslGenerator.this.toSourceString(p.getPredefined());
                            String _plus = String.valueOf(_sourceString) + " ";
                            String _var = p.getVar();
                            return String.valueOf(_plus) + _var;
                        }
                    };
                    String _join_6 = IterableExtensions.join((Iterable)ListExtensions.map(me_3.getParamList(), (Functions.Function1)_function_15), (CharSequence)", ");
                    _builder.append(_join_6, "\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return bundle_");
                    String _name_29 = in_1.getName();
                    _builder.append(_name_29, "\t\t");
                    _builder.append(".");
                    String _name_30 = me_3.getName();
                    _builder.append(_name_30, "\t\t");
                    _builder.append("(");
                    Functions.Function1<MessageParam, String> _function_16 = new Functions.Function1<MessageParam, String>(){

                        public String apply(MessageParam p) {
                            return p.getVar();
                        }
                    };
                    String _join_7 = IterableExtensions.join((Iterable)ListExtensions.map(me_3.getParamList(), (Functions.Function1)_function_16), (CharSequence)", ");
                    _builder.append(_join_7, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.newLine();
                _builder.append("\t");
                _builder.append("public java.util.function.Supplier<String> ");
                String _name_31 = me_3.getName();
                _builder.append(_name_31, "\t");
                _builder.append("_supplier(");
                Functions.Function1<MessageParam, String> _function_17 = new Functions.Function1<MessageParam, String>(){

                    public String apply(MessageParam p) {
                        String _sourceString = NLSDslGenerator.this.toSourceString(p.getPredefined());
                        String _plus = String.valueOf(_sourceString) + " ";
                        String _var = p.getVar();
                        return String.valueOf(_plus) + _var;
                    }
                };
                String _join_8 = IterableExtensions.join((Iterable)ListExtensions.map(me_3.getParamList(), (Functions.Function1)_function_17), (CharSequence)", ");
                _builder.append(_join_8, "\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return () -> ");
                String _name_32 = me_3.getName();
                _builder.append(_name_32, "\t\t");
                _builder.append("(");
                Functions.Function1<MessageParam, String> _function_18 = new Functions.Function1<MessageParam, String>(){

                    public String apply(MessageParam p) {
                        return p.getVar();
                    }
                };
                String _join_9 = IterableExtensions.join((Iterable)ListExtensions.map(me_3.getParamList(), (Functions.Function1)_function_18), (CharSequence)", ");
                _builder.append(_join_9, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String toSourceString(PredefinedTypes t) {
        boolean _equals = Objects.equal((Object)((Object)t), (Object)((Object)PredefinedTypes.ANY));
        if (_equals) {
            return "Object";
        }
        boolean _equals_1 = Objects.equal((Object)((Object)t), (Object)((Object)PredefinedTypes.DATE));
        if (_equals_1) {
            return "java.util.Date";
        }
        boolean _equals_2 = Objects.equal((Object)((Object)t), (Object)((Object)PredefinedTypes.TEMPORAL));
        if (_equals_2) {
            return "java.time.temporal.TemporalAccessor";
        }
        return "Number";
    }

    public CharSequence genPropertyFile(NLSBundle nls, final String lang) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Do not modify - Auto generated from ");
        String _lastSegment = nls.eResource().getURI().lastSegment();
        _builder.append(_lastSegment);
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        Functions.Function1<MessageEntry, Boolean> _function = new Functions.Function1<MessageEntry, Boolean>(){

            public Boolean apply(MessageEntry m) {
                Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

                    public Boolean apply(Message mm) {
                        String _name = mm.getName();
                        return Objects.equal((Object)_name, (Object)lang);
                    }
                };
                Message _findFirst = (Message)IterableExtensions.findFirst(m.getMessageList(), (Functions.Function1)_function);
                return !Objects.equal((Object)_findFirst, null);
            }
        };
        Iterable _filter = IterableExtensions.filter(nls.getMessageEntryList(), (Functions.Function1)_function);
        for (MessageEntry e : _filter) {
            String _name = e.getName();
            _builder.append(_name);
            _builder.append(" = ");
            Functions.Function1<Message, Boolean> _function_1 = new Functions.Function1<Message, Boolean>(){

                public Boolean apply(Message m) {
                    String _name = m.getName();
                    return Objects.equal((Object)_name, (Object)lang);
                }
            };
            String _text = this.toText(((Message)IterableExtensions.findFirst(e.getMessageList(), (Functions.Function1)_function_1)).getMessage());
            _builder.append(_text);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String toText(RichString r) {
        Functions.Function1<EObject, String> _function = new Functions.Function1<EObject, String>(){

            public String apply(EObject e) {
                if (e instanceof RichStringLiteral) {
                    String _value = ((RichStringLiteral)e).getValue();
                    int _length = ((RichStringLiteral)e).getValue().length();
                    int _minus = _length - 3;
                    return _value.substring(3, _minus);
                }
                if (e instanceof RichStringLiteralStart) {
                    String _value_1 = ((RichStringLiteralStart)e).getValue();
                    int _length_1 = ((RichStringLiteralStart)e).getValue().length();
                    int _minus_1 = _length_1 - 1;
                    return _value_1.substring(3, _minus_1);
                }
                if (e instanceof RichStringLiteralEnd) {
                    String _value_2 = ((RichStringLiteralEnd)e).getValue();
                    int _length_2 = ((RichStringLiteralEnd)e).getValue().length();
                    int _minus_2 = _length_2 - 3;
                    return _value_2.substring(1, _minus_2);
                }
                if (e instanceof RichVarPart) {
                    boolean _notEquals;
                    String _key = ((RichVarPart)e).getKey();
                    String _plus = "${" + _key;
                    String _xifexpression = null;
                    String _format = ((RichVarPart)e).getFormat();
                    boolean bl = _notEquals = !Objects.equal((Object)_format, null);
                    if (_notEquals) {
                        String _findFormatter = NLSDslGenerator.this.findFormatter((RichVarPart)e);
                        String _plus_1 = "," + _findFormatter;
                        String _plus_2 = String.valueOf(_plus_1) + ",";
                        String _format_1 = ((RichVarPart)e).getFormat();
                        _xifexpression = String.valueOf(_plus_2) + _format_1 + "}";
                    } else {
                        _xifexpression = "}";
                    }
                    return String.valueOf(_plus) + _xifexpression;
                }
                if (e instanceof RichStringLiteralInbetween) {
                    String _value_3 = ((RichStringLiteralInbetween)e).getValue();
                    int _length_3 = ((RichStringLiteralInbetween)e).getValue().length();
                    int _minus_3 = _length_3 - 1;
                    return _value_3.substring(1, _minus_3);
                }
                return e.toString();
            }
        };
        return IterableExtensions.join((Iterable)ListExtensions.map(r.getExpressions(), (Functions.Function1)_function));
    }

    public String findFormatter(final RichVarPart p) {
        boolean _notEquals;
        NLSFormatter _formatterClass = p.getFormatterClass();
        boolean bl = _notEquals = !Objects.equal((Object)_formatterClass, null);
        if (_notEquals) {
            return p.getFormatterClass().getName();
        }
        Functions.Function1<MessageParam, Boolean> _function = new Functions.Function1<MessageParam, Boolean>(){

            public Boolean apply(MessageParam param) {
                String _var = param.getVar();
                String _key = p.getKey();
                return Objects.equal((Object)_var, (Object)_key);
            }
        };
        PredefinedTypes _predefined = ((MessageParam)IterableExtensions.findFirst(this.findMessageEntry(p).getParamList(), (Functions.Function1)_function)).getPredefined();
        if (_predefined != null) {
            switch (_predefined) {
                case DATE: {
                    return "-date";
                }
                case NUMBER: {
                    return "-number";
                }
                case TEMPORAL: {
                    return "-temporal";
                }
            }
            return "-default";
        }
        return "-default";
    }

    public NLSBundle findNLSBundle(EObject e) {
        EObject _eContainer = e.eContainer();
        if (_eContainer instanceof NLSBundle) {
            EObject _eContainer_1 = e.eContainer();
            return (NLSBundle)_eContainer_1;
        }
        EObject _eContainer_2 = e.eContainer();
        NLSBundle _findNLSBundle = null;
        if (_eContainer_2 != null) {
            _findNLSBundle = this.findNLSBundle(_eContainer_2);
        }
        return _findNLSBundle;
    }

    public MessageEntry findMessageEntry(EObject e) {
        EObject _eContainer = e.eContainer();
        if (_eContainer instanceof MessageEntry) {
            EObject _eContainer_1 = e.eContainer();
            return (MessageEntry)_eContainer_1;
        }
        EObject _eContainer_2 = e.eContainer();
        MessageEntry _findMessageEntry = null;
        if (_eContainer_2 != null) {
            _findMessageEntry = this.findMessageEntry(_eContainer_2);
        }
        return _findMessageEntry;
    }
}

