/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui.doc;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.css.cssDsl.ClassSelector;
import org.eclipse.fx.ide.css.cssDsl.ElementSelector;
import org.eclipse.fx.ide.css.cssDsl.IdSelector;
import org.eclipse.fx.ide.css.cssDsl.css_property;
import org.eclipse.fx.ide.css.cssDsl.simple_selector;
import org.eclipse.fx.ide.css.cssext.ICssExtManager;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSNumLiteral;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRule;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleBracket;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleConcat;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleConcatWithoutSpace;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleFunc;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleLiteral;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleOr;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRulePostfix;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleRef;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleRegex;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleSymbol;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleXor;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSType;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.Doku;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.ElementDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.PackageDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.PropertyDefinition;
import org.eclipse.fx.ide.css.cssext.ui.JavaDocParser;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.ui.editor.hover.html.XtextElementLinks;

public class CssExtDocParser {
    private static boolean DEBUG_RESOURCES = false;
    @Inject
    private ICssExtManager cssExtManager;
    @Inject
    private XtextElementLinks elementLinks;
    @Inject
    private IQualifiedNameProvider nameProvider;

    String translateRule(CSSRule r) {
        String result = "";
        if (r instanceof CSSRuleOr) {
            Iterator it = ((CSSRuleOr)r).getOrs().iterator();
            while (it.hasNext()) {
                result = String.valueOf(result) + this.translateRule((CSSRule)it.next());
                if (!it.hasNext()) continue;
                result = String.valueOf(result) + " | ";
            }
        } else if (r instanceof CSSRuleConcat) {
            Iterator it = ((CSSRuleConcat)r).getConc().iterator();
            while (it.hasNext()) {
                result = String.valueOf(result) + this.translateRule((CSSRule)it.next());
                if (!it.hasNext()) continue;
                result = String.valueOf(result) + " ";
            }
        } else if (r instanceof CSSRuleConcatWithoutSpace) {
            Iterator it = ((CSSRuleConcatWithoutSpace)r).getConc().iterator();
            while (it.hasNext()) {
                result = String.valueOf(result) + this.translateRule((CSSRule)it.next());
                if (!it.hasNext()) continue;
                result = String.valueOf(result) + " ~ ";
            }
        } else if (r instanceof CSSRuleBracket) {
            result = String.valueOf(result) + "[ " + this.translateRule(((CSSRuleBracket)r).getInner()) + " ]";
        } else if (r instanceof CSSRuleXor) {
            Iterator it = ((CSSRuleXor)r).getXors().iterator();
            while (it.hasNext()) {
                result = String.valueOf(result) + this.translateRule((CSSRule)it.next());
                if (!it.hasNext()) continue;
                result = String.valueOf(result) + " || ";
            }
        } else {
            result = r instanceof CSSRuleLiteral ? String.valueOf(result) + ((CSSRuleLiteral)r).getValue() : (r instanceof CSSNumLiteral ? String.valueOf(result) + ((CSSNumLiteral)r).getValue() : (r instanceof CSSRuleRef ? String.valueOf(result) + this.elementLinks.createLink("eclipse-xtext-doc", (EObject)((CSSRuleRef)r).getRef(), "&lt;" + ((CSSRuleRef)r).getRef().getName() + "&gt;") : (r instanceof CSSRulePostfix ? String.valueOf(result) + this.translateRule(((CSSRulePostfix)r).getRule()) + ((CSSRulePostfix)r).getCardinality() : (r instanceof CSSRuleRegex ? String.valueOf(result) + ((CSSRuleRegex)r).getRegex() : (r instanceof CSSRuleSymbol ? String.valueOf(result) + ((CSSRuleSymbol)r).getSymbol() : (r instanceof CSSType ? ((CSSType)r).getType() : (r == null ? "<code>null</code>" : "UNKNOWN: " + r)))))));
        }
        return result;
    }

    protected String getDocForProperty(PropertyDefinition property) {
        if (property != null) {
            String rule = "syntax = " + this.translateRule(property.getRule()) + "<br>";
            String javadoc = CssExtDocParser.prepareDoku(property.getDoku());
            return String.valueOf(CssExtDocParser.formatRule(rule)) + javadoc;
        }
        return "no documentation found";
    }

    protected String getDocForProperty(IFile f, EObject context, String propertyName) {
        return this.getDocForProperty(this.findPropertyByName(f, context, propertyName));
    }

    public String getDocumentation(IFile f, EObject o) {
        if (o instanceof ElementDefinition) {
            return CssExtDocParser.getDocForElement((ElementDefinition)o);
        }
        if (o instanceof PropertyDefinition) {
            return this.getDocForProperty((PropertyDefinition)o);
        }
        if (o instanceof CSSRuleDefinition) {
            return this.getDocumentationForRule((CSSRuleDefinition)o);
        }
        if (o instanceof PropertyDefinition) {
            return this.getDocForProperty((PropertyDefinition)o);
        }
        if (o instanceof PackageDefinition) {
            return CssExtDocParser.getDocForPackage((PackageDefinition)o);
        }
        if (o instanceof ClassSelector) {
            return this.getDocForStyleClass(f, o, ((ClassSelector)o).getName());
        }
        if (o instanceof IdSelector) {
            return null;
        }
        if (o instanceof ElementSelector) {
            return this.getDocForElement(f, o, ((ElementSelector)o).getName());
        }
        if (o instanceof css_property) {
            return this.getDocForProperty(f, o, ((css_property)o).getName());
        }
        return "no documentation found";
    }

    private static String formatRule(String rule) {
        return "<p class=\"rule\">" + rule + "</p>";
    }

    private String getDocumentationForRule(CSSRuleDefinition r) {
        String func = "";
        if (r.getFunc() != null) {
            CSSRuleFunc f = (CSSRuleFunc)r.getFunc();
            func = String.valueOf(f.getName()) + "(" + this.translateRule(f.getParams()) + ")";
        }
        String rule = "";
        if (r.getRule() != null) {
            rule = String.valueOf(r.getName()) + " = " + this.translateRule(r.getRule());
        }
        String javadoc = CssExtDocParser.prepareDoku(r.getDoku());
        return String.valueOf(CssExtDocParser.formatRule(String.valueOf(func) + rule)) + javadoc;
    }

    protected String getDocForStyleClass(IFile f, EObject context, String styleClass) {
        Assert.isNotNull((Object)styleClass);
        ElementDefinition element = this.findElementByStyleClass(f, context, styleClass);
        if (element != null) {
            return CssExtDocParser.getDocForElement(element);
        }
        return null;
    }

    protected String getDocForElement(IFile f, EObject context, String elName) {
        Assert.isNotNull((Object)elName);
        ElementDefinition element = this.findElementByName(f, context, elName);
        if (element != null) {
            return CssExtDocParser.getDocForElement(element);
        }
        return null;
    }

    protected static String getDocForElement(ElementDefinition el) {
        Assert.isNotNull((Object)el);
        return CssExtDocParser.prepareDoku(el.getDoku());
    }

    protected static String getDocForPackage(PackageDefinition pkg) {
        Assert.isNotNull((Object)pkg);
        return CssExtDocParser.prepareDoku(pkg.getDoku());
    }

    private static String prepareDoku(Doku doku) {
        if (doku != null) {
            return new JavaDocParser().parse(doku.getContent());
        }
        return "not documented!";
    }

    protected String getDocHeadForProperty(IFile f, EObject context, String propertyName) {
        Assert.isNotNull((Object)propertyName);
        PropertyDefinition property = this.findPropertyByName(f, context, propertyName);
        if (property != null) {
            return this.getDocHeadForProperty(property);
        }
        return "<b>" + propertyName + "</b>";
    }

    protected String getDocHeadForProperty(PropertyDefinition property) {
        Assert.isNotNull((Object)property);
        ElementDefinition element = (ElementDefinition)property.eContainer();
        StringBuffer out = new StringBuffer();
        out.append("<nobr>");
        CssExtDocParser.printImage(out, "property_16x16.png");
        CssExtDocParser.printName(out, property.getName());
        out.append("&nbsp;");
        this.printDefiningElement(out, element);
        out.append("</nobr>");
        return out.toString();
    }

    protected String getDocHeadForElement(IFile f, EObject context, String elName) {
        ElementDefinition element = this.findElementByName(f, context, elName);
        if (element != null && element.getStyleclass() == null) {
            return this.getDocHeadForElement(element);
        }
        return null;
    }

    protected String getDocHeadForStyleClass(IFile f, EObject context, String styleClass) {
        ElementDefinition element = this.findElementByStyleClass(f, context, styleClass);
        if (element != null) {
            return this.getDocHeadForElement(element);
        }
        return null;
    }

    private static void printImage(StringBuffer out, String image) {
        URL bundleUrl = Platform.getBundle((String)"org.eclipse.fx.ide.css.ui").getEntry("icons/" + image);
        URL fileUrl = null;
        try {
            fileUrl = FileLocator.toFileURL((URL)bundleUrl);
            String url = fileUrl.toExternalForm();
            out.append("<img class=\"symbol\" src=\"" + url + "\"/>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printName(StringBuffer out, String name) {
        out.append("<span class=\"name\"><b>" + name + "</b></span>");
    }

    private static void printStyleClass(StringBuffer out, ElementDefinition elDef) {
        if (elDef.getStyleclass() != null) {
            out.append("<br/><span class=\"styleclass\"><span class=\"keyword\">style-class</span> .");
            out.append(elDef.getStyleclass());
            out.append("</span>");
        }
    }

    private void printPackageDefinition(StringBuffer out, PackageDefinition pkg) {
        out.append("<span class=\"pkg\">(defined in " + this.elementLinks.createLink("eclipse-xtext-doc", (EObject)pkg, this.nameProvider.getFullyQualifiedName((EObject)pkg).toString()) + ")</span>");
    }

    private void printDefiningElement(StringBuffer out, ElementDefinition element) {
        out.append("<span class=\"pkg\">(defined in " + this.elementLinks.createLink("eclipse-xtext-doc", (EObject)element, this.nameProvider.getFullyQualifiedName((EObject)element).toString()) + ")</span>");
    }

    private void printSuperElements(StringBuffer out, List<ElementDefinition> superEls) {
        if (!superEls.isEmpty()) {
            out.append("<br/><span class=\"extends\"><span class=\"keyword\">extends</span> ");
            Iterator<ElementDefinition> supaIt = superEls.iterator();
            while (supaIt.hasNext()) {
                ElementDefinition supa = supaIt.next();
                if (supa.eResource() != null) {
                    out.append(this.elementLinks.createLink("eclipse-xtext-doc", (EObject)supa, supa.getName()));
                    if (DEBUG_RESOURCES) {
                        try {
                            out.append(this.elementLinks.createURI("eclipse-xtext-doc", (EObject)supa));
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    out.append("LINKING ERROR");
                }
                if (DEBUG_RESOURCES) {
                    out.append("(");
                    out.append(supa.toString());
                    out.append(")");
                }
                if (!supaIt.hasNext()) continue;
                out.append(", ");
            }
            out.append("</span>");
        }
    }

    protected String getDocHeadForElement(ElementDefinition element) {
        Assert.isNotNull((Object)element);
        PackageDefinition pkg = CssExtDocParser.findPackage(element);
        StringBuffer out = new StringBuffer();
        if (DEBUG_RESOURCES) {
            boolean hasR = element.eResource() != null;
            boolean hasRS = hasR && element.eResource().getResourceSet() != null;
            out.append(" r=");
            out.append(hasR ? element.eResource().getURI().toString() : "none");
            out.append(" rs=");
            out.append(hasRS ? Integer.valueOf(System.identityHashCode(element.eResource().getResourceSet())) : "none");
            if (hasRS) {
                for (Resource r : element.eResource().getResourceSet().getResources()) {
                    out.append("<br> * ");
                    out.append(r.getURI());
                }
            }
            out.append("<br />");
        }
        out.append("<nobr>");
        CssExtDocParser.printImage(out, "selector_16x16.png");
        CssExtDocParser.printName(out, element.getName());
        out.append("&nbsp;");
        this.printPackageDefinition(out, pkg);
        out.append("</nobr>");
        CssExtDocParser.printStyleClass(out, element);
        out.append("<nobr>");
        this.printSuperElements(out, (List<ElementDefinition>)element.getSuper());
        out.append("</nobr>");
        return out.toString();
    }

    private static PackageDefinition findPackage(ElementDefinition element) {
        return (PackageDefinition)element.eContainer();
    }

    private static PackageDefinition findPackage(CSSRuleDefinition element) {
        return (PackageDefinition)element.eContainer();
    }

    private PropertyDefinition findPropertyByName(IFile f, EObject context, String propertyName) {
        return this.cssExtManager.findPropertyByName(f, context, propertyName);
    }

    private ElementDefinition findElementByName(IFile f, EObject context, String elName) {
        return this.cssExtManager.findElementByName(f, context, elName);
    }

    private ElementDefinition findElementByStyleClass(IFile f, EObject context, String styleClass) {
        return this.cssExtManager.findElementByStyleClass(f, context, styleClass);
    }

    public String getDocHead(IFile f, EObject o) {
        ElementDefinition element;
        if (o instanceof CSSRuleDefinition) {
            return this.getDocHeadForCssRule((CSSRuleDefinition)o);
        }
        if (o instanceof ElementDefinition) {
            return this.getDocHeadForElement((ElementDefinition)o);
        }
        if (o instanceof PropertyDefinition) {
            return this.getDocHeadForProperty((PropertyDefinition)o);
        }
        if (o instanceof PackageDefinition) {
            return this.getDocHeadForPackage((PackageDefinition)o);
        }
        if (o instanceof ClassSelector && (element = this.findElementByStyleClass(f, o, ((ClassSelector)o).getName())) != null) {
            return this.getDocHeadForElement(element);
        }
        if (o instanceof ElementSelector) {
            return this.getDocHeadForElement(f, o, ((ElementSelector)o).getName());
        }
        if (o instanceof css_property) {
            return this.getDocHeadForProperty(f, o, ((css_property)o).getName());
        }
        if (o instanceof simple_selector) {
            simple_selector s = (simple_selector)o;
            String elementName = null;
            if (s.getElement() instanceof ElementSelector) {
                elementName = s.getElement().getName();
            }
            return this.getDocHeadForElement(f, o, elementName);
        }
        return null;
    }

    private String getDocHeadForCssRule(CSSRuleDefinition rule) {
        Assert.isNotNull((Object)rule);
        PackageDefinition pkg = CssExtDocParser.findPackage(rule);
        StringBuffer out = new StringBuffer();
        out.append("<nobr>");
        CssExtDocParser.printImage(out, "rule_16x16.png");
        CssExtDocParser.printName(out, rule.getName());
        out.append("&nbsp;");
        this.printPackageDefinition(out, pkg);
        out.append("</nobr>");
        return out.toString();
    }

    private String getDocHeadForPackage(PackageDefinition pkg) {
        Assert.isNotNull((Object)pkg);
        StringBuffer out = new StringBuffer();
        out.append("<nobr>");
        CssExtDocParser.printImage(out, "package_16x16.png");
        CssExtDocParser.printName(out, this.nameProvider.getFullyQualifiedName((EObject)pkg).toString());
        out.append("</nobr>");
        return out.toString();
    }
}

