/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.preferences;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egerrit.internal.core.GerritCredentials;
import org.eclipse.egerrit.internal.core.GerritFactory;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.GerritServerInformation;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.Messages;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.Utils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Version;

public class GerritServerDialog
extends Dialog {
    private final int fWIDTH = 450;
    private final int fHEIGHT = 275;
    private final String DIALOG_TITLE = Messages.GerritServerDialog_0;
    private final String fOkTooltip = Messages.GerritServerDialog_1;
    private final String fCancelTooltip = Messages.GerritServerDialog_2;
    private final String HEADER = Messages.GerritServerDialog_3;
    private final String URL_TOOLTIP = Messages.GerritServerDialog_4;
    private final String URL_EXAMPLE_TOOLTIP = Messages.GerritServerDialog_5;
    private final String SHORTNAME_TOOLTIP = Messages.GerritServerDialog_6;
    private final String SHORTNAME_EXAMPLE_TOOLTIP = Messages.GerritServerDialog_7;
    private final String INVALID_MESSAGE = Messages.GerritServerDialog_8;
    private static final String TITLE = Messages.GerritServerDialog_9;
    private final String WANT_TO_SAVE = String.valueOf(Messages.GerritServerDialog_10) + Messages.GerritServerDialog_11;
    private Text txtServerName;
    private Text txtServerURL;
    private Text txtUserName;
    private Text txtPassword;
    private Shell shell;
    private Button ok;
    private Button cancel;
    private GerritServerInformation workingCopy;
    private GerritServerInformation original;
    private ProgressBar progressBar;

    public GerritServerDialog(Shell shell, GerritServerInformation originalInfo) {
        super(shell);
        this.setShellStyle(2160);
        this.original = originalInfo;
        if (originalInfo != null) {
            this.workingCopy = originalInfo.clone();
        }
    }

    protected Control createDialogArea(Composite aParent) {
        this.getShell().setText(this.DIALOG_TITLE);
        Composite composite = (Composite)super.createDialogArea(aParent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 5;
        layout.marginLeft = 5;
        composite.setLayout((Layout)layout);
        composite.getShell().setMinimumSize(450, 275);
        this.buildDialog(composite);
        return composite;
    }

    private void buildDialog(Composite composite) {
        Label labelComments = new Label(composite, 64);
        GridData labelData = new GridData(16384, 0x1000000, true, false, 2, 1);
        labelComments.setLayoutData((Object)labelData);
        labelComments.setText(this.HEADER);
        labelComments.setToolTipText(this.URL_TOOLTIP);
        Label labelServerURI = new Label(composite, 0);
        labelServerURI.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        labelServerURI.setText(Messages.GerritServerDialog_12);
        labelServerURI.setToolTipText(this.URL_TOOLTIP);
        this.txtServerURL = new Text(composite, 2048);
        this.txtServerURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtServerURL.setToolTipText(this.URL_EXAMPLE_TOOLTIP);
        this.txtServerURL.setText(this.workingCopy != null ? this.workingCopy.getServerURI() : "");
        this.txtServerURL.addFocusListener(this.serverURIFocusListener());
        Label labelServerName = new Label(composite, 0);
        labelServerName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        labelServerName.setText(Messages.GerritServerDialog_13);
        labelServerName.setToolTipText(this.SHORTNAME_EXAMPLE_TOOLTIP);
        this.txtServerName = new Text(composite, 2048);
        this.txtServerName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtServerName.setToolTipText(this.SHORTNAME_TOOLTIP);
        this.txtServerName.setText(this.workingCopy != null ? this.workingCopy.getName() : "");
        this.txtServerName.addModifyListener(this.serverNameListener());
        Label separatorServerInfoUserInfo = new Label(composite, 258);
        separatorServerInfoUserInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label labelUser = new Label(composite, 0);
        labelUser.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        labelUser.setText(Messages.GerritServerDialog_14);
        this.txtUserName = new Text(composite, 2048);
        this.txtUserName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtUserName.setText(this.workingCopy != null ? this.workingCopy.getUserName() : "");
        this.txtUserName.addModifyListener(this.userListener());
        Label labelPassword = new Label(composite, 0);
        labelPassword.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        labelPassword.setText(Messages.GerritServerDialog_15);
        this.txtPassword = new Text(composite, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtPassword.setText(this.workingCopy == null ? "" : (this.workingCopy.isPasswordProvided() ? "********" : ""));
        this.txtPassword.addModifyListener(this.passwdListener());
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.progressBar = new ProgressBar(composite, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setVisible(false);
        composite.addTraverseListener(this.keyTraversedListener());
    }

    private void isServerInfoReady() {
        if (this.workingCopy == null) {
            try {
                this.workingCopy = new GerritServerInformation(null, null);
            }
            catch (URISyntaxException e1) {
                Utils.displayInformation(this.shell, this.DIALOG_TITLE, e1.getLocalizedMessage());
            }
        }
    }

    private ModifyListener serverNameListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GerritServerDialog.this.isServerInfoReady();
                GerritServerDialog.this.workingCopy.setServerName(((Text)e.widget).getText());
                GerritServerDialog.this.txtServerURL.setText(GerritServerDialog.this.workingCopy.getServerURI());
            }
        };
    }

    private ModifyListener userListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GerritServerDialog.this.isServerInfoReady();
                GerritServerDialog.this.workingCopy.setUserName(((Text)e.widget).getText());
            }
        };
    }

    private ModifyListener passwdListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GerritServerDialog.this.isServerInfoReady();
                GerritServerDialog.this.workingCopy.setPassword(((Text)e.widget).getText());
            }
        };
    }

    private FocusListener serverURIFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String text = ((Text)e.widget).getText().trim();
                if (GerritServerDialog.this.workingCopy == null) {
                    try {
                        GerritServerDialog.this.workingCopy = new GerritServerInformation(text, GerritServerDialog.this.txtServerName.getText().trim());
                    }
                    catch (URISyntaxException e1) {
                        Utils.displayInformation(GerritServerDialog.this.shell, GerritServerDialog.this.DIALOG_TITLE, e1.getLocalizedMessage());
                        return;
                    }
                }
                URI uri = null;
                try {
                    uri = new URI(text);
                }
                catch (URISyntaxException e1) {
                    GerritServerDialog.this.workingCopy.setServerURI(text);
                    Utils.displayInformation(GerritServerDialog.this.shell, GerritServerDialog.this.DIALOG_TITLE, e1.getLocalizedMessage());
                }
                if (uri != null) {
                    GerritServerDialog.this.workingCopy.setSeverInfo(uri);
                    GerritServerDialog.this.txtServerName.setText(GerritServerDialog.this.workingCopy.getName());
                    GerritServerDialog.this.txtUserName.setText(GerritServerDialog.this.workingCopy.getUserName());
                }
            }
        };
    }

    private TraverseListener keyTraversedListener() {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 13) {
                    GerritServerDialog.this.validateSettings();
                }
            }
        };
    }

    protected void createButtonsForButtonBar(Composite aParent) {
        this.ok = this.createButton(aParent, 0, IDialogConstants.OK_LABEL, false);
        this.cancel = this.createButton(aParent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.ok.setToolTipText(this.fOkTooltip);
        this.cancel.setToolTipText(this.fCancelTooltip);
    }

    protected void buttonPressed(int aButtonId) {
        if (aButtonId == 0) {
            this.progressBar.setSelection(0);
            this.progressBar.setVisible(true);
            this.validateSettings();
        }
        if (aButtonId == 1) {
            this.workingCopy = this.original;
            super.setReturnCode(1);
            super.close();
        }
    }

    private void validateSettings() {
        Job job = new Job(Messages.GerritServerDialog_30){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.GerritServerDialog_30, 100);
                try {
                    try {
                        GerritServerDialog.this.isServerInfoReady();
                        if (GerritServerDialog.this.validateURL(monitor).booleanValue()) {
                            GerritServerDialog.this.completeURLValidation(GerritServerDialog.this.validConnection(monitor));
                        } else if (!GerritServerDialog.this.ok.isDisposed()) {
                            Utils.displayInformation(null, GerritServerDialog.this.DIALOG_TITLE, GerritServerDialog.this.INVALID_MESSAGE);
                        }
                    }
                    catch (URISyntaxException e) {
                        GerritServerDialog.this.setProgress(monitor, 100);
                        if (!GerritServerDialog.this.ok.isDisposed()) {
                            Utils.displayInformation(GerritServerDialog.this.shell, GerritServerDialog.this.DIALOG_TITLE, e.getLocalizedMessage());
                        }
                        monitor.done();
                    }
                    catch (EGerritException e) {
                        block12: {
                            GerritServerDialog.this.setProgress(monitor, 100);
                            if (GerritServerDialog.this.ok.isDisposed()) break block12;
                            Utils.displayInformation(GerritServerDialog.this.shell, GerritServerDialog.this.DIALOG_TITLE, e.getLocalizedMessage());
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    private void completeURLValidation(boolean b) {
        if (b) {
            super.setReturnCode(0);
            if (!this.ok.isDisposed()) {
                this.ok.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        GerritServerDialog.this.okPressed();
                    }
                });
            }
        } else if (this.getServerInfo().getHostId().isEmpty()) {
            Utils.displayInformation(null, TITLE, this.INVALID_MESSAGE);
        } else {
            boolean bool = Utils.queryInformation(null, TITLE, this.WANT_TO_SAVE);
            if (bool) {
                super.setReturnCode(0);
                if (!this.ok.isDisposed()) {
                    this.ok.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            GerritServerDialog.this.okPressed();
                        }
                    });
                }
            }
        }
    }

    private void setProgress(IProgressMonitor monitor, final int value) {
        monitor.worked(value);
        if (!this.progressBar.isDisposed()) {
            this.progressBar.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!GerritServerDialog.this.progressBar.isDisposed()) {
                        int toset = GerritServerDialog.this.progressBar.getSelection() + value;
                        if (toset >= 100) {
                            GerritServerDialog.this.progressBar.setVisible(false);
                        }
                        GerritServerDialog.this.progressBar.setSelection(toset);
                    }
                }
            });
        }
    }

    private boolean validConnection(IProgressMonitor monitor) throws EGerritException {
        GerritRepository repo;
        boolean connexionSuccesfull = false;
        try {
            repo = new GerritRepository(this.workingCopy.getServerURI());
            if (!repo.getHostname().isEmpty()) {
                connexionSuccesfull = repo.connect();
            }
        }
        catch (EGerritException eGerritException) {
            return false;
        }
        this.setProgress(monitor, 10);
        if (!connexionSuccesfull && repo.getStatus() == -1) {
            this.setProgress(monitor, 100);
            monitor.done();
            throw new EGerritException(String.valueOf(Messages.GerritServerDialog_16) + this.workingCopy.getServerURI() + Messages.GerritServerDialog_17);
        }
        if (!connexionSuccesfull && repo.getStatus() == -2) {
            this.setProgress(monitor, 100);
            monitor.done();
            throw new EGerritException(String.valueOf(Messages.GerritServerDialog_18) + this.workingCopy.getServerURI() + Messages.GerritServerDialog_19);
        }
        this.setProgress(monitor, 10);
        if (!connexionSuccesfull) {
            this.setProgress(monitor, 100);
            monitor.done();
            throw new EGerritException(String.valueOf(Messages.GerritServerDialog_20) + this.workingCopy.getServerURI() + Messages.GerritServerDialog_21 + this.INVALID_MESSAGE);
        }
        this.setProgress(monitor, 10);
        Version version = repo.getVersion();
        if (version.equals((Object)GerritRepository.NO_VERSION)) {
            this.setProgress(monitor, 100);
            monitor.done();
            throw new EGerritException(String.valueOf(Messages.GerritServerDialog_22) + GerritFactory.MINIMAL_VERSION + Messages.GerritServerDialog_23);
        }
        if (version.compareTo(GerritFactory.MINIMAL_VERSION) < 0) {
            this.setProgress(monitor, 100);
            monitor.done();
            throw new EGerritException(String.valueOf(Messages.GerritServerDialog_24) + this.workingCopy.getServerURI() + Messages.GerritServerDialog_25 + repo.getVersion() + Messages.GerritServerDialog_26 + GerritFactory.MINIMAL_VERSION + Messages.GerritServerDialog_27);
        }
        this.setProgress(monitor, 10);
        if (this.workingCopy != null) {
            String password = this.workingCopy.getPassword();
            if (this.workingCopy.isPasswordProvided()) {
                if (this.workingCopy.isPasswordChanged()) {
                    password = this.workingCopy.getPassword();
                } else {
                    password = this.original.getPassword();
                    this.workingCopy.setPassword(password);
                }
            }
            repo.setCredentials(new GerritCredentials(this.workingCopy.getUserName(), password));
        }
        this.setProgress(monitor, 10);
        if (!repo.getHostname().isEmpty() && !(connexionSuccesfull = repo.connect())) {
            boolean bo = true;
            if (this.workingCopy != null) {
                this.workingCopy.setSelfSigned(bo);
            }
            repo.acceptSelfSignedCerts(bo);
            connexionSuccesfull = repo.connect();
        }
        this.setProgress(monitor, 10);
        if (repo.getHttpClient() == null) {
            this.setProgress(monitor, 100);
            monitor.done();
            String value = this.workingCopy == null ? "" : this.workingCopy.getServerURI();
            throw new EGerritException(String.valueOf(Messages.GerritServerDialog_28) + value + Messages.GerritServerDialog_29);
        }
        return connexionSuccesfull;
    }

    private Boolean validateURL(IProgressMonitor monitor) throws URISyntaxException {
        Boolean b = true;
        this.setProgress(monitor, 10);
        if (this.workingCopy != null) {
            if (!this.workingCopy.isValid()) {
                b = false;
            }
        } else {
            b = false;
        }
        return b;
    }

    public GerritServerInformation getServerInfo() {
        return this.workingCopy;
    }
}

