/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.model;

import java.util.Arrays;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egerrit.internal.dashboard.ui.GerritUi;
import org.eclipse.egerrit.internal.dashboard.ui.commands.table.AdjustMyStarredHandler;
import org.eclipse.egerrit.internal.dashboard.ui.model.ModifiedModelItemProviderAdapterFactory;
import org.eclipse.egerrit.internal.dashboard.ui.model.ReviewTableDefinition;
import org.eclipse.egerrit.internal.dashboard.ui.model.ReviewTableSorter;
import org.eclipse.egerrit.internal.dashboard.ui.views.GerritTableView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIReviewTable {
    private final String DASHBOARD_CONTEXT_MENU = "org.eclipse.egerrit.dashboard.contextMenu";
    private static final String EGERRIT_DASHBOARD = "egerrit.dashboard";
    private static final String VIEW_COLUMN_ORDER = "egerritViewColumnOrder";
    private static final String VIEW_COLUMN_WIDTH = "egerritViewColumnWidth";
    private static Logger logger = LoggerFactory.getLogger(UIReviewTable.class);
    private final int TABLE_STYLE = 66304;
    private TableViewer fViewer;
    private ComposedAdapterFactory adapterFactory;
    private AdapterFactoryLabelProvider.ColorProvider labelProvider;
    private AdapterFactoryContentProvider contentProvider;
    private final Listener mouseButtonListener = new Listener(){

        public void handleEvent(Event aEvent) {
            logger.debug("mouseButtonListener() for " + aEvent.button);
            switch (aEvent.type) {
                case 3: {
                    if (aEvent.button == 1) {
                        Point p = new Point(aEvent.x, aEvent.y);
                        ViewerCell viewerCell = UIReviewTable.this.fViewer.getCell(p);
                        if (viewerCell != null && viewerCell.getColumnIndex() == ReviewTableDefinition.STARRED.ordinal()) {
                            AdjustMyStarredHandler handler = new AdjustMyStarredHandler();
                            try {
                                handler.execute(new ExecutionEvent());
                            }
                            catch (ExecutionException excutionException) {
                                logger.error(excutionException.getMessage());
                            }
                        }
                    }
                    int cfr_ignored_0 = aEvent.button;
                    int cfr_ignored_1 = aEvent.button;
                    break;
                }
            }
        }
    };

    public Composite createTableViewerSection(Composite aParent) {
        Composite viewerForm = new Composite(aParent, 2064);
        viewerForm.setLayout((Layout)new FillLayout());
        this.fViewer = new TableViewer(viewerForm, 66304);
        this.fViewer = this.buildAndLayoutTable(this.fViewer);
        this.fViewer.getTable().addDisposeListener(e -> this.storeColumnsSettings());
        this.adapterFactory = new ComposedAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ModifiedModelItemProviderAdapterFactory());
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory);
        this.fViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new AdapterFactoryLabelProvider.ColorProvider((AdapterFactory)this.adapterFactory, null, null);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        ReviewTableSorter.bind(this.fViewer);
        this.fViewer.setComparator((ViewerComparator)new ReviewTableSorter(7));
        this.fViewer.getTable().addListener(3, this.mouseButtonListener);
        return viewerForm;
    }

    private TableViewer buildAndLayoutTable(TableViewer aViewer) {
        final Table table = aViewer.getTable();
        ReviewTableDefinition[] tableInfo = ReviewTableDefinition.values();
        int size = tableInfo.length;
        logger.debug("Table\tName\tWidth\tResize Moveable");
        int index = 0;
        while (index < size) {
            logger.debug("index [ " + index + " ] " + tableInfo[index].getName() + "\t: " + tableInfo[index].getWidth() + "\t: " + tableInfo[index].getResize() + "\t: " + tableInfo[index].getMoveable());
            this.createTableViewerColumn(tableInfo[index]);
            ++index;
        }
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                table.setRedraw(false);
                Point parentSize = table.getParent().getSize();
                int minimumTableWidth = ReviewTableDefinition.getMinimumWidth();
                int mimimumSubjectWidth = ReviewTableDefinition.SUBJECT.getWidth();
                int minProjectWidth = ReviewTableDefinition.PROJECT.getWidth();
                int scrollWidth = table.getVerticalBar().getSize().x;
                if (!table.getVerticalBar().isVisible()) {
                    scrollWidth = 0;
                }
                int computeExtraWidth = parentSize.x - 10 - minimumTableWidth - scrollWidth;
                int newSubjectWidth = mimimumSubjectWidth;
                int newProjectWidth = minProjectWidth;
                if (computeExtraWidth > 0) {
                    int value = 2 * computeExtraWidth / 3;
                    newSubjectWidth = mimimumSubjectWidth + value;
                    newProjectWidth = minProjectWidth + computeExtraWidth - value;
                }
                table.getColumn(ReviewTableDefinition.SUBJECT.ordinal()).setWidth(newSubjectWidth);
                table.getColumn(ReviewTableDefinition.PROJECT.ordinal()).setWidth(newProjectWidth);
                table.setRedraw(true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        String os = Platform.getOS();
        if (!"win32".equals(os)) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            final ToolTip tip = new ToolTip(shell, 2);
            table.addListener(5, new Listener(){

                public void handleEvent(Event event) {
                    tip.setVisible(false);
                }
            });
            table.addListener(32, new Listener(){

                public void handleEvent(Event event) {
                    Point pt = new Point(event.x, event.y);
                    ViewerCell viewerCell = UIReviewTable.this.fViewer.getCell(pt);
                    if (viewerCell != null) {
                        int columnIndex = viewerCell.getColumnIndex();
                        TableItem item = (TableItem)viewerCell.getViewerRow().getItem();
                        Rectangle rect = item.getBounds(columnIndex);
                        if (rect.contains(pt)) {
                            tip.setMessage(item.getText(columnIndex));
                            Point displayPos = item.getParent().toDisplay(rect.x, rect.y);
                            tip.setLocation(displayPos.x, displayPos.y);
                            tip.setVisible(true);
                        }
                    }
                }
            });
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        MenuManager menuManager = new MenuManager();
        Menu contextMenu = menuManager.createContextMenu((Control)table);
        table.setMenu(contextMenu);
        GerritTableView.getActiveView(true).getSite().registerContextMenu("org.eclipse.egerrit.dashboard.contextMenu", menuManager, (ISelectionProvider)aViewer);
        this.restoreColumnsSettings();
        return aViewer;
    }

    private TableViewerColumn createTableViewerColumn(ReviewTableDefinition aTableInfo) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(aTableInfo.getName());
        column.setWidth(aTableInfo.getWidth());
        column.setAlignment(aTableInfo.getAlignment());
        column.setResizable(aTableInfo.getResize());
        column.setMoveable(aTableInfo.getMoveable());
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
    }

    private void storeColumnsSettings() {
        if (this.fViewer == null) {
            return;
        }
        int[] columnOrder = this.fViewer.getTable().getColumnOrder();
        int[] columnWidth = new int[10];
        int i2 = 0;
        while (i2 < 10) {
            columnWidth[i2] = this.fViewer.getTable().getColumn(i2).getWidth();
            ++i2;
        }
        this.getDialogSettings().put(VIEW_COLUMN_ORDER, (String[])Arrays.stream(columnOrder).mapToObj(i -> String.valueOf(i)).toArray(String[]::new));
        this.getDialogSettings().put(VIEW_COLUMN_WIDTH, (String[])Arrays.stream(columnWidth).mapToObj(i -> String.valueOf(i)).toArray(String[]::new));
    }

    private void restoreColumnsSettings() {
        if (this.fViewer == null) {
            return;
        }
        String[] backedUpValue = this.getDialogSettings().getArray(VIEW_COLUMN_ORDER);
        if (backedUpValue == null) {
            return;
        }
        int[] columnOrder = Arrays.stream(backedUpValue).mapToInt(Integer::parseInt).toArray();
        this.fViewer.getTable().setColumnOrder(columnOrder);
        backedUpValue = this.getDialogSettings().getArray(VIEW_COLUMN_WIDTH);
        if (backedUpValue == null) {
            return;
        }
        int[] columnWidth = Arrays.stream(backedUpValue).mapToInt(Integer::parseInt).toArray();
        int i = 0;
        while (i < 10) {
            this.fViewer.getTable().getColumn(i).setWidth(columnWidth[i]);
            ++i;
        }
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = GerritUi.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(EGERRIT_DASHBOARD);
        if (section == null) {
            section = settings.addNewSection(EGERRIT_DASHBOARD);
        }
        return section;
    }
}

