/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.CommitInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.ui.compare.CommentAnnotationPainter;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.CompareItemFactory;
import org.eclipse.egerrit.internal.ui.compare.CompareUpperSection;
import org.eclipse.egerrit.internal.ui.compare.EditionLimiter;
import org.eclipse.egerrit.internal.ui.compare.EmptyTypedElement;
import org.eclipse.egerrit.internal.ui.compare.GerritCompareInputLabelProvider;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.compare.OrphanedFileInfo;
import org.eclipse.egerrit.internal.ui.compare.PatchSetCompareItem;
import org.eclipse.egerrit.internal.ui.compare.UICompareUtils;
import org.eclipse.egerrit.internal.ui.editors.OpenCompareEditor;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WeakInterningHashSet;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritMultipleInput
extends SaveableCompareEditorInput {
    private static Logger logger = LoggerFactory.getLogger(GerritMultipleInput.class);
    public static final String WORKSPACE = "WORKSPACE";
    public static final String BASE = "BASE";
    private GerritDiffNode root;
    private ChangeInfo changeInfo;
    private FileInfo fileToReveal;
    DiffNode nodeToReveal;
    private String leftSide;
    private String rightSide;
    GerritClient gerritClient;
    private byte problemSavingChanges = (byte)-1;
    private Runnable postSaveListener;
    private int call = 6;
    private WeakInterningHashSet<SourceViewer> decoratedViewers = new WeakInterningHashSet(3);
    private CompareUpperSection upperSection;

    public GerritMultipleInput(String leftSide, String rightSide, ChangeInfo changeInfo, GerritClient gerrit, FileInfo toReveal) {
        super(GerritMultipleInput.initConfiguration(), null);
        Assert.isNotNull((Object)leftSide);
        Assert.isNotNull((Object)rightSide);
        Assert.isNotNull((Object)changeInfo);
        this.leftSide = leftSide;
        this.rightSide = rightSide;
        this.changeInfo = changeInfo;
        this.fileToReveal = toReveal;
        this.gerritClient = gerrit;
        this.root = new GerritDiffNode(0){

            @Override
            public String getName() {
                return GerritMultipleInput.this.getName();
            }

            public boolean hasChildren() {
                return true;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }
        };
    }

    private static CompareConfiguration initConfiguration() {
        CompareConfiguration config = new CompareConfiguration();
        config.setDefaultLabelProvider((ICompareInputLabelProvider)new GerritCompareInputLabelProvider());
        return config;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.resetRoot();
        this.nodeToReveal = null;
        if (this.leftSide.equals(this.rightSide)) {
            return this.root;
        }
        if (this.leftSide.equals(BASE) && this.rightSide.equals(WORKSPACE) || this.leftSide.equals(WORKSPACE) && this.rightSide.equals(BASE)) {
            this.compareWorkspaceWithBase(monitor);
        } else if (this.leftSide.equals(BASE) || this.rightSide.equals(BASE)) {
            this.compareRevisionWithBase(monitor);
        } else if (this.leftSide.equals(WORKSPACE) || this.rightSide.equals(WORKSPACE)) {
            this.compareRevisionWithWorkspace(monitor);
        } else {
            this.compareRevisions(monitor);
        }
        return this.root;
    }

    private void compareWorkspaceWithBase(IProgressMonitor monitor) {
        this.loadRevision(this.changeInfo.getRevision().getId());
        RevisionInfo rightRevision = (RevisionInfo)this.changeInfo.getRevisions().get((Object)this.changeInfo.getRevision().getId());
        for (FileInfo rightFile : rightRevision.getFiles().values()) {
            GerritDiffNode node = this.createBaseWorkspaceNode(monitor, rightFile);
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, rightFile);
        }
    }

    void switchInputs(String left, String right) {
        try {
            if (left == null && this.rightSide.equals(right)) {
                return;
            }
            if (right == null && this.leftSide.equals(left)) {
                return;
            }
            Object selectedElement = this.getSelectedEdition();
            if (selectedElement != null) {
                this.fileToReveal = ((GerritDiffNode)((Object)selectedElement)).getFileInfo();
            }
            if (left != null) {
                this.leftSide = left;
            }
            if (right != null) {
                this.rightSide = right;
            }
            this.prepareInput((IProgressMonitor)new NullProgressMonitor());
            this.upperSection.setInput((Object)this.root);
        }
        catch (InterruptedException | InvocationTargetException e) {
            logger.error("Problem while switching input to " + left + " " + right, (Throwable)e);
        }
    }

    public void resetRoot() {
        IDiffElement[] children;
        IDiffElement[] iDiffElementArray = children = this.root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement child = iDiffElementArray[n2];
            this.root.remove(child);
            ++n2;
        }
    }

    private void compareRevisions(IProgressMonitor monitor) {
        this.loadRevision(this.leftSide);
        this.loadRevision(this.rightSide);
        Map<String, FileInfo> files = this.loadRevisionDiff(this.leftSide, this.rightSide);
        for (Map.Entry<String, FileInfo> file : files.entrySet()) {
            GerritDiffNode node = this.createRevisionRevisionNode(monitor, (RevisionInfo)this.changeInfo.getRevisions().get((Object)this.leftSide), (RevisionInfo)this.changeInfo.getRevisions().get((Object)this.rightSide), file.getValue(), file.getKey());
            if (node == null) continue;
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, node.getFileInfo());
        }
    }

    private Map<String, FileInfo> loadRevisionDiff(String referenceRevision, String base) {
        HashMap files = null;
        try {
            files = (HashMap)this.gerritClient.getFilesModifiedSince(this.changeInfo.getId(), referenceRevision, base).call();
        }
        catch (EGerritException e) {
            logger.debug("An exception occurred while getting the diff between revision " + referenceRevision + " and " + base, (Throwable)e);
            files = new HashMap();
        }
        return files;
    }

    private GerritDiffNode createRevisionRevisionNode(IProgressMonitor monitor, RevisionInfo leftRevision, RevisionInfo rightRevision, FileInfo fileToShow, String filePathToShow) {
        int differenceKind = this.getDifferenceFlag(fileToShow);
        GerritDiffNode node = new GerritDiffNode(differenceKind);
        node.setDiffFileInfo(fileToShow);
        ITypedElement leftFile = null;
        ITypedElement rightFile = null;
        switch (differenceKind) {
            case 17: {
                node.setFileInfo((FileInfo)rightRevision.getFiles().get((Object)filePathToShow));
                FileInfo potentialLeft = (FileInfo)leftRevision.getFiles().get((Object)filePathToShow);
                if (potentialLeft == null) {
                    leftFile = new EmptyTypedElement(filePathToShow);
                    rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)rightRevision.getFiles().get((Object)filePathToShow), monitor);
                    break;
                }
                leftFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)leftRevision.getFiles().get((Object)filePathToShow), monitor);
                rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)rightRevision.getFiles().get((Object)filePathToShow), monitor);
                break;
            }
            case 128: 
            case 256: {
                String baseCommitId;
                OrphanedFileInfo o;
                if (leftRevision.getFiles().get((Object)fileToShow.getOld_path()) != null) {
                    leftFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)leftRevision.getFiles().get((Object)fileToShow.getOld_path()), monitor);
                } else {
                    o = new OrphanedFileInfo();
                    o.setFilePath(fileToShow.getOld_path());
                    o.setRevisionInfo(leftRevision);
                    baseCommitId = this.getBaseCommitId((FileInfo)o);
                    leftFile = baseCommitId != null ? new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(this.changeInfo.getProject(), baseCommitId, (FileInfo)o, fileToShow.getOld_path(), monitor) : new EmptyTypedElement(fileToShow.getOld_path());
                }
                if (rightRevision.getFiles().get((Object)filePathToShow) != null) {
                    rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)rightRevision.getFiles().get((Object)filePathToShow), monitor);
                    node.setFileInfo((FileInfo)rightRevision.getFiles().get((Object)filePathToShow));
                    break;
                }
                o = new OrphanedFileInfo();
                o.setFilePath(filePathToShow);
                o.setOld_path(fileToShow.getOld_path());
                o.setRevisionInfo(rightRevision);
                o.setStatus(fileToShow.getStatus());
                o.setReviewed(fileToShow.isReviewed());
                baseCommitId = this.getBaseCommitId((FileInfo)o);
                if (baseCommitId != null) {
                    rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(this.changeInfo.getProject(), baseCommitId, (FileInfo)o, filePathToShow, monitor);
                    node.setFileInfo((FileInfo)o);
                    break;
                }
                rightFile = new EmptyTypedElement(filePathToShow);
                break;
            }
            case 67: {
                leftFile = leftRevision.getFiles().get((Object)filePathToShow) == null ? new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(this.changeInfo.getProject(), this.getBaseCommitId(leftRevision), (FileInfo)rightRevision.getFiles().get((Object)filePathToShow), null, Integer.toString(leftRevision.get_number()), monitor) : new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)leftRevision.getFiles().get((Object)filePathToShow), monitor);
                if (rightRevision.getFiles().get((Object)filePathToShow) == null) {
                    rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(this.changeInfo.getProject(), this.getBaseCommitId(rightRevision), (FileInfo)leftRevision.getFiles().get((Object)filePathToShow), null, Integer.toString(rightRevision.get_number()), monitor);
                    node.setFileInfo((FileInfo)leftRevision.getFiles().get((Object)filePathToShow));
                    break;
                }
                rightFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)rightRevision.getFiles().get((Object)filePathToShow), monitor);
                node.setFileInfo((FileInfo)rightRevision.getFiles().get((Object)filePathToShow));
                break;
            }
            case 34: {
                leftFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(filePathToShow, this.changeInfo.getId(), (FileInfo)leftRevision.getFiles().get((Object)filePathToShow), monitor);
                rightFile = new EmptyTypedElement(filePathToShow);
                node.setFileInfo((FileInfo)leftRevision.getFiles().get((Object)filePathToShow));
                break;
            }
            default: {
                return null;
            }
        }
        node.setLeft(leftFile);
        node.setRight(rightFile);
        return node;
    }

    private int getDifferenceFlag(FileInfo file) {
        switch (file.getStatus()) {
            case "A": {
                return 17;
            }
            case "D": {
                return 34;
            }
            case "M": {
                return 67;
            }
            case "C": {
                return 256;
            }
            case "W": {
                return 512;
            }
            case "R": {
                return 128;
            }
        }
        return 67;
    }

    private void compareRevisionWithWorkspace(IProgressMonitor monitor) {
        boolean workspaceOnRight = this.rightSide.equals(WORKSPACE);
        this.loadRevision(workspaceOnRight ? this.leftSide : this.rightSide);
        RevisionInfo filesToShow = (RevisionInfo)this.changeInfo.getRevisions().get((Object)(workspaceOnRight ? this.leftSide : this.rightSide));
        for (FileInfo file : filesToShow.getFiles().values()) {
            GerritDiffNode node = this.createWorkspaceRevisionNode(monitor, file);
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, file);
        }
    }

    private void loadRevision(String revision) {
        QueryHelpers.loadFiles(this.gerritClient, (RevisionInfo)this.changeInfo.getRevisions().get((Object)revision));
        CompletableFuture.runAsync(() -> QueryHelpers.loadRevisionDetails(this.gerritClient, (RevisionInfo)this.changeInfo.getRevisions().get((Object)revision)));
    }

    private GerritDiffNode createWorkspaceRevisionNode(IProgressMonitor monitor, FileInfo file) {
        boolean workspaceOnRight = this.rightSide.equals(WORKSPACE);
        String fileName = file.getPath();
        GerritDiffNode node = new GerritDiffNode(this.getDifferenceFlag(file));
        node.setFileInfo(file);
        PatchSetCompareItem revisionFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(fileName, this.changeInfo.getId(), file, monitor);
        IFile workspaceFile = new OpenCompareEditor(this.gerritClient, this.changeInfo).getCorrespondingWorkspaceFile(file);
        if (workspaceFile == null) {
            workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("missing/" + fileName));
        }
        ITypedElement workspaceNode = GerritMultipleInput.createFileElement((IFile)workspaceFile);
        if (workspaceOnRight) {
            node.setRight(workspaceNode);
            node.setLeft(revisionFile);
        } else {
            node.setRight(revisionFile);
            node.setLeft(workspaceNode);
        }
        return node;
    }

    private void compareRevisionWithBase(IProgressMonitor monitor) {
        String revisionToCompareAgainst = this.leftSide.equals(BASE) ? this.rightSide : this.leftSide;
        this.loadRevision(revisionToCompareAgainst);
        RevisionInfo rightRevision = (RevisionInfo)this.changeInfo.getRevisions().get((Object)revisionToCompareAgainst);
        for (FileInfo rightFile : rightRevision.getFiles().values()) {
            GerritDiffNode node = this.createBaseRevisionNode(monitor, rightFile);
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, rightFile);
        }
    }

    private GerritDiffNode createBaseWorkspaceNode(IProgressMonitor monitor, FileInfo file) {
        String fileName = file.getPath();
        GerritDiffNode node = new GerritDiffNode(this.getDifferenceFlag(file));
        node.setFileInfo(file);
        IFile workspaceFile = new OpenCompareEditor(this.gerritClient, this.changeInfo).getCorrespondingWorkspaceFile(file);
        if (workspaceFile == null) {
            workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("missing/" + fileName));
        }
        ITypedElement workspaceElement = GerritMultipleInput.createFileElement((IFile)workspaceFile);
        String baseCommitId = this.getBaseCommitId(file);
        ITypedElement baseElement = null;
        baseElement = baseCommitId != null ? new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(this.changeInfo.getProject(), baseCommitId, file, monitor) : new EmptyTypedElement("");
        if (this.rightSide.equals(WORKSPACE)) {
            node.setRight(workspaceElement);
            node.setLeft(baseElement);
        } else {
            node.setRight(baseElement);
            node.setLeft(workspaceElement);
        }
        return node;
    }

    private GerritDiffNode createBaseRevisionNode(IProgressMonitor monitor, FileInfo file) {
        String fileName = file.getPath();
        GerritDiffNode node = new GerritDiffNode(this.getDifferenceFlag(file));
        node.setFileInfo(file);
        PatchSetCompareItem revisionElement = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(fileName, this.changeInfo.getId(), file, monitor);
        String baseCommitId = this.getBaseCommitId(file);
        ITypedElement baseElement = null;
        baseElement = baseCommitId != null ? new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(this.changeInfo.getProject(), baseCommitId, file, monitor) : new EmptyTypedElement("");
        if (this.leftSide.equals(BASE)) {
            node.setLeft(baseElement);
            node.setRight(revisionElement);
        } else {
            node.setLeft(revisionElement);
            node.setRight(baseElement);
        }
        return node;
    }

    private void setElementToReveal(GerritDiffNode node, FileInfo file) {
        if (this.fileToReveal == null) {
            return;
        }
        if (file.getPath().equals(this.fileToReveal.getPath())) {
            this.nodeToReveal = node;
            this.preloadNode(node);
        }
    }

    private void preloadNode(GerritDiffNode node) {
        if (node.getLeft() instanceof IStreamContentAccessor) {
            try {
                ((IStreamContentAccessor)node.getLeft()).getContents();
            }
            catch (CoreException e) {
                logger.debug("Problem preloading left", (Throwable)e);
            }
        }
        if (node.getRight() instanceof IStreamContentAccessor) {
            try {
                ((IStreamContentAccessor)node.getRight()).getContents();
            }
            catch (CoreException e) {
                logger.debug("Problem preloading right", (Throwable)e);
            }
        }
    }

    public String getTitle() {
        return String.valueOf(Messages.GerritMultipleInput_1) + this.changeInfo.get_number() + " - " + this.changeInfo.getSubject() + " -- " + this.getComparisonTitle();
    }

    private String getComparisonTitle() {
        String result = "";
        result = this.leftSide.equals(BASE) || this.leftSide.equals(WORKSPACE) ? String.valueOf(result) + this.leftSide : String.valueOf(result) + Messages.GerritMultipleInput_7 + ((RevisionInfo)this.changeInfo.getRevisions().get((Object)this.leftSide)).get_number();
        result = this.rightSide.equals(WORKSPACE) ? String.valueOf(result) + Messages.GerritMultipleInput_9 : (this.rightSide.equals(BASE) ? String.valueOf(result) + this.rightSide : String.valueOf(result) + Messages.GerritMultipleInput_10 + ((RevisionInfo)this.changeInfo.getRevisions().get((Object)this.rightSide)).get_number());
        return result;
    }

    private String getBaseCommitId(RevisionInfo revision) {
        EList parents = revision.getCommit().getParents();
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        return ((CommitInfo)parents.get(0)).getCommit();
    }

    private String getBaseCommitId(FileInfo fileInfo) {
        return this.getBaseCommitId(fileInfo.getRevision());
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer newViewer = super.findContentViewer(oldViewer, input, parent);
        if (oldViewer == newViewer) {
            return newViewer;
        }
        if (this.isCommentable(input.getLeft())) {
            this.setupCommentColorer(newViewer, 0);
        }
        if (this.isCommentable(input.getRight())) {
            this.setupCommentColorer(newViewer, 1);
        }
        UICompareUtils.insertAnnotationNavigationCommands((IToolBarManager)CompareViewerPane.getToolBarManager((Composite)parent));
        return newViewer;
    }

    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        if (input instanceof GerritDiffNode) {
            this.nodeToReveal = (GerritDiffNode)input;
        }
        return super.findStructureViewer(oldViewer, input, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetInputUponSelectionOfDetailedStructuralCompareSelected() {
        GerritMultipleInput gerritMultipleInput = this;
        synchronized (gerritMultipleInput) {
            --this.call;
            if (this.call == 0) {
                MessageDialog.openInformation(null, (String)Messages.UnsupportedInput_Title, (String)Messages.UnsupportedInput_Text);
                this.upperSection.setInput((Object)this.root);
                this.call = 6;
            }
        }
    }

    private boolean isCommentable(ITypedElement element) {
        return element instanceof CommentableCompareItem;
    }

    private void setupCommentColorer(Viewer contentViewer, int side) {
        if (!(contentViewer instanceof TextMergeViewer)) {
            return;
        }
        TextMergeViewer textMergeViewer = (TextMergeViewer)contentViewer;
        try {
            Class<TextMergeViewer> clazz = TextMergeViewer.class;
            Field declaredField = clazz.getDeclaredField(side == 0 ? "fLeft" : "fRight");
            declaredField.setAccessible(true);
            MergeSourceViewer rightSourceViewer = (MergeSourceViewer)declaredField.get(textMergeViewer);
            Field sourceViewerField = MergeSourceViewer.class.getDeclaredField("fSourceViewer");
            sourceViewerField.setAccessible(true);
            final SourceViewer sourceViewer = (SourceViewer)sourceViewerField.get(rightSourceViewer);
            if (this.decoratedViewers.contains((Object)sourceViewer)) {
                return;
            }
            this.decoratedViewers.add((Object)sourceViewer);
            final AnnotationPainter commentPainter = this.initializeCommentColoring((ISourceViewer)sourceViewer);
            sourceViewer.addTextInputListener(new ITextInputListener(){
                EditionLimiter editionLimiter;
                {
                    this.editionLimiter = new EditionLimiter((TextViewer)sourceViewer2);
                }

                public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                    sourceViewer.addTextPresentationListener((ITextPresentationListener)commentPainter);
                    sourceViewer.addPainter((IPainter)commentPainter);
                    sourceViewer.getTextWidget().addVerifyListener((VerifyListener)this.editionLimiter);
                    if (oldInput instanceof CommentableCompareItem) {
                        ((CommentableCompareItem)oldInput).reset();
                    }
                }

                public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                    if (oldInput != null) {
                        sourceViewer.removePainter((IPainter)commentPainter);
                        sourceViewer.addTextPresentationListener((ITextPresentationListener)commentPainter);
                        sourceViewer.getTextWidget().removeVerifyListener((VerifyListener)this.editionLimiter);
                    }
                }
            });
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException t) {
            logger.error("Problem while setting up coloration of comments", (Throwable)t);
        }
    }

    private AnnotationPainter initializeCommentColoring(ISourceViewer viewer) {
        return new CommentAnnotationPainter(viewer, null, this);
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        try {
            super.saveChanges(monitor);
            this.forceSaveWorkspaceFile(monitor);
        }
        catch (RuntimeException ex) {
            if (CommentableCompareItem.class.getName().equals(ex.getMessage())) {
                if (ex.getCause().getMessage().equals(((GerritDiffNode)((Object)this.getSelectedEdition())).getLeft())) {
                    this.problemSavingChanges = 0;
                    this.setLeftDirty(true);
                } else {
                    this.problemSavingChanges = 1;
                    this.setRightDirty(true);
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.egerrit.ui", Messages.GerritMultipleInput_11));
            }
            throw ex;
        }
        if (this.postSaveListener != null) {
            this.postSaveListener.run();
        }
    }

    private void forceSaveWorkspaceFile(IProgressMonitor monitor) throws CoreException {
        if (this.getSelectedEdition() != null) {
            ITypedElement forceright;
            ITypedElement forceLeft = ((GerritDiffNode)((Object)this.getSelectedEdition())).getLeft();
            if (forceLeft instanceof LocalResourceTypedElement) {
                ((LocalResourceTypedElement)forceLeft).commit(monitor);
            }
            if ((forceright = ((GerritDiffNode)((Object)this.getSelectedEdition())).getRight()) instanceof LocalResourceTypedElement) {
                ((LocalResourceTypedElement)forceright).commit(monitor);
            }
        }
    }

    public void setDirty(boolean dirty) {
        if (this.problemSavingChanges == 0) {
            super.setDirty(true);
            this.problemSavingChanges = (byte)-1;
            this.setLeftDirty(true);
        } else if (this.problemSavingChanges == 1) {
            super.setDirty(true);
            this.problemSavingChanges = (byte)-1;
            this.setRightDirty(true);
        } else {
            super.setDirty(dirty);
        }
    }

    public String getName() {
        if (this.fileToReveal != null && (StringToFileInfoImpl)this.fileToReveal.eContainer() != null) {
            return ((StringToFileInfoImpl)this.fileToReveal.eContainer()).getKey();
        }
        return "";
    }

    public void fireInputChange() {
        GerritDiffNode savedElement = (GerritDiffNode)((Object)this.getSelectedEdition());
        NullProgressMonitor pm = new NullProgressMonitor();
        GerritDiffNode newEntry = null;
        if (this.leftSide.equals(BASE) && this.rightSide.equals(WORKSPACE) || this.leftSide.equals(WORKSPACE) && this.rightSide.equals(BASE)) {
            newEntry = this.createBaseWorkspaceNode((IProgressMonitor)pm, savedElement.getFileInfo());
        } else if (this.leftSide.equals(BASE) || this.rightSide.equals(BASE)) {
            newEntry = this.createBaseRevisionNode((IProgressMonitor)pm, savedElement.getFileInfo());
        } else if (this.leftSide.equals(WORKSPACE) || this.rightSide.equals(WORKSPACE)) {
            newEntry = this.createWorkspaceRevisionNode((IProgressMonitor)pm, savedElement.getFileInfo());
        } else {
            this.loadRevision(this.leftSide);
            this.loadRevision(this.rightSide);
            newEntry = this.createRevisionRevisionNode((IProgressMonitor)pm, (RevisionInfo)this.changeInfo.getRevisions().get((Object)this.leftSide), (RevisionInfo)this.changeInfo.getRevisions().get((Object)this.rightSide), savedElement.getDiffFileInfo(), savedElement.getFileInfo().getPath());
        }
        if (newEntry != null) {
            savedElement.setRight(newEntry.getRight());
            savedElement.setLeft(newEntry.getLeft());
        }
        savedElement.fireChange();
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return null;
    }

    protected CompareViewerPane createStructureInputPane(Composite parent) {
        this.upperSection = new CompareUpperSection(parent, 0x800800, true, this);
        return this.upperSection;
    }

    public ChangeInfo getChangeInfo() {
        return this.changeInfo;
    }

    public String getLeftSide() {
        return this.leftSide;
    }

    public String getRightSide() {
        return this.rightSide;
    }

    public CompareUpperSection getUpperSection() {
        return this.upperSection;
    }
}

