/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.ui.editors.EGerritCommentMarkers;
import org.eclipse.egerrit.internal.ui.editors.QuickFixDeleteDraftComment;
import org.eclipse.egerrit.internal.ui.editors.QuickFixModifyDraft;
import org.eclipse.egerrit.internal.ui.editors.QuickFixReplyDoneToComment;
import org.eclipse.egerrit.internal.ui.editors.QuickFixReplyToComment;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class QuickFixer
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            boolean isDraft = (Boolean)marker.getAttribute(EGerritCommentMarkers.ATTR_IS_DRAFT);
            CommentInfo element = (CommentInfo)marker.getAttribute(EGerritCommentMarkers.ATTR_COMMENT_INFO);
            String truncatedMsg = UIUtils.formatMessageForQuickFix(element);
            String fullMessage = UIUtils.formatMessageForMarkerView(element, 0);
            if (isDraft) {
                return new IMarkerResolution[]{new QuickFixModifyDraft(String.valueOf(Messages.QuickFixer_0) + truncatedMsg, fullMessage), new QuickFixDeleteDraftComment(String.valueOf(Messages.QuickFixer_1) + truncatedMsg, fullMessage)};
            }
            if (element.getMessage().equalsIgnoreCase("done")) {
                return new IMarkerResolution[]{new QuickFixReplyToComment(String.valueOf(Messages.QuickFixer_3) + truncatedMsg, fullMessage)};
            }
            return new IMarkerResolution[]{new QuickFixReplyToComment(String.valueOf(Messages.QuickFixer_3) + truncatedMsg, fullMessage), new QuickFixReplyDoneToComment(String.valueOf(Messages.QuickFixer_5) + truncatedMsg, fullMessage)};
        }
        catch (CoreException coreException) {
            return new IMarkerResolution[0];
        }
    }

    public boolean hasResolutions(IMarker marker) {
        return true;
    }
}

