/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.ui.table.filter.AuthorKindFilter;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class HistoryTableMenuBuilder {
    private Menu commonMenu;
    private FilterSelectionAction humanOnlyfilter = null;
    private FilterSelectionAction machineOnlyfilter = null;

    public void addPulldownMenu(final ColumnViewer viewer, final GerritClient client) {
        MenuManager menuManager = new MenuManager();
        if (viewer instanceof TableViewer) {
            this.commonMenu = menuManager.createContextMenu((Control)((TableViewer)viewer).getTable());
            ((TableViewer)viewer).getTable().setMenu(this.commonMenu);
            this.humanOnlyfilter = new FilterSelectionAction(Messages.UIHistoryTable_0, (StructuredViewer)viewer, new AuthorKindFilter(false));
            this.machineOnlyfilter = new FilterSelectionAction(Messages.UIHistoryTable_1, (StructuredViewer)viewer, new AuthorKindFilter(true));
        }
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                HistoryTableMenuBuilder.this.addMenuItem(HistoryTableMenuBuilder.this.commonMenu, viewer, client);
            }
        });
        menuManager.update(true);
    }

    private void addMenuItem(Menu menu, ColumnViewer viewer, GerritClient client) {
        if (menu.getItemCount() == 0 && viewer instanceof TableViewer) {
            MenuManager menuMgr = new MenuManager();
            menuMgr.add((IAction)this.humanOnlyfilter);
            menuMgr.add((IAction)this.machineOnlyfilter);
            menuMgr.createContextMenu((Control)menu.getShell()).setVisible(true);
            menuMgr.add((IContributionItem)new Separator());
            menuMgr.add((IAction)new Action(Messages.UIHistoryTable_reset){

                public void run() {
                    HistoryTableMenuBuilder.this.humanOnlyfilter.setChecked(false);
                    HistoryTableMenuBuilder.this.humanOnlyfilter.run();
                    HistoryTableMenuBuilder.this.machineOnlyfilter.setChecked(false);
                    HistoryTableMenuBuilder.this.machineOnlyfilter.run();
                }
            });
        }
    }

    private class FilterSelectionAction
    extends Action {
        private ViewerFilter filterInstance;
        private StructuredViewer viewer;

        public FilterSelectionAction(String actionName, StructuredViewer viewer, AuthorKindFilter humanOnlyfilter) {
            super(actionName, 2);
            this.viewer = viewer;
            this.filterInstance = humanOnlyfilter;
        }

        public void run() {
            if (this.isChecked()) {
                this.viewer.addFilter(this.filterInstance);
            } else {
                this.viewer.removeFilter(this.filterInstance);
            }
        }
    }
}

