/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egerrit.internal.dashboard.ui.utils.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class UIUtils {
    private static final String EGERRIT_PREF = "org.eclipse.egerrit.prefs";
    private static final int TITLE_LENGTH = 75;

    private UIUtils() {
    }

    public static void showErrorDialog(String aMsg, String aReason) {
        ErrorDialog dialog = new ErrorDialog(null, Messages.UIUtils_dashboardInfo, aMsg, (IStatus)new Status(1, "org.eclipse.egerrit.dashboard.ui", 0, aReason, null), 1);
        Display.getDefault().syncExec(() -> {
            int n = dialog.open();
        });
    }

    public static void showNoServerMessage() {
        ErrorDialog dialog = new ErrorDialog(null, Messages.UIUtils_dashboardInfo, null, (IStatus)new Status(1, "org.eclipse.egerrit.dashboard.ui", Messages.UIUtils_configureMessage), 1);
        Display.getDefault().syncExec(() -> {
            int n = dialog.open();
        });
    }

    public static String quoteIfNeeded(String s) {
        if (!s.trim().matches("^\\S*$")) {
            if (s.endsWith(" ")) {
                return "\"" + s.trim() + "\" ";
            }
            return "\"" + s + "\"";
        }
        return s;
    }

    public static int showConfirmDialog(String key, Shell shell, String title, String value) {
        MessageDialogWithToggle dialog;
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(EGERRIT_PREF);
        Preferences editorPrefs = prefs.node(key);
        boolean choice = editorPrefs.getBoolean(key, false);
        if (choice) {
            return 256;
        }
        if (title.length() > 75) {
            title = title.substring(0, 72).concat("...");
        }
        if ((dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)title, (String)value, (String)Messages.UIUtils_dontShowAgain, (boolean)false, null, null)).getToggleState()) {
            editorPrefs.putBoolean(key, true);
            try {
                editorPrefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        return dialog.getReturnCode();
    }
}

