/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.commands.table;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egerrit.internal.dashboard.ui.commands.table.DashboardFactoryHandler;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.Utils;
import org.eclipse.egerrit.internal.model.ActionConstants;
import org.eclipse.egerrit.internal.model.ActionInfo;
import org.eclipse.egerrit.internal.process.SubmitProcess;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.menus.UIElement;

public class SubmitHandler
extends DashboardFactoryHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.getChangeInfo() != null && this.getGerritClient() != null) {
            ActionInfo submitInfo = this.getRevisionAction(ActionConstants.SUBMIT.getName());
            if (submitInfo != null && submitInfo.isEnabled()) {
                SubmitProcess submitProcess = new SubmitProcess();
                submitProcess.handleSubmit(this.getChangeInfo(), this.getGerritClient());
            } else {
                Utils.displayInformation(null, Messages.SubmitHandler_title, NLS.bind((String)Messages.SubmitHandler_notAvailable, (Object)this.getChangeInfo().getSubject()));
            }
        }
        return null;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        boolean state = true;
        ActionInfo submitInfo = this.getRevisionAction(ActionConstants.SUBMIT.getName());
        state = submitInfo != null && submitInfo.isEnabled();
        this.setBaseEnabled(state);
    }

    @Override
    public void updateElement(UIElement element, Map parameters) {
        super.updateElement(element, parameters);
        String message = Messages.SubmitHandler_generalMessage;
        if (this.getChangeInfo() != null && this.getGerritClient() != null) {
            message = NLS.bind((String)Messages.SubmitHandler_specificMessage, (Object[])new Object[]{this.getChangeInfo().get_number(), this.getLatestRevision().get_number(), this.getChangeInfo().getBranch()});
        }
        element.setTooltip(message);
    }
}

