/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.egf.model.pattern.AbstractPatternCall;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.Activator;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationHelper {
    public void translate(Set<Pattern> patterns) throws PatternException {
        if (patterns.isEmpty()) {
            return;
        }
        this.translate(this.getOrderedList(patterns));
    }

    public void translate(List<Pattern> patterns) throws PatternException {
        if (patterns.isEmpty()) {
            return;
        }
        try {
            for (Pattern p : patterns) {
                PatternExtension extension = ExtensionHelper.getExtension(p.getNature());
                String reason = extension.canTranslate(p);
                if (reason == null) {
                    extension.createEngine(p).translate();
                    continue;
                }
                Activator.getDefault().logWarning(Messages.bind((String)Messages.assembly_error3, (Object)p.getName(), (Object)reason));
            }
        }
        catch (ExtensionHelper.MissingExtensionException e) {
            throw new PatternException((Throwable)e);
        }
    }

    private List<Pattern> getOrderedList(Set<Pattern> patterns) {
        ArrayList<Pattern> result = new ArrayList<Pattern>(patterns.size());
        HashSet<Pattern> visited = new HashSet<Pattern>(100);
        for (Pattern p : patterns) {
            this.addRequirements(p, result, patterns, visited);
        }
        visited.clear();
        return result;
    }

    private void addRequirements(Pattern pattern, List<Pattern> result, Set<Pattern> allPatterns, Set<Pattern> visited) {
        if (visited.contains(pattern)) {
            return;
        }
        visited.add(pattern);
        Pattern superPattern = pattern.getSuperPattern();
        if (superPattern != null) {
            this.addRequirements(superPattern, result, allPatterns, visited);
        }
        for (Call call : pattern.getOrchestration()) {
            if (!(call instanceof AbstractPatternCall)) continue;
            this.addRequirements(((AbstractPatternCall)call).getCalled(), result, allPatterns, visited);
        }
        if (allPatterns.contains(pattern)) {
            result.add(pattern);
        }
    }
}

