/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.commands;

import org.eclipse.egf.model.editor.l10n.ModelEditorMessages;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.FcoreFactory;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.fcore.InvocationContractContainer;
import org.eclipse.egf.model.fprod.FprodFactory;
import org.eclipse.egf.model.fprod.FprodPackage;
import org.eclipse.egf.model.fprod.ProductionPlan;
import org.eclipse.egf.model.fprod.ProductionPlanInvocation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public final class InvokeActivityCommand
extends CompoundCommand {
    protected static final String LABEL = ModelEditorMessages._UI_InvokeCommand_label;
    protected static final String DESCRIPTION = ModelEditorMessages._UI_InvokeCommand_description;
    private EditingDomain _editingDomain;
    private ProductionPlan _productionPlan;
    private Activity _activity;

    public InvokeActivityCommand(EditingDomain editingDomain, ProductionPlan productionPlan, Activity activity) {
        this(LABEL, DESCRIPTION, editingDomain, productionPlan, activity);
    }

    public InvokeActivityCommand(String label, String description, EditingDomain editingDomain, ProductionPlan productionPlan, Activity activity) {
        super(label, description);
        this._editingDomain = editingDomain;
        this._productionPlan = productionPlan;
        this._activity = activity;
    }

    protected boolean prepare() {
        if (this._productionPlan == null || this._productionPlan.getInvocations() == null || this._activity == null) {
            return false;
        }
        ProductionPlanInvocation invocation = FprodFactory.eINSTANCE.createProductionPlanInvocation();
        invocation.setInvokedActivity(this._activity);
        if (this._activity.getContracts() != null && this._activity.getContracts().size() > 0) {
            InvocationContractContainer container = FcoreFactory.eINSTANCE.createInvocationContractContainer();
            invocation.setInvocationContractContainer(container);
            for (Contract contract : this._activity.getContracts()) {
                InvocationContract innerContract = FcoreFactory.eINSTANCE.createInvocationContract();
                innerContract.setInvokedContract(contract);
                container.getInvocationContracts().add((Object)innerContract);
            }
        }
        this.append((Command)new AddCommand(this._editingDomain, (EObject)this._productionPlan, (EStructuralFeature)FprodPackage.Literals.PRODUCTION_PLAN__INVOCATIONS, (Object)invocation));
        return super.prepare();
    }
}

