/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.pages;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.ui.ImageShop;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.PatternUIHelper;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.adapter.LiveValidationContentAdapter;
import org.eclipse.egf.pattern.ui.editors.dialogs.ContainerLibrarySelectionDialog;
import org.eclipse.egf.pattern.ui.editors.pages.PatternEditorPage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class OverviewPage
extends PatternEditorPage {
    public static final String ID = "OverviewPage";
    private FormEditor editor;
    private Text nameText;
    private Text fullNameText;
    private Text descripition;
    private Button browse;
    private FormColors colors = new FormColors(Display.getDefault());
    private LiveValidationContentAdapter patternNameEmpetyValidationAdapter;
    private IMessageManager mmng;

    public OverviewPage(FormEditor editor) {
        super(editor, ID, Messages.OverviewPage_title);
        this.editor = editor;
    }

    protected void doCreateFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        this.mmng = managedForm.getMessageManager();
        GridLayout gridLayout = new GridLayout();
        form.getBody().setLayout((Layout)gridLayout);
        form.setImage(ImageShop.get("/icons/plugin_mf_obj.gif"));
        form.setText(Messages.OverviewPage_title);
        Composite container = toolkit.createComposite(form.getBody(), 0);
        gridLayout = new GridLayout(2, true);
        container.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        container.setFocus();
        this.createLeftContainer(toolkit, container);
        this.createRightContainer(toolkit, container);
        this.createDescriContainer(toolkit, container);
        this.checkReadOnlyModel();
        form.reflow(true);
    }

    private void checkReadOnlyModel() {
        PatternEditorInput editorInput = (PatternEditorInput)this.getEditorInput();
        if (!editorInput.isReadOnly()) {
            return;
        }
        this.nameText.setEnabled(false);
        this.fullNameText.setEnabled(false);
        this.descripition.setEnabled(false);
        this.browse.setEnabled(false);
    }

    private void createLeftContainer(FormToolkit toolkit, Composite container) {
        Section sectionLeft = toolkit.createSection(container, 256);
        sectionLeft.setText(Messages.OverviewPage_sectionLeft_title);
        GridData gd = new GridData(770);
        gd.minimumWidth = 300;
        gd.heightHint = 200;
        sectionLeft.setLayoutData((Object)gd);
        Composite containerLeft = toolkit.createComposite((Composite)sectionLeft, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        containerLeft.setLayout((Layout)gridLayout);
        gd = new GridData(1810);
        containerLeft.setLayoutData((Object)gd);
        String titletext = Messages.OverviewPage_sectionLeft_title_label;
        Label title = toolkit.createLabel(containerLeft, titletext, 64);
        gd = new GridData(768);
        gd.widthHint = 20;
        gd.horizontalSpan = 2;
        title.setLayoutData((Object)gd);
        this.createPatternInfoContainer(toolkit, containerLeft);
        sectionLeft.setClient((Control)containerLeft);
    }

    private void createPatternInfoContainer(FormToolkit toolkit, Composite containerLeft) {
        Composite patternInfo = toolkit.createComposite(containerLeft, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        patternInfo.setLayout((Layout)gridLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        patternInfo.setLayoutData((Object)gd);
        Label nameLabel = toolkit.createLabel(patternInfo, Messages.OverviewPage_sectionLeft_name_label, 64);
        gd = new GridData();
        gd.widthHint = 80;
        nameLabel.setLayoutData((Object)gd);
        nameLabel.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        this.nameText = toolkit.createText(patternInfo, this.getPattern() == null ? "" : this.getPattern().getName(), 2048);
        gd = new GridData(768);
        gd.widthHint = 20;
        gd.horizontalIndent = 5;
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        Label fullNameLabel = toolkit.createLabel(patternInfo, Messages.OverviewPage_sectionLeft_fullName_label, 64);
        gd = new GridData();
        gd.widthHint = 80;
        fullNameLabel.setLayoutData((Object)gd);
        fullNameLabel.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        Color color = Display.getDefault().getSystemColor(16);
        String fullName = PatternHelper.getFullLibraryName((Pattern)this.getPattern());
        this.fullNameText = toolkit.createText(patternInfo, PatternHelper.getFullLibraryName((Pattern)this.getPattern()), 2056);
        gd = new GridData(768);
        gd.horizontalIndent = 5;
        this.fullNameText.setLayoutData((Object)gd);
        this.fullNameText.setForeground(color);
        this.fullNameText.setText(fullName == null ? "" : fullName);
        this.browse = toolkit.createButton(patternInfo, Messages.OverviewPage_button_browse, 8);
        gd = new GridData();
        gd.widthHint = 65;
        this.browse.setLayoutData((Object)gd);
        this.browse.setEnabled(false);
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContainerLibrarySelectionDialog dialog = new ContainerLibrarySelectionDialog(new Shell(), OverviewPage.this.getPattern().getContainer());
                dialog.setTitle(Messages.OverviewPage_browse_dialog_title);
                if (dialog.open() == 0) {
                    final PatternLibrary patternLibrary = dialog.getLibraryContainer();
                    TransactionalEditingDomain editingDomain = OverviewPage.this.getEditingDomain();
                    RecordingCommand cmd = new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            Pattern pattern = OverviewPage.this.getPattern();
                            pattern.setContainer(patternLibrary);
                        }
                    };
                    editingDomain.getCommandStack().execute((Command)cmd);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label idLabel = toolkit.createLabel(patternInfo, Messages.OverviewPage_sectionLeft_id_label, 64);
        gd = new GridData();
        idLabel.setLayoutData((Object)gd);
        idLabel.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        Text idText = toolkit.createText(patternInfo, this.getPattern() == null ? "" : this.getPattern().getID(), 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 20;
        gd.horizontalIndent = 5;
        idText.setLayoutData((Object)gd);
        idText.setForeground(color);
    }

    private void createDescriContainer(FormToolkit toolkit, Composite container) {
        Composite containerDesci = toolkit.createComposite(container, 0);
        GridLayout gridLayout = new GridLayout();
        containerDesci.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        containerDesci.setLayoutData((Object)gd);
        Label title = toolkit.createLabel(containerDesci, Messages.OverviewPage_sectionLeft_descripition_label, 64);
        gd = new GridData();
        gd.verticalIndent = 0;
        title.setLayoutData((Object)gd);
        title.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        Label desciLabel = toolkit.createLabel(containerDesci, Messages.OverviewPage_sectionLeft_desci_label, 64);
        desciLabel.setLayoutData((Object)new GridData(768));
        String patternDescripition = this.getPattern() == null ? "" : this.getPattern().getDescription();
        this.descripition = toolkit.createText(containerDesci, patternDescripition, 2880);
        gd = new GridData(1808);
        gd.heightHint = 280;
        gd.widthHint = 280;
        gd.verticalIndent = 7;
        gd.horizontalIndent = 3;
        this.descripition.setLayoutData((Object)gd);
    }

    private void createRightContainer(FormToolkit toolkit, Composite container) {
        Section sectionRight = toolkit.createSection(container, 256);
        sectionRight.setText(Messages.OverviewPage_sectionRight_title);
        GridData gd = new GridData(770);
        gd.minimumWidth = 300;
        gd.heightHint = 200;
        sectionRight.setLayoutData((Object)gd);
        Composite containerRight = toolkit.createComposite((Composite)sectionRight, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        containerRight.setLayout((Layout)gridLayout);
        gd = new GridData(1810);
        gd.verticalIndent = 0;
        containerRight.setLayoutData((Object)gd);
        String titletext = Messages.OverviewPage_sectionRight_title_label;
        Label title = toolkit.createLabel(containerRight, titletext, 64);
        gd = new GridData(768);
        gd.widthHint = 100;
        gd.horizontalSpan = 2;
        title.setLayoutData((Object)gd);
        Composite containerLink = toolkit.createComposite(containerRight, 0);
        gridLayout = new GridLayout(2, false);
        containerLink.setLayout((Layout)gridLayout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        containerLink.setLayoutData((Object)gd);
        ImageHyperlink specLink = toolkit.createImageHyperlink(containerLink, 0);
        specLink.setText(Messages.OverviewPage_sectionRight_specLink_label);
        specLink.setImage(ImageShop.get("/icons/localvariable_obj.gif"));
        gd = new GridData();
        specLink.setLayoutData((Object)gd);
        specLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.editor.setActivePage("SpecificationPage");
            }
        });
        Label specLabel = toolkit.createLabel(containerLink, Messages.OverviewPage_sectionRight_spec_label, 64);
        gd = new GridData(768);
        gd.widthHint = 100;
        specLabel.setLayoutData((Object)gd);
        ImageHyperlink implLink = toolkit.createImageHyperlink(containerLink, 0);
        implLink.setText(Messages.OverviewPage_sectionRight_implLink_label);
        implLink.setImage(ImageShop.get("/icons/methpub_obj.gif"));
        gd = new GridData();
        gd.verticalIndent = 20;
        implLink.setLayoutData((Object)gd);
        implLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.editor.setActivePage("ImplementationPage");
            }
        });
        Label implLabel = toolkit.createLabel(containerLink, Messages.OverviewPage_sectionRight_impl_label, 64);
        gd = new GridData(768);
        gd.verticalIndent = 18;
        gd.widthHint = 100;
        implLabel.setLayoutData((Object)gd);
        sectionRight.setClient((Control)containerRight);
    }

    void bindName() {
        Pattern pattern = this.getPattern();
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME);
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        ISWTObservableValue uiObs = textProp.observeDelayed(400, (Widget)this.nameText);
        IObservableValue mObs = mprop.observe((Object)pattern);
        this.addBinding(this.ctx.bindValue((IObservableValue)uiObs, mObs, new EMFUpdateValueStrategy().setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        }), null));
    }

    void bindDescripition() {
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)FcorePackage.Literals.MODEL_ELEMENT__DESCRIPTION);
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        ISWTObservableValue uiObs = textProp.observeDelayed(400, (Widget)this.descripition);
        IObservableValue mObs = mprop.observe((Object)this.getPattern());
        this.addBinding(this.ctx.bindValue((IObservableValue)uiObs, mObs, new EMFUpdateValueStrategy().setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        }), null));
    }

    void bindContainer() {
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)PatternPackage.Literals.PATTERN_ELEMENT__CONTAINER);
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        ISWTObservableValue uiObs = textProp.observeDelayed(400, (Widget)this.fullNameText);
        IObservableValue mObs = mprop.observe((Object)this.getPattern());
        UpdateValueStrategy targetToModel = new EMFUpdateValueStrategy().setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        });
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter(new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return EReference.class;
            }

            public Object convert(Object fromObject) {
                if (fromObject == null || !(fromObject instanceof PatternLibrary)) {
                    return "";
                }
                return ((PatternLibrary)fromObject).getName();
            }
        });
        this.addBinding(this.ctx.bindValue((IObservableValue)uiObs, mObs, targetToModel, modelToTarget));
    }

    protected void bind() {
        if (this.getPattern() != null) {
            this.bindName();
            this.bindDescripition();
            this.bindContainer();
            this.patternNameEmpetyValidationAdapter = PatternUIHelper.addValidationAdapeter(this.mmng, this.getPattern(), "org.eclipse.egf.pattern.ui.PatternNameNotEmpty", (Control)this.nameText);
        }
    }

    public void dispose() {
        PatternUIHelper.removeAdapterForPattern(this.getPattern(), (AdapterImpl)this.patternNameEmpetyValidationAdapter);
        super.dispose();
    }
}

