/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.pages;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.model.pattern.BasicQuery;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.extension.PatternInitializer;
import org.eclipse.egf.pattern.query.IQuery;
import org.eclipse.egf.pattern.query.QueryKind;
import org.eclipse.egf.pattern.ui.ImageShop;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.PatternUIHelper;
import org.eclipse.egf.pattern.ui.contributions.EditHelper;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.adapter.LiveValidationContentAdapter;
import org.eclipse.egf.pattern.ui.editors.dialogs.ParametersEditDialog;
import org.eclipse.egf.pattern.ui.editors.dialogs.PatternSelectionDialog;
import org.eclipse.egf.pattern.ui.editors.models.QueryContent;
import org.eclipse.egf.pattern.ui.editors.modifiers.ParametersTableCellModifier;
import org.eclipse.egf.pattern.ui.editors.pages.PatternEditorPage;
import org.eclipse.egf.pattern.ui.editors.providers.ComboListLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.CommonListContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.ParametersTableLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.TableObservableListContentProvider;
import org.eclipse.egf.pattern.ui.editors.wizards.OpenTypeWizard;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecificationPage
extends PatternEditorPage {
    public static final String ID = "SpecificationPage";
    private Link parentLink;
    private Button add;
    private Button edit;
    private Button remove;
    private Button up;
    private Button down;
    private Button browse;
    private Button removeParent;
    private Combo combo;
    private TableViewer tableViewer;
    private FormColors colors = new FormColors(Display.getDefault());
    public static final String NAME_COLUMN_ID = "Name";
    public static final String TYPE_COLUMN_ID = "Type";
    public static final String QUERY_COLUMN_ID = "Query";
    private static final String NO_QUERY_VALUE = "";
    private static final String PARAMETER_NAME_DEFAULT_VALUE = "parameter";
    private static final String PARAMETER_TYPE_DEFAULT_VALUE = "http://www.eclipse.org/emf/2002/Ecore#//EClass";
    private int dragIndex = -1;
    private ComboBoxViewerCellEditor queryEditor;
    private boolean isReadOnly;
    private LiveValidationContentAdapter parameterNameEmpetyValidationAdapter;
    private IMessageManager mmng;
    private int comboSelectIndex;

    public SpecificationPage(FormEditor editor) {
        super(editor, ID, Messages.SpecificationPage_title);
    }

    @Override
    protected void doCreateFormContent(IManagedForm managedForm) {
        PatternEditorInput editorInput = (PatternEditorInput)this.getEditorInput();
        this.mmng = managedForm.getMessageManager();
        this.isReadOnly = editorInput.isReadOnly();
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        toolkit.decorateFormHeading(form.getForm());
        GridLayout layout = new GridLayout(2, true);
        form.getBody().setLayout((Layout)layout);
        form.setImage(ImageShop.get("/icons/plugin_mf_obj.gif"));
        form.setText(Messages.SpecificationPage_title);
        Composite containerLeft = this.createComposite(toolkit, form);
        this.createInheritanceSection(toolkit, containerLeft);
        this.createParametersSection(toolkit, containerLeft);
        Composite containerRight = this.createComposite(toolkit, form);
        this.createPatternNatureSection(toolkit, containerRight);
        this.checkReadOnlyModel();
        form.reflow(true);
    }

    private Composite createComposite(FormToolkit toolkit, ScrolledForm form) {
        Composite composite = toolkit.createComposite(form.getBody(), 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1810);
        composite.setLayoutData((Object)gd);
        return composite;
    }

    private void checkReadOnlyModel() {
        if (!this.isReadOnly) {
            return;
        }
        this.parentLink.setEnabled(false);
        this.browse.setEnabled(false);
        this.removeParent.setEnabled(false);
        this.add.setEnabled(false);
        this.edit.setEnabled(false);
        this.remove.setEnabled(false);
        this.up.setEnabled(false);
        this.down.setEnabled(false);
        this.combo.setEnabled(false);
    }

    private void createInheritanceSection(FormToolkit toolkit, Composite form) {
        Section inherSection = toolkit.createSection(form, 256);
        inherSection.setText(Messages.SpecificationPage_inherSection_title);
        GridData gd = new GridData(1810);
        inherSection.setLayoutData((Object)gd);
        Composite inheritance = toolkit.createComposite((Composite)inherSection, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        inheritance.setLayout((Layout)layout);
        gd = new GridData(1808);
        inheritance.setLayoutData((Object)gd);
        Label discrip = toolkit.createLabel(inheritance, Messages.SpecificationPage_inherSection_discrip_label);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalIndent = 4;
        discrip.setLayoutData((Object)gd);
        Label parentLabel = toolkit.createLabel(inheritance, Messages.SpecificationPage_inherSection_parent_label);
        gd = new GridData();
        gd.verticalIndent = 10;
        parentLabel.setLayoutData((Object)gd);
        parentLabel.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        this.parentLink = new Link(inheritance, 0);
        gd = new GridData(832);
        gd.verticalIndent = 10;
        gd.widthHint = 20;
        this.parentLink.setLayoutData((Object)gd);
        this.parentLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.openParentPatternEditor();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createInheritanceButtons(toolkit, inheritance);
        inherSection.setClient((Control)inheritance);
    }

    protected void openParentPatternEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        EditHelper.openPatternEditor(activePage, this.getPattern().getSuperPattern().getID());
    }

    private void createInheritanceButtons(FormToolkit toolkit, Composite Inheritance) {
        Composite buttons = toolkit.createComposite(Inheritance, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalIndent = 10;
        gd.widthHint = 65;
        this.browse = toolkit.createButton(buttons, Messages.SpecificationPage_button_browse, 8);
        this.browse.setLayoutData((Object)gd);
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PatternSelectionDialog dialog = new PatternSelectionDialog(new Shell(), SpecificationPage.this.getParentPattern());
                dialog.setTitle(Messages.SpecificationPage_browse_dialog_title);
                if (dialog.open() == 0) {
                    final Pattern parent = dialog.getParent();
                    TransactionalEditingDomain editingDomain = SpecificationPage.this.getEditingDomain();
                    RecordingCommand cmd = new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            SpecificationPage.this.getPattern().setSuperPattern(parent);
                        }
                    };
                    editingDomain.getCommandStack().execute((Command)cmd);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeParent = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.removeParent.setLayoutData((Object)gd);
        this.removeParent.setImage(ImageShop.get("/icons/delete.gif"));
        this.removeParent.setToolTipText(Messages.SpecificationPage_button_remove);
        this.removeParent.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransactionalEditingDomain editingDomain = SpecificationPage.this.getEditingDomain();
                RecordingCommand cmd = new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        SpecificationPage.this.getPattern().setSuperPattern(null);
                    }
                };
                editingDomain.getCommandStack().execute((Command)cmd);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createPatternNatureSection(FormToolkit toolkit, Composite form) {
        Section patternSection = toolkit.createSection(form, 256);
        patternSection.setText(Messages.SpecificationPage_patternSection_title);
        GridData gd = new GridData(1808);
        patternSection.setLayoutData((Object)gd);
        Composite pattern = toolkit.createComposite((Composite)patternSection, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        pattern.setLayout((Layout)layout);
        Label discrip = toolkit.createLabel(pattern, Messages.SpecificationPage_patternSection_discrip_label, 64);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 4;
        gd.widthHint = 100;
        discrip.setLayoutData((Object)gd);
        this.createTypeArea(toolkit, pattern);
        patternSection.setClient((Control)pattern);
    }

    private void createTypeArea(FormToolkit toolkit, final Composite composite) {
        Label type = toolkit.createLabel(composite, Messages.SpecificationPage_patternSection_type_label);
        GridData gd = new GridData();
        gd.verticalIndent = 10;
        type.setLayoutData((Object)gd);
        type.setForeground(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        this.combo = new Combo(composite, 8);
        Object[] natures = SpecificationPage.getNatures().keySet().toArray();
        int i = 0;
        while (i < natures.length) {
            PatternNature currentNature = (PatternNature)natures[i];
            String currentNatureName = ExtensionHelper.getName((PatternNature)currentNature);
            this.combo.add(currentNatureName);
            ++i;
        }
        this.combo.select(0);
        gd = new GridData(768);
        gd.verticalIndent = 10;
        gd.widthHint = 50;
        this.combo.setLayoutData((Object)gd);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.executeNatureChange(composite);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void executeNatureChange(Composite composite) {
        String message = Messages.SpecificationPage_change_nature_type;
        boolean openQuestion = MessageDialog.openQuestion((Shell)composite.getShell(), null, (String)message);
        if (openQuestion) {
            Pattern pattern = this.getPattern();
            PatternLibrary library = pattern.getContainer();
            IProject project = EGFCorePlugin.getPlatformFcore((Resource)library.eResource()).getPlatformBundle().getProject();
            try {
                PatternInitializer initializer = ExtensionHelper.getExtension((PatternNature)this.getPattern().getNature()).createInitializer(project, pattern);
                initializer.updateContent();
            }
            catch (PatternException e) {
                e.printStackTrace();
            }
            catch (ExtensionHelper.MissingExtensionException e) {
                e.printStackTrace();
            }
            this.comboSelectIndex = this.combo.getSelectionIndex();
        } else {
            this.combo.select(this.comboSelectIndex);
        }
        this.getEditor().doSave(null);
    }

    private void createParametersSection(FormToolkit toolkit, Composite form) {
        Composite composite = toolkit.createComposite(form, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Section paraSection = toolkit.createSection(composite, 256);
        paraSection.setText(Messages.SpecificationPage_paraSection_title);
        gd = new GridData(1808);
        paraSection.setLayoutData((Object)gd);
        Composite parameters = toolkit.createComposite((Composite)paraSection, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        parameters.setLayout((Layout)layout);
        Label discrip = toolkit.createLabel(parameters, Messages.SpecificationPage_paraSection_discrip_label, 64);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 4;
        gd.widthHint = 100;
        discrip.setLayoutData((Object)gd);
        this.createParametersTableArea(toolkit, parameters);
        this.createParametersButtons(toolkit, parameters);
        paraSection.setClient((Control)parameters);
    }

    private void createParametersTableArea(FormToolkit toolkit, Composite parameters) {
        Composite tableComp = new Composite(parameters, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        tableComp.setLayoutData((Object)gd);
        Table table = toolkit.createTable(tableComp, 68352);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gd = new GridData(1808);
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        this.tableViewer = new TableViewer(table);
        String[] colNames = new String[]{Messages.SpecificationPage_column_title_name, Messages.SpecificationPage_column_title_type, Messages.SpecificationPage_column_title_query};
        int[] colWidths = new int[]{100, 80, 80};
        int i = 0;
        while (i < colNames.length) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setWidth(colWidths[i]);
            tableColumn.setText(colNames[i]);
            layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(colWidths[i], true));
            ++i;
        }
        this.initTableEditor();
        this.tableViewer.setContentProvider((IContentProvider)new TableObservableListContentProvider(this.tableViewer));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ParametersTableLabelProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SpecificationPage.this.isReadOnly) {
                    return;
                }
                SpecificationPage.this.setButtonsStatus();
            }
        });
        this.addDragDrop();
    }

    private void addDragDrop() {
        if (this.isReadOnly) {
            return;
        }
        this.tableViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                if (SpecificationPage.this.tableViewer.getSelection() == null) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (SpecificationPage.this.tableViewer.getSelection() != null) {
                    SpecificationPage.this.dragIndex = SpecificationPage.this.tableViewer.getTable().getSelectionIndex();
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.tableViewer.addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.tableViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }

            public boolean performDrop(Object data) {
                Object currentTarget = this.getCurrentTarget();
                SpecificationPage.this.executeChangeOrder(currentTarget);
                return false;
            }
        });
    }

    protected void executeChangeOrder(Object currentTarget) {
        EList allParameters = this.getPattern().getAllParameters();
        Object currentSource = allParameters.get(this.dragIndex);
        BasicEList allParametersNew = new BasicEList();
        int targetIndex = 0;
        int index = 0;
        if (currentTarget == null) {
            targetIndex = this.tableViewer.getTable().getItemCount() - 1;
            currentTarget = this.tableViewer.getElementAt(targetIndex);
        } else {
            for (Object parameter : allParameters) {
                if (currentTarget.equals(parameter)) {
                    targetIndex = index;
                    break;
                }
                ++index;
            }
        }
        int i = 0;
        while (i < allParameters.size()) {
            if (i == targetIndex) {
                if (targetIndex > this.dragIndex) {
                    allParametersNew.add((Object)((PatternParameter)currentTarget));
                    allParametersNew.add((Object)((PatternParameter)currentSource));
                } else {
                    allParametersNew.add((Object)((PatternParameter)currentSource));
                    allParametersNew.add((Object)((PatternParameter)currentTarget));
                }
            } else if (i != this.dragIndex) {
                allParametersNew.add((Object)((PatternParameter)allParameters.get(i)));
            }
            ++i;
        }
        this.updateAllParameters((BasicEList<PatternParameter>)allParametersNew);
        this.tableViewer.getTable().setSelection(targetIndex);
        this.setButtonsStatus();
    }

    private void createParametersButtons(FormToolkit toolkit, Composite parameters) {
        Composite buttons = toolkit.createComposite(parameters, 0);
        GridLayout layout = new GridLayout();
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.widthHint = 65;
        this.add = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.add.setLayoutData((Object)gd);
        this.add.setImage(ImageShop.get("/icons/add.gif"));
        this.add.setToolTipText(Messages.SpecificationPage_button_add);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.executeAdd();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.edit = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.edit.setLayoutData((Object)gd);
        this.edit.setEnabled(false);
        this.edit.setImage(ImageShop.get("/icons/edit.gif"));
        this.edit.setToolTipText(Messages.SpecificationPage_button_edit);
        this.edit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = SpecificationPage.this.tableViewer.getSelection();
                final Object selectItem = ((IStructuredSelection)selection).getFirstElement();
                if (selectItem instanceof PatternParameter) {
                    PatternParameter patternParameter = (PatternParameter)selectItem;
                    final ParametersEditDialog dialog = new ParametersEditDialog(new Shell(), patternParameter, SpecificationPage.this.getEditingDomain());
                    dialog.setTitle(Messages.SpecificationPage_parametersEditDialog_title);
                    if (dialog.open() == 0) {
                        TransactionalEditingDomain editingDomain = SpecificationPage.this.getEditingDomain();
                        RecordingCommand cmd = new RecordingCommand(editingDomain){

                            protected void doExecute() {
                                SpecificationPage.this.executeParameterEdit(dialog, selectItem);
                            }
                        };
                        editingDomain.getCommandStack().execute((Command)cmd);
                    }
                }
                SpecificationPage.this.tableViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.remove = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.remove.setLayoutData((Object)gd);
        this.remove.setEnabled(false);
        this.remove.setImage(ImageShop.get("/icons/delete.gif"));
        this.remove.setToolTipText(Messages.SpecificationPage_button_remove);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.exectueRemove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.up = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.up.setLayoutData((Object)gd);
        this.up.setEnabled(false);
        this.up.setImage(ImageShop.get("/icons/upward.gif"));
        this.up.setToolTipText(Messages.SpecificationPage_button_up);
        this.up.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.executeUpOrDown(-1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.down = toolkit.createButton(buttons, NO_QUERY_VALUE, 8);
        this.down.setLayoutData((Object)gd);
        this.down.setEnabled(false);
        this.down.setImage(ImageShop.get("/icons/downward.gif"));
        this.down.setToolTipText(Messages.SpecificationPage_button_down);
        this.down.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecificationPage.this.executeUpOrDown(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void executeParameterEdit(ParametersEditDialog dialog, Object selectItem) {
        String newName = dialog.getName();
        String newType = dialog.getType();
        String newQuey = dialog.getQuery();
        QueryKind queryKind = IQuery.INSTANCE.getQueryKindByName(newQuey);
        if (queryKind != null) {
            newQuey = queryKind.getId();
        }
        if (selectItem instanceof PatternParameter) {
            PatternParameter item = (PatternParameter)selectItem;
            item.setName(newName);
            item.setType(newType);
            Query queryItem = item.getQuery();
            if (queryItem != null) {
                queryItem.setExtensionId(newQuey);
                this.setQueryContent(dialog, queryItem);
            } else if (!NO_QUERY_VALUE.equals(newQuey)) {
                BasicQuery query = PatternFactory.eINSTANCE.createBasicQuery();
                query.setExtensionId(newQuey);
                item.setQuery((Query)query);
                query.setParameter(item);
                this.setQueryContent(dialog, (Query)query);
            }
            if (NO_QUERY_VALUE.equals(queryItem)) {
                item.setQuery(null);
            }
        }
    }

    private void setQueryContent(ParametersEditDialog dialog, Query query) {
        List<QueryContent> queryContents = dialog.getQueryContents();
        EMap queryContext = query.getQueryContext();
        if (queryContext != null && !queryContext.isEmpty()) {
            queryContext.clear();
        }
        for (QueryContent queryContent : queryContents) {
            queryContext.put((Object)queryContent.getKey(), (Object)queryContent.getValue());
        }
    }

    private void setButtonsStatus() {
        int selectIndex = this.tableViewer.getTable().getSelectionIndex();
        if (selectIndex == -1) {
            this.edit.setEnabled(false);
            this.remove.setEnabled(false);
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            return;
        }
        int length = this.tableViewer.getTable().getItemCount();
        if (length > 0) {
            this.remove.setEnabled(true);
            this.edit.setEnabled(true);
        } else {
            this.remove.setEnabled(false);
            this.edit.setEnabled(false);
        }
        if (selectIndex <= 0) {
            this.up.setEnabled(false);
        } else {
            this.up.setEnabled(true);
        }
        if (selectIndex + 1 == length) {
            this.down.setEnabled(false);
        } else {
            this.down.setEnabled(true);
        }
    }

    private static Map<PatternNature, PatternExtension> getNatures() {
        HashMap<PatternNature, PatternExtension> result = new HashMap<PatternNature, PatternExtension>();
        for (PatternExtension ext : ExtensionHelper.getExtensions().values()) {
            result.put(ext.getNature(), ext);
        }
        return result;
    }

    protected void exectueRemove() {
        int index = this.tableViewer.getTable().getSelectionIndex();
        final Pattern pattern = this.getPattern();
        ISelection selection = this.tableViewer.getSelection();
        final Object[] removeThem = ((IStructuredSelection)selection).toArray();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                Object[] objectArray = removeThem;
                int n = removeThem.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof PatternParameter) {
                        pattern.getParameters().remove(object);
                    }
                    ++n2;
                }
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        int len = this.tableViewer.getTable().getItemCount();
        if (index < len) {
            this.tableViewer.getTable().setSelection(index);
        } else if (index >= len) {
            this.tableViewer.getTable().setSelection(index - 1);
        }
        this.setButtonsStatus();
    }

    protected void executeAdd() {
        final Pattern pattern = this.getPattern();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                PatternParameter newPatternParameter = PatternFactory.eINSTANCE.createPatternParameter();
                newPatternParameter.setName(SpecificationPage.PARAMETER_NAME_DEFAULT_VALUE);
                newPatternParameter.setType(SpecificationPage.PARAMETER_TYPE_DEFAULT_VALUE);
                pattern.getParameters().add((Object)newPatternParameter);
                PatternUIHelper.addAdapterForNewItem(SpecificationPage.this.tableViewer, newPatternParameter);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        EList allParameters = pattern.getAllParameters();
        int len = allParameters.size();
        this.tableViewer.getTable().setSelection(len - 1);
        this.setButtonsStatus();
    }

    private void executeUpOrDown(int num) {
        int oldIndex = this.tableViewer.getTable().getSelectionIndex();
        int newIndex = oldIndex + num;
        EList allParameters = this.getPattern().getAllParameters();
        BasicEList allParametersNew = new BasicEList();
        int i = 0;
        while (i < allParameters.size()) {
            if (i == newIndex) {
                allParametersNew.add((Object)((PatternParameter)allParameters.get(oldIndex)));
            } else if (i == oldIndex) {
                allParametersNew.add((Object)((PatternParameter)allParameters.get(newIndex)));
            } else {
                allParametersNew.add((Object)((PatternParameter)allParameters.get(i)));
            }
            ++i;
        }
        this.updateAllParameters((BasicEList<PatternParameter>)allParametersNew);
        this.tableViewer.getTable().setSelection(newIndex);
        this.setButtonsStatus();
    }

    private void updateAllParameters(final BasicEList<PatternParameter> allParametersNew) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                SpecificationPage.this.getPattern().getParameters().removeAll((Collection)SpecificationPage.this.getPattern().getParameters());
                SpecificationPage.this.getPattern().getParameters().addAll((Collection)allParametersNew);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    private void initTableEditor() {
        if (this.isReadOnly) {
            return;
        }
        this.tableViewer.setColumnProperties(new String[]{NAME_COLUMN_ID, TYPE_COLUMN_ID, QUERY_COLUMN_ID});
        TextCellEditor nameEditor = new TextCellEditor((Composite)this.tableViewer.getTable());
        DialogCellEditor typeEditor = new DialogCellEditor((Composite)this.tableViewer.getTable()){

            protected Object openDialogBox(Control cellEditorWindow) {
                OpenTypeWizard wizard = new OpenTypeWizard(SpecificationPage.this.getEditingDomain(), SpecificationPage.this.getSelectItemType());
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int returnValue = dialog.open();
                if (returnValue == 0) {
                    if (wizard.getSelectType() instanceof String) {
                        String selectType = (String)wizard.getSelectType();
                        SpecificationPage.this.updateType(selectType);
                    } else if (wizard.getSelectType() instanceof BinaryType) {
                        String selectType = ((BinaryType)wizard.getSelectType()).getFullyQualifiedName();
                        SpecificationPage.this.updateType(selectType);
                    }
                }
                return null;
            }
        };
        this.queryEditor = new ComboBoxViewerCellEditor((Composite)this.tableViewer.getTable(), 0);
        this.queryEditor.setLabelProvider((IBaseLabelProvider)new ComboListLabelProvider());
        this.queryEditor.setContenProvider((IStructuredContentProvider)new CommonListContentProvider());
        this.setComboViewerInput();
        this.tableViewer.setCellEditors(new CellEditor[]{nameEditor, typeEditor, this.queryEditor});
        ParametersTableCellModifier modifier = new ParametersTableCellModifier(this.getEditingDomain(), this.tableViewer);
        this.tableViewer.setCellModifier((ICellModifier)modifier);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List availableQueries = IQuery.INSTANCE.getAvailableQueries();
                availableQueries.add(0, SpecificationPage.NO_QUERY_VALUE);
                SpecificationPage.this.queryEditor.setInput((Object)availableQueries);
            }
        });
    }

    private void updateType(final String selectType) {
        ISelection selection;
        Object selectItem;
        if (selectType != null && !NO_QUERY_VALUE.equals(selectType) && (selectItem = ((IStructuredSelection)(selection = this.tableViewer.getSelection())).getFirstElement()) instanceof PatternParameter) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    ((PatternParameter)selectItem).setType(selectType);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            this.tableViewer.refresh();
        }
    }

    private void setComboViewerInput() {
        List availableQueries = IQuery.INSTANCE.getAvailableQueries();
        availableQueries.add(0, NO_QUERY_VALUE);
        this.queryEditor.setInput((Object)availableQueries);
    }

    private String getSelectItemType() {
        int selectionIndex = this.tableViewer.getTable().getSelectionIndex();
        Object selectItem = this.tableViewer.getElementAt(selectionIndex);
        if (selectItem instanceof PatternParameter) {
            return ((PatternParameter)selectItem).getType();
        }
        return NO_QUERY_VALUE;
    }

    @Override
    protected void bind() {
        if (this.getPattern() != null) {
            this.bindParent();
            this.bindNature();
            this.bindTableViewer();
            this.parameterNameEmpetyValidationAdapter = PatternUIHelper.addValidationAdapeter(this.mmng, this.getPattern(), "org.eclipse.egf.pattern.ui.PatternParameterNameNotEmpty", (Control)this.tableViewer.getTable());
        }
    }

    void bindParent() {
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)PatternPackage.Literals.PATTERN__SUPER_PATTERN);
        IWidgetValueProperty textProp = WidgetProperties.text();
        ISWTObservableValue uiObs = textProp.observeDelayed(400, (Widget)this.parentLink);
        IObservableValue mObs = mprop.observe((Object)this.getPattern());
        UpdateValueStrategy targetToModel = new EMFUpdateValueStrategy().setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        });
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter(new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return EReference.class;
            }

            public Object convert(Object fromObject) {
                if (fromObject == null || !(fromObject instanceof Pattern)) {
                    return Messages.SpecificationPage_No_patent;
                }
                return "<a> " + ((Pattern)fromObject).getName() + " </a>";
            }
        });
        this.addBinding(this.ctx.bindValue((IObservableValue)uiObs, mObs, targetToModel, modelToTarget));
    }

    void bindNature() {
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)PatternPackage.Literals.PATTERN__NATURE);
        IWidgetValueProperty comboProp = WidgetProperties.selection();
        ISWTObservableValue uiObs = comboProp.observeDelayed(400, (Widget)this.combo);
        IObservableValue mObs = mprop.observe((Object)this.getPattern());
        UpdateValueStrategy targetToModel = new EMFUpdateValueStrategy().setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        });
        targetToModel.setConverter(new IConverter(){

            public Object getToType() {
                return EReference.class;
            }

            public Object getFromType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                if (fromObject == null || !(fromObject instanceof String)) {
                    return SpecificationPage.NO_QUERY_VALUE;
                }
                if (fromObject.equals(ExtensionHelper.getName((PatternNature)SpecificationPage.this.getPattern().getNature()))) {
                    return SpecificationPage.this.getPattern().getNature();
                }
                return ExtensionHelper.createNature((String)((String)fromObject));
            }
        });
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter(new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return EReference.class;
            }

            public Object convert(Object fromObject) {
                if (fromObject == null || !(fromObject instanceof PatternNature)) {
                    return SpecificationPage.NO_QUERY_VALUE;
                }
                return ExtensionHelper.getName((PatternNature)((PatternNature)fromObject));
            }
        });
        this.addBinding(this.ctx.bindValue((IObservableValue)uiObs, mObs, targetToModel, modelToTarget));
        if (this.combo != null && !this.combo.isDisposed()) {
            this.comboSelectIndex = this.combo.getSelectionIndex();
        }
    }

    private void bindTableViewer() {
        Pattern pattern = this.getPattern();
        if (pattern != null && this.tableViewer != null) {
            IEMFListProperty input = EMFProperties.list((EStructuralFeature)PatternPackage.Literals.PATTERN__PARAMETERS);
            IObservableList observe = input.observe((Object)pattern);
            this.tableViewer.setInput((Object)observe);
        }
    }

    public Pattern getParentPattern() {
        return this.getPattern() != null ? this.getPattern().getSuperPattern() : null;
    }

    public void dispose() {
        PatternUIHelper.removeAdapterForPattern(this.getPattern(), (AdapterImpl)this.parameterNameEmpetyValidationAdapter);
        super.dispose();
    }
}

