/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.egf.common.activator.EGFAbstractPlugin;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.common.log.IEGFLogger;
import org.eclipse.egf.common.log.IEGFLoggerFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EGFCommonPlugin
extends EGFAbstractPlugin {
    private static List<IEGFLogger> __egfLoggers;
    protected static EGFCommonPlugin __plugin;

    public static EGFCommonPlugin getDefault() {
        return __plugin;
    }

    public void start(BundleContext context_p) throws Exception {
        super.start(context_p);
        __plugin = this;
    }

    public void stop(BundleContext context_p) throws Exception {
        __egfLoggers = null;
        __plugin = null;
        super.stop(context_p);
    }

    public static List<IEGFLogger> getEGFLoggers() {
        if (__egfLoggers == null) {
            __egfLoggers = new ArrayList<IEGFLogger>();
            IConfigurationElement[] iConfigurationElementArray = ExtensionPointHelper.getConfigurationElements(EGFCommonPlugin.getDefault().getPluginID(), "logger");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                Object object = null;
                try {
                    object = ExtensionPointHelper.createInstance(configurationElement);
                }
                catch (CoreException ce) {
                    EGFCommonPlugin.getDefault().logError(ce);
                }
                if (object != null) {
                    if (!(object instanceof IEGFLoggerFactory)) {
                        EGFCommonPlugin.getDefault().logError(NLS.bind((String)"Wrong Class {0}", (Object)object.getClass().getName()));
                        EGFCommonPlugin.getDefault().logInfo(NLS.bind((String)"This Class should be a sub-type of ''{0}''.", (Object)IEGFLoggerFactory.class.getName()), 1);
                        EGFCommonPlugin.getDefault().logInfo(NLS.bind((String)"Bundle ''{0}''", (Object)ExtensionPointHelper.getNamespace(configurationElement)), 1);
                        EGFCommonPlugin.getDefault().logInfo(NLS.bind((String)"Extension-point ''{0}''", (Object)configurationElement.getName()), 1);
                    } else {
                        IEGFLogger logger = ((IEGFLoggerFactory)object).getLogger();
                        if (logger != null) {
                            __egfLoggers.add(logger);
                        }
                    }
                }
                ++n2;
            }
        }
        return __egfLoggers;
    }
}

