/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.presentation;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.ui.dialogs.LoadEcoreDialog;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EGFEcoreActionBarContributor
extends EcoreActionBarContributor {
    public EGFEcoreActionBarContributor() {
        this.loadResourceAction = new EGFExtendedLoadResourceAction();
    }

    public static class EGFExtendedLoadResourceAction
    extends LoadResourceAction {
        public void run() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            EGFExtendedLoadResourceDialog loadResourceDialog = new EGFExtendedLoadResourceDialog(shell, this.domain);
            if (loadResourceDialog.open() == 0 && !loadResourceDialog.getRegisteredPackages().isEmpty()) {
                String source = EcoreEditorPlugin.INSTANCE.getSymbolicName();
                BasicDiagnostic diagnosic = new BasicDiagnostic(1, source, 0, EcoreEditorPlugin.INSTANCE.getString("_UI_RuntimePackageDetail_message"), null);
                for (EPackage ePackage : loadResourceDialog.getRegisteredPackages()) {
                    diagnosic.add((Diagnostic)new BasicDiagnostic(1, source, 0, ePackage.getNsURI(), null));
                }
                new DiagnosticDialog(shell, EcoreEditorPlugin.INSTANCE.getString("_UI_Information_title"), EcoreEditorPlugin.INSTANCE.getString("_UI_RuntimePackageHeader_message"), (Diagnostic)diagnosic, 1).open();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EGFExtendedLoadResourceDialog
    extends LoadEcoreDialog {
        protected Set<EPackage> registeredPackages = new LinkedHashSet<EPackage>();

        public EGFExtendedLoadResourceDialog(Shell parent, EditingDomain domain) {
            super(parent, domain);
        }

        protected boolean processResource(Resource resource) {
            ResourceSet resourceSet = this.domain.getResourceSet();
            if (!resourceSet.getResources().contains((Object)resource)) {
                EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                for (EPackage ePackage : EMFHelper.getAllPackages((Resource)resource)) {
                    packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                    this.registeredPackages.add(ePackage);
                }
            }
            return true;
        }

        public Set<EPackage> getRegisteredPackages() {
            return this.registeredPackages;
        }
    }
}

