/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egf.core.domain.EGFResourceLoadedListener;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.AbstractPatternMethodEditorInput;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.RuntimePatternMethodEditorInput;
import org.eclipse.egf.pattern.ui.editors.WorkspacePatternMethodEditorInput;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class PatternTemplateEditor
extends MultiPageEditorPart
implements EGFResourceLoadedListener.ResourceUser {
    public static final String ID = "org.eclipse.egf.pattern.ui.pattern.template.editor.id";
    private final AdapterImpl methodAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME.equals(msg.getFeature()) && msg.getNotifier() instanceof PatternMethod) {
                PatternTemplateEditor.this.executeMethodEditorRename((PatternMethod)msg.getNotifier());
            }
        }
    };
    private final AdapterImpl patternAdapter = new AdapterImpl(){

        public void notifyChanged(final Notification msg) {
            if (FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME.equals(msg.getFeature()) && msg.getNotifier() instanceof Pattern) {
                PatternTemplateEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PatternTemplateEditor.this.setPartName((String)msg.getNewValue());
                    }
                });
            } else if (PatternPackage.Literals.PATTERN_ELEMENT__CONTAINER.equals(msg.getFeature()) && msg.getNewValue() == null) {
                PatternTemplateEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PatternTemplateEditor.this.getSite().getPage().closeEditor((IEditorPart)PatternTemplateEditor.this, false);
                    }
                });
            } else if (PatternPackage.Literals.PATTERN__METHODS.equals(msg.getFeature())) {
                PatternTemplateEditor.this.refreshTemplateEditor(msg);
            }
        }
    };
    private final Map<String, TextEditor> editors = new HashMap<String, TextEditor>();
    private boolean patternInWorkspace = false;
    private Pattern pattern;
    private final EGFResourceLoadedListener.ResourceListener resourceListener = new EGFResourceLoadedListener.ResourceListener(){

        public void resourceMoved(Resource movedResource, URI oldURI) {
            if (movedResource == PatternTemplateEditor.this.getResource()) {
                PatternTemplateEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PatternTemplateEditor.this.setInputWithNotify(new PatternEditorInput(PatternTemplateEditor.this.getResource(), ((PatternEditorInput)PatternTemplateEditor.this.getEditorInput()).getID()));
                        PatternTemplateEditor.this.firePropertyChange(1);
                    }
                });
            }
        }

        public void resourceDeleted(Resource deletedResource) {
            if (deletedResource == PatternTemplateEditor.this.getResource()) {
                PatternTemplateEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PatternTemplateEditor.this.getSite().getPage().closeEditor((IEditorPart)PatternTemplateEditor.this, false);
                    }
                });
            }
        }

        public void resourceReloaded(Resource reloadedResource) {
            if (reloadedResource == PatternTemplateEditor.this.getResource()) {
                final PatternEditorInput newEditorInput = new PatternEditorInput(PatternTemplateEditor.this.getResource(), ((PatternEditorInput)PatternTemplateEditor.this.getEditorInput()).getID());
                if (newEditorInput.getPattern() != null) {
                    PatternTemplateEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (PatternTemplateEditor.this.pattern != newEditorInput.getPattern()) {
                                PatternTemplateEditor.this.removePatternChangeAdapter();
                                PatternTemplateEditor.this.pattern = newEditorInput.getPattern();
                                PatternTemplateEditor.this.addPatternChangeAdapter();
                                if (newEditorInput.getFile() == null && PatternTemplateEditor.this.patternInWorkspace || newEditorInput.getFile() != null && !PatternTemplateEditor.this.patternInWorkspace) {
                                    int i = PatternTemplateEditor.this.getPageCount() - 1;
                                    while (i != -1) {
                                        PatternTemplateEditor.this.removePage(i);
                                        --i;
                                    }
                                    PatternTemplateEditor.this.patternInWorkspace = newEditorInput.getFile() != null;
                                    PatternTemplateEditor.this.createPages();
                                    if (PatternTemplateEditor.this.getPageCount() != 0) {
                                        PatternTemplateEditor.this.setActivePage(0);
                                    }
                                    PatternTemplateEditor.this.setInputWithNotify(newEditorInput);
                                }
                                PatternTemplateEditor.this.firePropertyChange(1);
                            }
                        }
                    });
                } else {
                    PatternTemplateEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PatternTemplateEditor.this.getSite().getPage().closeEditor((IEditorPart)PatternTemplateEditor.this, false);
                        }
                    });
                }
            }
        }

        public void externalUpdate(Resource changedResource) {
            PatternTemplateEditor.this.getResource();
        }

        public void internalUpdate(Resource changedResource) {
            PatternTemplateEditor.this.getResource();
        }
    };

    private void refreshTemplateEditor(Notification msg) {
        Object newValue = msg.getNewValue();
        Object oldValue = msg.getOldValue();
        int eventType = msg.getEventType();
        if (newValue != null && newValue instanceof PatternMethod || newValue == null && oldValue instanceof PatternMethod) {
            switch (eventType) {
                case 3: {
                    this.executeMethodEditorAdd((PatternMethod)newValue);
                    break;
                }
                case 4: {
                    this.executeMethodEditorRemove((PatternMethod)oldValue);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void executeMethodEditorRename(PatternMethod patternMethod) {
        IEditorPart editorPart = this.getEditorPart(patternMethod.getID());
        if (editorPart != null) {
            int i = 0;
            while (i < this.getPageCount()) {
                if (editorPart.equals(this.getEditor(i))) {
                    this.setPageText(i, patternMethod.getName());
                }
                ++i;
            }
        }
    }

    private void executeMethodEditorRemove(PatternMethod deleteMethod) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                int i = 0;
                while (i < PatternTemplateEditor.this.getPageCount()) {
                    IEditorPart editor = PatternTemplateEditor.this.getEditor(i);
                    AbstractPatternMethodEditorInput input = (AbstractPatternMethodEditorInput)editor.getEditorInput();
                    PatternMethod patternMethod = input.getPatternMethod();
                    if (patternMethod == null) {
                        PatternTemplateEditor.this.removePage(i);
                    }
                    ++i;
                }
            }
        });
    }

    protected void executeMethodEditorAdd(final PatternMethod addMethod) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                PatternTemplateEditor.this.createPage(addMethod);
            }
        });
        this.addMethodChangeAdapter(addMethod);
    }

    protected void addMethodChangeAdapter(PatternMethod method) {
        if (method != null && !method.eAdapters().contains((Object)this.methodAdapter)) {
            method.eAdapters().add((Object)this.methodAdapter);
        }
    }

    protected void removeMethodChangeAdapter(PatternMethod method) {
        if (method != null && method.eAdapters().contains((Object)this.methodAdapter)) {
            method.eAdapters().remove((Object)this.methodAdapter);
        }
    }

    private void addPatternChangeAdapter() {
        if (this.pattern != null && !this.pattern.eAdapters().contains((Object)this.patternAdapter)) {
            this.pattern.eAdapters().add((Object)this.patternAdapter);
            EList methods = this.pattern.getMethods();
            for (PatternMethod method : methods) {
                this.addMethodChangeAdapter(method);
            }
        }
    }

    protected void removePatternChangeAdapter() {
        if (this.pattern != null && this.pattern.eAdapters().contains((Object)this.patternAdapter)) {
            this.pattern.eAdapters().remove((Object)this.patternAdapter);
        }
        EList methods = this.pattern.getMethods();
        for (PatternMethod method : methods) {
            this.removeMethodChangeAdapter(method);
        }
    }

    void createPage(PatternMethod method) {
        try {
            TextEditor editor = new TextEditor(){
                {
                    this.setDocumentProvider((IDocumentProvider)(PatternTemplateEditor.this.patternInWorkspace ? new FileDocumentProvider() : new StorageDocumentProvider()));
                }
            };
            RuntimePatternMethodEditorInput input = null;
            input = this.patternInWorkspace ? new WorkspacePatternMethodEditorInput(method.eResource(), method.getID()) : new RuntimePatternMethodEditorInput(method.eResource(), method.getID());
            int index = this.addPage((IEditorPart)editor, input);
            this.setPageText(index, method.getName());
            this.editors.put(method.getID(), editor);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
            Activator.getDefault().logError(e);
        }
    }

    protected void createPages() {
        for (PatternMethod method : this.pattern.getMethods()) {
            this.createPage(method);
        }
    }

    public IEditorPart getEditorPart(String methodId) {
        return (IEditorPart)this.editors.get(methodId);
    }

    public void doSave(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.getPageCount()) {
            this.getEditor(i).doSave(monitor);
            ++i;
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof PatternEditorInput)) {
            throw new PartInitException(Messages.Editor_wrong_input);
        }
        super.init(site, editorInput);
        this.patternInWorkspace = ((PatternEditorInput)this.getEditorInput()).getFile() != null;
        this.pattern = ((PatternEditorInput)this.getEditorInput()).getPattern();
        EGFResourceLoadedListener.getResourceManager().addObserver((EGFResourceLoadedListener.ResourceUser)this);
        this.addPatternChangeAdapter();
        this.setPartName(this.pattern.getName());
    }

    public void dispose() {
        if (this.getEditorInput() != null && this.getEditorInput() instanceof PatternEditorInput) {
            this.removePatternChangeAdapter();
        }
        EGFResourceLoadedListener.getResourceManager().removeObserver((EGFResourceLoadedListener.ResourceUser)this);
        super.dispose();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Resource getResource() {
        PatternEditorInput input = (PatternEditorInput)this.getEditorInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        return input.getResource();
    }

    public void setActiveEditor(String methodId) {
        IEditorPart editorPart = this.getEditorPart(methodId);
        if (editorPart != null) {
            super.setActiveEditor(editorPart);
        }
    }

    public EGFResourceLoadedListener.ResourceListener getListener() {
        return this.resourceListener;
    }

    public IOperationHistory getOperationHistory() {
        return null;
    }

    public ObjectUndoContext getUndoContext() {
        return null;
    }

    public boolean userHasSavedResource() {
        return false;
    }

    public boolean resourceHasBeenExternallyChanged() {
        return false;
    }
}

